/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.subsetter.channel.ChannelSubsetter;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class EmbeddedChannel
implements WaveformProcess {
    ChannelSubsetter channelSubsetter;

    public EmbeddedChannel(ChannelSubsetter channelSubsetter) {
        this.channelSubsetter = channelSubsetter;
    }

    public EmbeddedChannel(Element config) throws ConfigurationException {
        NodeList childNodes = config.getChildNodes();
        for (int counter = 0; counter < childNodes.getLength(); ++counter) {
            Node node = childNodes.item(counter);
            if (!(node instanceof Element)) continue;
            this.channelSubsetter = (ChannelSubsetter)SodUtil.load((Element)node, "channel");
        }
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        return new WaveformResult(seismograms, this.channelSubsetter.accept(channel, Start.getNetworkArm().getNetworkSource()));
    }
}

