/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.EncodedData;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class CompressionType
implements WaveformProcess {
    int[] types;

    public CompressionType(Element el) {
        NodeList nl = el.getElementsByTagName("type");
        this.types = new int[nl.getLength()];
        for (int i = 0; i < nl.getLength(); ++i) {
            this.types[i] = DOMHelper.extractInt((Element)nl.item(i), ".", -1);
        }
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        for (int s = 0; s < seismograms.length; ++s) {
            if (!seismograms[s].is_encoded()) continue;
            EncodedData[] edata = seismograms[s].get_as_encoded();
            for (int i = 0; i < edata.length; ++i) {
                boolean found = false;
                for (int t = 0; t < this.types.length; ++t) {
                    if (edata[i].compression != this.types[t]) continue;
                    found = true;
                    break;
                }
                if (found) continue;
                return new WaveformResult(false, seismograms, this, "type " + edata[i].compression + " not accepted");
            }
        }
        return new WaveformResult(true, seismograms, this);
    }
}

