/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.DOMHelper;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.process.waveform.AbstractSeismogramWriter;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.time.Duration;
import org.w3c.dom.Element;

public class AsciiWriter
extends AbstractSeismogramWriter {
    public static final String DEFAULT_FILE_TEMPLATE = "Event_${event.getTime('yyyy_MM_dd_HH_mm_ss')}/${prefix}${channel.codes}${index}.txt";
    int columns = 1;
    String format = " +0.000000E00  ; -0.000000E00  ";
    boolean SHAKEheader = true;
    String winEOL = "";

    public AsciiWriter(Element el) throws ConfigurationException {
        this(AsciiWriter.extractWorkingDir(el), AsciiWriter.extractFileTemplate(el, DEFAULT_FILE_TEMPLATE), AsciiWriter.extractPrefix(el), DOMHelper.hasElement(el, "storeSeismogramsInDB"));
        this.columns = SodUtil.loadInt(el, "columns", 1);
    }

    public AsciiWriter(String workingDir, String fileTemplate, String prefix, boolean storeSeismogramsInDB) throws ConfigurationException {
        super(workingDir, fileTemplate, prefix, storeSeismogramsInDB);
    }

    @Override
    public SeismogramFileTypes getFileType() {
        return SeismogramFileTypes.SIMPLE_ASCII;
    }

    @Override
    public void write(String location, LocalSeismogramImpl seis, Channel chan, CacheEvent ev) throws Exception {
        File f = new File(location);
        PrintWriter writer = new PrintWriter(new BufferedWriter(new FileWriter(f)));
        writer.println("# " + ChannelIdUtil.toStringNoDates(chan) + " " + seis.getNumPoints() + " " + String.valueOf(seis.getSampling().getPeriod()) + " " + String.valueOf(seis.getBeginTime()) + " " + String.valueOf(seis.getUnit()) + this.winEOL);
        if (this.SHAKEheader) {
            writer.println(seis.getNumPoints() + "      " + TimeUtils.durationToDoubleSeconds((Duration)seis.getSampling().getPeriod()));
        }
        if (seis.can_convert_to_long()) {
            int[] asInts = seis.get_as_longs();
            for (int i = 0; i < asInts.length; ++i) {
                writer.println(asInts[i] + this.winEOL);
            }
        } else if (seis.can_convert_to_float()) {
            DecimalFormat df = new DecimalFormat(this.format);
            float[] asFloats = seis.get_as_floats();
            for (int i = 0; i < asFloats.length; ++i) {
                writer.print(df.format(asFloats[i]));
                if (i % this.columns != this.columns - 1) continue;
                writer.println(this.winEOL);
            }
        }
        writer.close();
        AbstractSeismogramWriter.addBytesWritten(f.length());
    }
}

