/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.SodUtil;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.measure.Measurement;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.Fail;
import edu.sc.seis.sod.status.Pass;
import org.w3c.dom.Element;

public abstract class AbstractWaveformMeasure
implements WaveformProcess {
    protected String name;

    public AbstractWaveformMeasure(Element config) {
        this.name = SodUtil.loadText(config, "name", SodUtil.getSimpleName(this.getClass()));
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        if (seismograms.length != 0) {
            Measurement m = this.calculate(event, channel, original, available, seismograms, cookieJar);
            cookieJar.addMeasurement(m.getName(), m.getValueJSON());
            return new WaveformResult(seismograms, new Pass(this));
        }
        return new WaveformResult(seismograms, new Fail(this));
    }

    public String getName() {
        return this.name;
    }

    abstract Measurement calculate(CacheEvent var1, Channel var2, RequestFilter[] var3, RequestFilter[] var4, LocalSeismogramImpl[] var5, MeasurementStorage var6) throws Exception;

    protected static float[] toFloatArrayAsIfContinuous(LocalSeismogramImpl[] seis) throws FissuresException {
        int npts = 0;
        for (int i = 0; i < seis.length; ++i) {
            npts += seis[i].getNumPoints();
        }
        float[] data = new float[npts];
        int pos = 0;
        for (int i = 0; i < seis.length; ++i) {
            System.arraycopy(seis[i].get_as_floats(), 0, data, pos, seis[i].getNumPoints());
            pos += seis[i].getNumPoints();
        }
        return data;
    }
}

