/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.process.waveform;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.ConfigurationException;
import edu.sc.seis.sod.hibernate.SeismogramFileRefDB;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.process.waveform.AbstractFileWriter;
import edu.sc.seis.sod.process.waveform.WaveformProcess;
import edu.sc.seis.sod.process.waveform.WaveformResult;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.velocity.PrintlineVelocitizer;
import org.json.JSONArray;
import org.json.JSONObject;

public abstract class AbstractSeismogramWriter
extends AbstractFileWriter
implements WaveformProcess {
    protected boolean storeSeismogramsInDB = false;
    public static final String SVN_PARAM = "sod_phaseStoN_ttp";
    static long bytesWritten = 0L;
    public static final String COOKIE_PREFIX = "SeisFile_";

    public AbstractSeismogramWriter(String workingDir, String fileTemplate, String prefix, boolean storeSeismogramsInDB) throws ConfigurationException {
        super(workingDir, fileTemplate, prefix);
        this.storeSeismogramsInDB = storeSeismogramsInDB;
        new PrintlineVelocitizer(new String[]{fileTemplate});
    }

    protected AbstractSeismogramWriter() throws ConfigurationException {
        this("seismograms", "Event_${event.getTime('yyyy_MM_dd_HH_mm_ss')}/${prefix}${channel.codes}${index}.unknown", "", false);
    }

    @Override
    public WaveformResult accept(CacheEvent event, Channel channel, RequestFilter[] original, RequestFilter[] available, LocalSeismogramImpl[] seismograms, MeasurementStorage cookieJar) throws Exception {
        int i;
        if (cookieJar == null) {
            throw new NullPointerException("CookieJar cannot be null");
        }
        if (channel == null) {
            throw new NullPointerException("Channel cannot be null");
        }
        JSONArray reqList = new JSONArray();
        for (i = 0; i < original.length; ++i) {
            JSONObject reqJSON = new JSONObject();
            reqJSON.put("start", (Object)original[i].startTime.toString());
            reqJSON.put("end", (Object)original[i].endTime.toString());
            reqList.put((Object)reqJSON);
        }
        cookieJar.addMeasurement("request", reqList);
        if (seismograms.length > 0) {
            this.removeExisting(event, channel, seismograms[0], seismograms.length);
            for (i = 0; i < seismograms.length; ++i) {
                String loc = this.generate(event, channel, seismograms[i], i, seismograms.length);
                StringTree mkdirResult = this.checkParentDirs(loc);
                if (!mkdirResult.isSuccess()) {
                    return new WaveformResult(seismograms, mkdirResult);
                }
                this.write(loc, seismograms[i], channel, event);
                if (this.storeSeismogramsInDB) {
                    SeismogramFileRefDB.getSingleton().saveSeismogramToDatabase(event, channel, seismograms[i], loc, this.getFileType());
                }
                cookieJar.addMeasurement(AbstractSeismogramWriter.getCookieName(this.prefix, channel, i), loc);
            }
        }
        return new WaveformResult(true, seismograms, this);
    }

    public abstract SeismogramFileTypes getFileType();

    public abstract void write(String var1, LocalSeismogramImpl var2, Channel var3, CacheEvent var4) throws Exception;

    public static void addBytesWritten(long bytes) {
        bytesWritten += bytes;
    }

    public static long getBytesWritten() {
        return bytesWritten;
    }

    public static String getCookieName(String prefix, Channel channel, int i) {
        return COOKIE_PREFIX + prefix + ChannelIdUtil.toString(channel) + "_" + i;
    }

    public static String getCookieName(String prefix, ChannelId channel, int i) {
        return COOKIE_PREFIX + prefix + ChannelIdUtil.toString(channel) + "_" + i;
    }
}

