/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.status;

import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import java.io.Serializable;

public class Status
implements Serializable {
    private Stage stage;
    private Standing standing;
    public static final Status[][] ALL = new Status[Stage.ALL.length][Standing.ALL.length];

    protected Status() {
    }

    private Status(Stage stage, Standing standing) {
        this.standing = standing;
        this.stage = stage;
    }

    public String toString() {
        return this.stage.toString() + " " + this.standing.toString();
    }

    public Standing getStanding() {
        return this.standing;
    }

    public Stage getStage() {
        return this.stage;
    }

    public short getAsShort() {
        return (short)((this.getStage().getVal() << 8) + this.getStanding().getVal());
    }

    public static Status getFromShort(short val) {
        return Status.get(Stage.getFromInt((val & 0xFF00) >>> 8), Standing.getFromInt(val & 0xFF));
    }

    public static Status get(Stage stage, Standing standing) {
        return ALL[stage.getVal()][standing.getVal()];
    }

    public int getStandingInt() {
        return this.standing.getVal();
    }

    protected void setStandingInt(int val) {
        this.standing = Standing.getFromInt(val);
    }

    public int getStageInt() {
        return this.stage.getVal();
    }

    protected void setStageInt(int val) {
        this.stage = Stage.getFromInt(val);
    }

    public static Status get(String nestedText) {
        for (int i = 0; i < ALL.length; ++i) {
            for (int j = 0; j < ALL[i].length; ++j) {
                if (!ALL[i][j].toString().equals(nestedText)) continue;
                return ALL[i][j];
            }
        }
        throw new IllegalArgumentException("No such status for string " + nestedText);
    }

    static {
        for (int stage = 0; stage < Stage.ALL.length; ++stage) {
            for (int standing = 0; standing < Standing.ALL.length; ++standing) {
                Status.ALL[stage][standing] = new Status(Stage.getFromInt(stage), Standing.getFromInt(standing));
            }
        }
    }
}

