/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.station;

import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.TimeFormatter;
import edu.sc.seis.sod.model.station.StationId;

public class StationIdUtil {
    public static boolean areEqual(StationId a, StationId b) {
        if (a == b) {
            return true;
        }
        return a.getStationCode().equals(b.getStationCode()) && a.getNetworkId().equals(b.getNetworkId()) && a.getStartTime().equals(b.getStartTime());
    }

    public static String toString(Station sta) {
        return StationIdUtil.toString(new StationId(sta));
    }

    public static String toString(StationId id) {
        if (id == null) {
            throw new IllegalArgumentException("id is NULL");
        }
        return id.getNetworkId() + "." + id.getStationCode() + "." + id.getStartTime().toString();
    }

    public static String toStringFormatDates(Station sta) {
        return StationIdUtil.toStringFormatDates(new StationId(sta));
    }

    public static String toStringFormatDates(StationId id) {
        return id.getNetworkId() + "." + id.getStationCode() + "." + TimeFormatter.format(id.getStartTime());
    }

    public static String toStringNoDates(Station sta) {
        return StationIdUtil.toStringNoDates(new StationId(sta));
    }

    public static String toStringNoDates(StationId id) {
        return id.getNetworkId() + "." + id.getStationCode();
    }

    public static boolean areEqual(Station a, Station b) {
        return StationIdUtil.areEqual(new StationId(a), new StationId(b));
    }
}

