/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.station;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.sod.model.station.NetworkId;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.util.regex.Pattern;

public class NetworkIdUtil {
    private static Pattern tempNetPattern = Pattern.compile("[1-9XYZ].?");
    public static final String DOT = ".";

    public static boolean isTemporary(Network net) {
        return NetworkIdUtil.isTemporary(net.getNetworkCode());
    }

    public static boolean isTemporary(NetworkId id) {
        return NetworkIdUtil.isTemporary(id.networkCode);
    }

    public static boolean isTemporary(String code) {
        return tempNetPattern.matcher(code).matches();
    }

    @Deprecated
    public static boolean areEqual(String a, String b) {
        return a.equals(b);
    }

    public static boolean areEqual(NetworkId a, NetworkId b) {
        if (!a.networkCode.equals(b.networkCode)) {
            return false;
        }
        return !NetworkIdUtil.isTemporary(a) || a.getStartYear() == b.getStartYear();
    }

    public static boolean areEqual(Network a, Network b) {
        if (!a.getNetworkCode().equals(b.getNetworkCode())) {
            return false;
        }
        return !NetworkIdUtil.isTemporary(a.getNetworkCode()) || a.getStartDateTime().equals(b.getStartDateTime());
    }

    public static String formId(String netCode, Instant time) {
        Object out = netCode;
        if (NetworkIdUtil.isTemporary(netCode)) {
            ZonedDateTime zdt = ZonedDateTime.ofInstant(time, TimeUtils.TZ_UTC);
            out = (String)out + zdt.getYear();
        }
        return out;
    }
}

