/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.station;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.TimeFormatter;
import edu.sc.seis.sod.model.station.ChannelId;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelIdUtil {
    private static final Logger logger = LoggerFactory.getLogger(ChannelIdUtil.class);

    public static boolean areEqual(Channel a, ChannelId b) {
        return ChannelIdUtil.areEqual(b, a);
    }

    public static boolean areEqual(ChannelId a, Channel b) {
        return ChannelIdUtil.areEqual(a, ChannelId.of(b));
    }

    public static boolean areEqual(ChannelId a, ChannelId b) {
        return a.getStationCode().equals(b.getStationCode()) && a.getLocCode().equals(b.getLocCode()) && a.getChannelCode().equals(b.getChannelCode()) && a.getNetworkId().equals(b.getNetworkId()) && a.getStartTime().equals(b.getStartTime());
    }

    public static boolean areEqualExceptForBeginTime(ChannelId a, Channel b) {
        return ChannelIdUtil.areEqualExceptForBeginTime(a, ChannelId.of(b));
    }

    public static boolean areEqualExceptForBeginTime(ChannelId a, ChannelId b) {
        return a.getStationCode().equals(b.getStationCode()) && a.getLocCode().trim().equals(b.getLocCode().trim()) && a.getChannelCode().equals(b.getChannelCode()) && a.getNetworkCode().equals(b.getNetworkCode());
    }

    public static boolean areEqual(Channel a, Channel b) {
        return ChannelIdUtil.areEqual(new ChannelId(a), new ChannelId(b)) && a.getAzimuth().getValue() == b.getAzimuth().getValue() && a.getDip().getValue() == b.getDip().getValue() && a.getSampleRate().getValue() == b.getSampleRate().getValue();
    }

    public static String toStringNoDates(ChannelId id) {
        return id.getNetworkId() + "." + id.getStationCode() + "." + id.getLocCode() + "." + id.getChannelCode();
    }

    public static String toStringNoDates(Channel chan) {
        return ChannelIdUtil.toStringNoDates(new ChannelId(chan));
    }

    public static String toString(Channel chan) {
        return chan.getNetwork().getNetworkId() + "." + chan.getStationCode() + "." + chan.getLocCode() + "." + chan.getChannelCode() + "." + chan.getStartDate();
    }

    public static String toString(ChannelId id) {
        return id.getNetworkId() + "." + id.getStationCode() + "." + id.getLocCode() + "." + id.getChannelCode() + "." + String.valueOf(id.getStartTime());
    }

    public static ChannelId fromString(String s) {
        Pattern fdsnPattern = Pattern.compile("FDSN:([0-9A-Z]{1-8})\\.([0-9A-Z]{1,8})\\.([0-9A-Z]{1-8}:)+([0-9A-Z]{3,4})_(\\d{8}T\\d{6}\\.\\d{1-9}Z)");
        Matcher matcher = fdsnPattern.matcher(s);
        if (matcher.matches()) {
            return new ChannelId(matcher.group(1), matcher.group(2), matcher.group(3), matcher.group(4), TimeUtils.parseISOString((String)matcher.group(5)));
        }
        throw new RuntimeException("Doesn't match a channel id pattern: ");
    }

    public static String toStringFormatDates(ChannelId id) {
        return id.getNetworkId() + "." + id.getStationCode() + "." + id.getLocCode() + "." + id.getChannelCode() + "." + TimeFormatter.format(id.getStartTime());
    }

    public static String toStringFormatDates(Channel chan) {
        return chan.getNetworkId() + "." + chan.getStationCode() + "." + chan.getLocCode() + "." + chan.getChannelCode() + "." + TimeFormatter.format(chan.getStartDateTime());
    }

    public static String getBandCode(ChannelId id) {
        return ChannelIdUtil.getBandCode(id.getChannelCode());
    }

    public static String getBandCode(String channelCode) {
        return "" + channelCode.charAt(0);
    }

    public static String getGainCode(ChannelId id) {
        return ChannelIdUtil.getGainCode(id.getChannelCode());
    }

    public static String getGainCode(String channelCode) {
        return "" + channelCode.charAt(1);
    }

    public static String getOrientationCode(ChannelId id) {
        return ChannelIdUtil.getOrientationCode(id.getChannelCode());
    }

    public static String getOrientationCode(String channelCode) {
        return "" + channelCode.charAt(2);
    }

    public static int getDefaultAzimuth(String chanCode) {
        if (chanCode.endsWith("Z") || chanCode.endsWith("N")) {
            return 0;
        }
        if (chanCode.endsWith("E")) {
            return 90;
        }
        return -1;
    }

    public static int getDefaultDip(String chanCode) {
        if (chanCode.endsWith("E") || chanCode.endsWith("N")) {
            return 0;
        }
        if (chanCode.endsWith("Z")) {
            return -90;
        }
        return -1;
    }

    public static float minSPSForBandCode(String bandCode) {
        return ChannelIdUtil.minSPSForBandCode(bandCode.charAt(0));
    }

    public static float minSPSForBandCode(char bandCode) {
        float minSps = 0.0f;
        switch (bandCode) {
            case 'F': 
            case 'G': {
                minSps = 1000.0f;
                break;
            }
            case 'C': 
            case 'D': {
                minSps = 250.0f;
                break;
            }
            case 'E': {
                minSps = 80.0f;
                break;
            }
            case 'S': {
                minSps = 10.0f;
                break;
            }
            case 'H': {
                minSps = 80.0f;
                break;
            }
            case 'B': {
                minSps = 10.0f;
                break;
            }
            case 'M': {
                minSps = 1.0f;
                break;
            }
            case 'L': {
                minSps = 1.0f;
                break;
            }
            case 'V': {
                minSps = 0.1f;
                break;
            }
            case 'U': {
                minSps = 0.01f;
                break;
            }
            case 'R': {
                minSps = 0.001f;
                break;
            }
            default: {
                minSps = 1.0f;
            }
        }
        return minSps;
    }

    public static int hashCode(ChannelId id) {
        return 12 + ChannelIdUtil.toString(id).hashCode();
    }
}

