/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.station;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import java.time.Instant;

public class ChannelId {
    private String networkId;
    private String stationCode;
    private String locCode;
    private String channelCode;
    private Instant startTime;

    ChannelId() {
    }

    public static ChannelId of(Channel chan) {
        return new ChannelId(chan.getNetwork().getNetworkId(), chan.getStationCode(), chan.getLocCode(), chan.getChannelCode(), chan.getStartDateTime());
    }

    @Deprecated
    public ChannelId(Channel chan) {
        this(chan.getNetwork().getNetworkId(), chan.getStationCode(), chan.getLocCode(), chan.getChannelCode(), chan.getStartDateTime());
    }

    public ChannelId(Station station, String locationCode, String channelCode, Instant startTime) {
        this(station.getNetworkId(), station.getStationCode(), locationCode, channelCode, startTime);
    }

    public ChannelId(String networkId, String stationCode, String locCode, String channelCode, Instant startTime) {
        this.setNetworkId(networkId);
        this.setStationCode(stationCode);
        this.setLocCode(locCode);
        this.setChannelCode(channelCode);
        this.setStartTime(startTime);
    }

    public String getNetworkId() {
        return this.networkId;
    }

    public void setNetworkId(String networkId) {
        this.networkId = networkId;
    }

    public String getNetworkCode() {
        if (this.networkId.length() > 2) {
            return this.networkId.substring(0, 2);
        }
        return this.networkId;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public String getLocCode() {
        return this.locCode;
    }

    public void setLocCode(String locCode) {
        this.locCode = locCode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public void setStartTime(Instant startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        return this.getNetworkCode() + "_" + this.getStationCode() + "_" + this.getLocCode() + "_" + this.getChannelCode();
    }
}

