/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.station;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChannelGroup {
    protected int dbid;
    private Channel[] channels;
    private static final Logger logger = LoggerFactory.getLogger(ChannelGroup.class);

    public ChannelGroup(Channel[] channels) {
        assert (channels.length == 3);
        for (int i = 0; i < channels.length; ++i) {
            if (channels[i].getStationCode() != null) continue;
            throw new Error("station null in channel group");
        }
        this.channels = channels;
    }

    protected ChannelGroup() {
    }

    public void setDbid(int i) {
        this.dbid = i;
    }

    public int getDbid() {
        return this.dbid;
    }

    public Channel[] getChannels() {
        return this.channels;
    }

    public boolean contains(Channel c) {
        return this.getIndex(c) != -1;
    }

    public Channel getVertical() {
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i].getDip().getValue() == -90.0f) {
                return this.channels[i];
            }
            if (this.channels[i].getDip().getValue() != 90.0f) continue;
            return this.channels[i];
        }
        return null;
    }

    public Channel[] getHorizontal() {
        int[] indices = this.getHorizontalIndices();
        Channel[] out = new Channel[indices.length];
        for (int i = 0; i < indices.length; ++i) {
            out[i] = this.channels[indices[i]];
        }
        return out;
    }

    private int[] getHorizontalIndices() {
        int first = -1;
        for (int i = 0; i < this.channels.length; ++i) {
            if (this.channels[i].getDip().getValue() != 0.0f) continue;
            if (first == -1) {
                first = i;
                continue;
            }
            return new int[]{first, i};
        }
        if (first == -1) {
            return new int[0];
        }
        return new int[]{first};
    }

    public Channel[] getHorizontalXY() {
        return this.getHorizontalXY(2.0f);
    }

    public Channel[] getHorizontalXY(float toleranceDegrees) {
        Channel[] out = this.getHorizontal();
        if (out.length != 2) {
            out = new Channel[]{};
        } else if (!(Math.abs((360.0f + out[0].getAzimuth().getValue() - out[1].getAzimuth().getValue()) % 360.0f - 90.0f) < toleranceDegrees)) {
            if (Math.abs((360.0f + out[1].getAzimuth().getValue() - out[0].getAzimuth().getValue()) % 360.0f - 90.0f) < toleranceDegrees) {
                Channel tmp = out[0];
                out[0] = out[1];
                out[1] = tmp;
            } else {
                out = new Channel[]{};
            }
        }
        return out;
    }

    public Channel getChannel(ChannelId chanId, CacheEvent event) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (!ChannelIdUtil.areEqual(chanId, new ChannelId(this.channels[i]))) continue;
            return this.channels[i];
        }
        if (chanId.getNetworkId().equals(this.channels[0]) && chanId.getStationCode().equals(this.channels[0].getStationCode()) && chanId.getNetworkId().equals(this.channels[0].getNetworkId()) && chanId.getChannelCode().substring(0, 2).equals(this.channels[0].getCode().substring(0, 2))) {
            if (chanId.getChannelCode().endsWith("R")) {
                return this.getRadial(event);
            }
            if (chanId.getChannelCode().endsWith("T")) {
                return this.getTransverse(event);
            }
        }
        return null;
    }

    public void makeTransverseAndRadial(int transverseIndex, int radialIndex, CacheEvent event) {
        this.channels[radialIndex] = this.getRadial(event);
        this.channels[transverseIndex] = this.getTransverse(event);
    }

    public Channel getRadial(CacheEvent event) {
        return this.getRadial(event.extractOrigin().getLocation());
    }

    public Channel getRadial(Location eventLoc) {
        DistAz distAz = new DistAz(this.channels[0], eventLoc);
        return ChannelGroup.ofAzimuth(this.channels[0], (float)distAz.getRadialAzimuth(), Character.valueOf('R'));
    }

    public Channel getTransverse(CacheEvent event) {
        return this.getTransverse(event.extractOrigin().getLocation());
    }

    public Channel getTransverse(Location eventLoc) {
        DistAz distAz = new DistAz(this.channels[0], eventLoc);
        return ChannelGroup.ofAzimuth(this.channels[0], (float)distAz.getTransverseAzimuth(), Character.valueOf('T'));
    }

    public static Channel ofAzimuth(Channel orig, float azimuth, Character orientationCode) {
        Channel out = new Channel(orig.getStation(), orig.getLocCode(), ChannelGroup.replaceChannelOrientationCode(orig.getChannelCode(), orientationCode));
        out.setAzimuth(azimuth);
        out.setDepth(orig.getDepth());
        out.setDescription(orig.getDescription());
        out.setDip(orig.getDip());
        out.setElevation(orig.getElevation());
        out.setEndDateTime(orig.getEndDateTime());
        out.setLatitude(orig.getLatitude());
        out.setLongitude(orig.getLongitude());
        out.setResponse(orig.getResponse());
        out.setSampleRate(orig.getSampleRate());
        out.setStartDateTime(orig.getStartDateTime());
        return out;
    }

    private int getIndex(Channel chan) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (!this.channels[i].equals(chan)) continue;
            return i;
        }
        ChannelId chanId = new ChannelId(chan);
        for (int i = 0; i < this.channels.length; ++i) {
            if (!ChannelIdUtil.areEqual(new ChannelId(this.channels[i]), chanId)) continue;
            return i;
        }
        return -1;
    }

    public Channel getChannel1() {
        return this.getChannels()[0];
    }

    public Channel getChannel2() {
        return this.getChannels()[1];
    }

    public Channel getChannel3() {
        return this.getChannels()[2];
    }

    public Station getStation() {
        return this.getChannel1().getStation();
    }

    public Network getNetworkAttr() {
        return this.getStation().getNetwork();
    }

    public boolean areEqual(ChannelGroup other) {
        Channel[] otherChans = other.getChannels();
        for (int i = 0; i < otherChans.length; ++i) {
            if (!ChannelIdUtil.areEqual(this.getChannel1(), otherChans[i])) continue;
            for (int j = 0; j < otherChans.length; ++j) {
                if (j == i || !ChannelIdUtil.areEqual(this.getChannel2(), otherChans[j])) continue;
                for (int k = 0; k < otherChans.length; ++k) {
                    if (k == i || k == i || !ChannelIdUtil.areEqual(this.getChannel3(), otherChans[k])) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void setChannel(int index, Channel chan) {
        if (this.channels == null) {
            this.channels = new Channel[3];
        }
        this.channels[index] = chan;
    }

    protected void setChannel1(Channel chan) {
        this.setChannel(0, chan);
    }

    protected void setChannel2(Channel chan) {
        this.setChannel(1, chan);
    }

    protected void setChannel3(Channel chan) {
        this.setChannel(2, chan);
    }

    public static String replaceChannelOrientationCode(String chanCode, Character orientation) {
        return chanCode.substring(0, chanCode.length() - 1) + orientation;
    }

    public static ChannelId replaceChannelOrientation(ChannelId chanId, String orientation) {
        return new ChannelId(chanId.getNetworkId(), chanId.getStationCode(), chanId.getLocCode(), chanId.getChannelCode().substring(0, 2) + orientation, chanId.getStartTime());
    }
}

