/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.seismogram;

import edu.sc.seis.sod.model.common.ParameterRef;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnsupportedFormat;
import edu.sc.seis.sod.model.seismogram.Property;
import edu.sc.seis.sod.model.station.ChannelId;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;

public class SeismogramAttrImpl
implements Serializable {
    protected String id;
    public Property[] properties;
    public Instant begin_time;
    public int num_points;
    public SamplingImpl sampling_info;
    public UnitImpl y_unit;
    public ChannelId channel_id;
    public ParameterRef[] parm_ids;

    protected SeismogramAttrImpl() {
    }

    public static Serializable createEmpty() {
        return new SeismogramAttrImpl();
    }

    public SeismogramAttrImpl(String id, Instant begin_time, int num_points, SamplingImpl sample_info, UnitImpl y_unit, ChannelId channel_id) {
        this(id, new Property[0], begin_time, num_points, sample_info, y_unit, channel_id, new ParameterRef[0]);
    }

    public SeismogramAttrImpl(String id, Property[] properties, Instant begin_time, int num_points, SamplingImpl sample_info, UnitImpl y_unit, ChannelId channel_id, ParameterRef[] parm_ids) {
        this.id = id;
        this.begin_time = begin_time;
        this.num_points = num_points;
        this.sampling_info = sample_info;
        this.y_unit = y_unit;
        this.channel_id = channel_id;
        this.setProperties(properties);
        this.setParameterRefs(parm_ids);
    }

    public String get_id() {
        return this.id;
    }

    public int getNumPoints() {
        return this.num_points;
    }

    public void setProperties(Property[] props) {
        if (props == null) {
            throw new IllegalArgumentException("Cannot set null properties.");
        }
        this.properties = props;
    }

    public Property[] getProperties() {
        return this.properties;
    }

    public String getProperty(String name) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            return this.properties[i].value;
        }
        return null;
    }

    public void setProperty(String name, String value) {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals(name)) continue;
            this.properties[i].value = value;
            return;
        }
        Property[] props = new Property[this.properties.length + 1];
        System.arraycopy(this.properties, 0, props, 0, this.properties.length);
        props[this.properties.length] = new Property(name, value);
        this.setProperties(props);
    }

    public void setParameterRefs(ParameterRef[] parm_ids) {
        this.parm_ids = parm_ids;
    }

    public ParameterRef[] getParameterRefs() {
        return this.parm_ids;
    }

    public Instant getBeginTime() throws UnsupportedFormat {
        return this.begin_time;
    }

    public Duration getTimeInterval() {
        return this.getSampling().getPeriod().multipliedBy(this.num_points - 1);
    }

    public Instant getEndTime() {
        return this.getBeginTime().plus(this.getTimeInterval());
    }

    public String getName() {
        if (this.properties == null) {
            return this.get_id();
        }
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].name.equals("Name")) continue;
            return this.properties[i].value;
        }
        return this.get_id();
    }

    public void setName(String name) {
        int nameNum = -1;
        if (this.properties == null || this.properties.length == 0) {
            this.properties = new Property[1];
            nameNum = 0;
        } else {
            for (int i = 0; i < this.properties.length; ++i) {
                if (!this.properties[i].name.equals("Name")) continue;
                nameNum = i;
                break;
            }
            if (nameNum == -1) {
                Property[] tmp = new Property[this.properties.length + 1];
                System.arraycopy(this.properties, 0, tmp, 0, this.properties.length);
                nameNum = this.properties.length - 1;
                this.properties = tmp;
            }
        }
        this.properties[nameNum] = new Property("Name", name);
    }

    public UnitImpl getUnit() {
        return this.y_unit;
    }

    public ChannelId getChannelID() {
        return this.channel_id;
    }

    public SamplingImpl getSampling() {
        return this.sampling_info;
    }
}

