/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.seismogram;

import edu.sc.seis.seisFile.ChannelTimeWindow;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.station.ChannelId;
import java.time.Duration;
import java.time.Instant;

public final class RequestFilter {
    public ChannelId channelId;
    public Instant startTime;
    public Instant endTime;

    RequestFilter() {
    }

    public static RequestFilter of(LocalSeismogramImpl seismogram) {
        RequestFilter out = new RequestFilter();
        out.channelId = seismogram.getChannelID();
        out.startTime = seismogram.begin_time;
        out.endTime = seismogram.getEndTime();
        return out;
    }

    public RequestFilter(ChannelId channel, Instant start_time, Instant end_time) {
        this.channelId = channel;
        this.startTime = start_time;
        this.endTime = end_time;
    }

    public RequestFilter(Channel channel, Instant start_time, Instant end_time) {
        this.channelId = new ChannelId(channel);
        this.startTime = start_time;
        this.endTime = end_time;
    }

    public ChannelTimeWindow asChannelTimeWindow() {
        return new ChannelTimeWindow(this.channelId.getNetworkId(), this.channelId.getStationCode(), this.channelId.getLocCode(), this.channelId.getChannelCode(), this.startTime, this.endTime);
    }

    public Duration getDuration() {
        return Duration.between(this.startTime, this.endTime);
    }

    public ChannelId getChannelId() {
        return this.channelId;
    }

    public Instant getStartTime() {
        return this.startTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public String toString() {
        return String.valueOf(this.channelId) + " " + String.valueOf(this.startTime) + " " + String.valueOf(this.endTime);
    }
}

