/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.seismogram;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.seismogram.Plottable;
import edu.sc.seis.sod.model.util.LinearInterp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.sql.Timestamp;
import java.time.Duration;
import java.time.Instant;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.TimeZone;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PlottableChunk {
    private static final int MILLIS_IN_DAY = 86400000;
    public static final Duration ONE_DAY = Duration.ofDays(1L);
    public static final TimeZone utcTimeZone = TimeZone.getTimeZone("UTC");
    private long dbid;
    private String networkCode;
    private String stationCode;
    private String locCode;
    private String channelCode;
    private byte[] yBytes;
    private transient Plottable data = null;
    private int pixelsPerDay;
    private int beginPixel;
    private int numDataPoints;
    private int jday;
    private int year;
    private static final Logger logger = LoggerFactory.getLogger(PlottableChunk.class);

    protected PlottableChunk() {
    }

    public PlottableChunk(Plottable data, int startPixel, PlottableChunk otherStuff) {
        this(data, startPixel, otherStuff.getJDay(), otherStuff.getYear(), otherStuff.getPixelsPerDay(), otherStuff.getNetworkCode(), otherStuff.getStationCode(), otherStuff.getSiteCode(), otherStuff.getChannelCode());
    }

    public PlottableChunk(Plottable data, int startPixel, Instant startDate, int pixelsPerDay, String networkCode, String stationCode, String siteCode, String channelCode) {
        this(data, startPixel, PlottableChunk.getJDay(startDate), PlottableChunk.getYear(startDate), pixelsPerDay, networkCode, stationCode, siteCode, channelCode);
    }

    public PlottableChunk(Plottable data, int startPixel, int jday, int year, int pixelsPerDay, String networkCode, String stationCode, String siteCode, String channelCode) {
        this.data = data;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            DataOutputStream dos = new DataOutputStream(new GZIPOutputStream(out));
            for (int k = 0; k < data.y_coor.length; ++k) {
                dos.writeInt(data.y_coor[k]);
            }
            dos.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen with a ByteArrayOutputStream", e);
        }
        this.yBytes = out.toByteArray();
        if (startPixel >= pixelsPerDay) {
            int numDaysToAdd = startPixel / pixelsPerDay;
            Instant date = PlottableChunk.getDate(jday, year);
            date = date.plus(Duration.ofDays(numDaysToAdd));
            jday = PlottableChunk.getJDay(date);
            year = PlottableChunk.getYear(date);
            startPixel %= pixelsPerDay;
        }
        this.beginPixel = startPixel;
        this.pixelsPerDay = pixelsPerDay;
        this.numDataPoints = data.y_coor.length;
        this.jday = jday;
        this.year = year;
        this.networkCode = networkCode;
        this.stationCode = stationCode;
        this.locCode = siteCode;
        this.channelCode = channelCode;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof PlottableChunk) {
            PlottableChunk oChunk = (PlottableChunk)o;
            if (this.networkCode.equals(oChunk.networkCode) && this.stationCode.equals(oChunk.stationCode) && this.locCode.equals(oChunk.locCode) && this.channelCode.equals(oChunk.channelCode) && this.pixelsPerDay == oChunk.pixelsPerDay && this.jday == oChunk.jday && this.year == oChunk.year && this.getNumDataPoints() == oChunk.getNumDataPoints()) {
                return true;
            }
        }
        return false;
    }

    public static Instant getDate(int jday, int year) {
        return ZonedDateTime.of(year, 1, 1, 0, 0, 0, 0, TimeUtils.TZ_UTC).plusDays(jday - 1).toInstant();
    }

    public static Instant getTime(int pixel, int jday, int year, int pixelsPerDay) {
        Instant dayBegin = PlottableChunk.getDate(jday, year);
        double sampleMillis = LinearInterp.linearInterp(0.0, 0.0, pixelsPerDay, 8.64E7, pixel);
        sampleMillis = Math.floor(sampleMillis);
        return dayBegin.plusMillis(Math.round(sampleMillis));
    }

    public static int getJDay(Instant time) {
        return time.get(ChronoField.DAY_OF_YEAR);
    }

    public static int getYear(Instant time) {
        return time.get(ChronoField.YEAR);
    }

    public static Instant stripToDay(Instant d) {
        return d.truncatedTo(ChronoUnit.DAYS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Plottable getData() {
        PlottableChunk plottableChunk = this;
        synchronized (plottableChunk) {
            if (this.data == null) {
                int[] yValues = this.getYData();
                int[] xValues = new int[yValues.length];
                for (int i = 0; i < xValues.length; ++i) {
                    xValues[i] = i / 2;
                }
                this.data = new Plottable(xValues, yValues);
            }
        }
        return this.data;
    }

    public int getPixelsPerDay() {
        return this.pixelsPerDay;
    }

    public int getBeginPixel() {
        return this.beginPixel;
    }

    public int getNumPixels() {
        return this.getNumDataPoints() / 2;
    }

    public Instant getTime(int pixel) {
        return PlottableChunk.getTime(pixel, this.getJDay(), this.getYear(), this.getPixelsPerDay());
    }

    public Instant getBeginTime() {
        return this.getTime(this.beginPixel);
    }

    public Instant getEndTime() {
        return this.getTime(this.getBeginPixel() + this.getNumPixels());
    }

    public TimeRange getTimeRange() {
        return new TimeRange(this.getBeginTime(), this.getEndTime());
    }

    public int getJDay() {
        return this.jday;
    }

    public int getYear() {
        return this.year;
    }

    public int hashCode() {
        int hashCode = 81 + this.networkCode.hashCode();
        hashCode = 37 * hashCode + this.stationCode.hashCode();
        hashCode = 37 * hashCode + this.locCode.hashCode();
        hashCode = 37 * hashCode + this.channelCode.hashCode();
        hashCode = 37 * hashCode + this.pixelsPerDay;
        hashCode = 37 * hashCode + this.jday;
        hashCode = 37 * hashCode + this.year;
        return 37 * hashCode + this.getNumDataPoints();
    }

    public String toString() {
        return this.getNumPixels() + " pixel chunk from " + this.networkCode + "." + this.stationCode + "." + this.locCode + "." + this.channelCode + " at " + this.pixelsPerDay + " ppd from " + String.valueOf(this.getTimeRange());
    }

    public List<PlottableChunk> breakIntoDays() {
        int numDays = (int)Math.ceil((double)(this.beginPixel + this.getNumPixels()) / (double)this.getPixelsPerDay());
        ArrayList<PlottableChunk> dayChunks = new ArrayList<PlottableChunk>();
        Instant time = this.getBeginTime();
        for (int i = 0; i < numDays; ++i) {
            int firstDayPixels = this.pixelsPerDay - this.getBeginPixel();
            int startPixel = (i - 1) * this.pixelsPerDay + firstDayPixels;
            int stopPixel = i * this.pixelsPerDay + firstDayPixels;
            int pixelIntoNewDay = 0;
            if (i == 0) {
                startPixel = 0;
                stopPixel = firstDayPixels;
                pixelIntoNewDay = this.getBeginPixel();
            }
            if (i == numDays - 1) {
                stopPixel = this.getNumPixels();
            }
            int[] y = new int[(stopPixel - startPixel) * 2];
            System.arraycopy(this.getYData(), startPixel * 2, y, 0, y.length);
            Plottable p = new Plottable(null, y);
            dayChunks.add(new PlottableChunk(p, pixelIntoNewDay, PlottableChunk.getJDay(time), PlottableChunk.getYear(time), this.getPixelsPerDay(), this.getNetworkCode(), this.getStationCode(), this.getSiteCode(), this.getChannelCode()));
            time = time.plus(ONE_DAY);
        }
        return dayChunks;
    }

    protected void setData(Plottable data) {
        this.data = data;
    }

    protected void setPixelsPerDay(int pixelsPerDay) {
        this.pixelsPerDay = pixelsPerDay;
    }

    protected void setBeginPixel(int beginPixel) {
        this.beginPixel = beginPixel;
    }

    protected void setJday(int jday) {
        this.jday = jday;
    }

    protected void setYear(int year) {
        this.year = year;
    }

    public long getDbid() {
        return this.dbid;
    }

    protected void setDbid(long dbid) {
        this.dbid = dbid;
    }

    protected Timestamp getBeginTimestamp() {
        return Timestamp.from(this.getBeginTime());
    }

    protected void setBeginTimestamp(Timestamp begin) {
        Instant msd = begin.toInstant();
        this.year = msd.get(ChronoField.YEAR);
        this.jday = msd.get(ChronoField.DAY_OF_YEAR);
    }

    protected Timestamp getEndTimestamp() {
        return Timestamp.from(this.getEndTime());
    }

    protected void setEndTimestamp(Timestamp begin) {
    }

    public String getNetworkCode() {
        return this.networkCode;
    }

    public void setNetworkCode(String networkCode) {
        this.networkCode = networkCode;
    }

    public String getStationCode() {
        return this.stationCode;
    }

    public void setStationCode(String stationCode) {
        this.stationCode = stationCode;
    }

    public String getSiteCode() {
        return this.locCode;
    }

    public void setSiteCode(String siteCode) {
        this.locCode = siteCode;
    }

    public String getChannelCode() {
        return this.channelCode;
    }

    public void setChannelCode(String channelCode) {
        this.channelCode = channelCode;
    }

    public byte[] getYBytes() {
        return this.yBytes;
    }

    protected void setYBytes(byte[] bytes) {
        this.yBytes = bytes;
    }

    public int[] getYData() {
        return this.toIntArray(this.getYBytes());
    }

    private int[] toIntArray(byte[] bytes) {
        try {
            DataInputStream dis = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(bytes)));
            int[] decomp = new int[this.getNumDataPoints()];
            for (int i = 0; i < decomp.length; ++i) {
                decomp[i] = dis.readInt();
            }
            return decomp;
        }
        catch (IOException e) {
            throw new RuntimeException("Should never happen", e);
        }
    }

    public int getNumDataPoints() {
        return this.numDataPoints;
    }

    protected void setNumDataPoints(int numDataPoints) {
        this.numDataPoints = numDataPoints;
    }
}

