/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.seismogram;

import edu.iris.dmc.seedcodec.Codec;
import edu.iris.dmc.seedcodec.CodecException;
import edu.iris.dmc.seedcodec.DecompressedData;
import edu.iris.dmc.seedcodec.UnsupportedCompressionType;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.ParameterRef;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnitRangeImpl;
import edu.sc.seis.sod.model.seismogram.DataAppend;
import edu.sc.seis.sod.model.seismogram.EncodedData;
import edu.sc.seis.sod.model.seismogram.Property;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.model.seismogram.TimeSeriesType;
import edu.sc.seis.sod.model.station.ChannelId;
import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;

public class LocalSeismogramImpl
extends SeismogramAttrImpl {
    public TimeSeriesDataSel data;
    protected transient DecompressedData decomp = null;
    protected static transient Codec codec = new Codec();

    protected LocalSeismogramImpl() {
    }

    public static Serializable createEmpty() {
        return new LocalSeismogramImpl();
    }

    public LocalSeismogramImpl(String id, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, TimeSeriesDataSel data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], data);
    }

    public LocalSeismogramImpl(String id, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, int[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new TimeSeriesDataSel());
        this.data.int_values(data);
    }

    public LocalSeismogramImpl(String id, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, float[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new TimeSeriesDataSel());
        this.data.flt_values(data);
    }

    public LocalSeismogramImpl(String id, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, double[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new TimeSeriesDataSel());
        this.data.dbl_values(data);
    }

    public LocalSeismogramImpl(String id, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, short[] data) {
        this(id, new Property[0], begin_time, num_points, sampling, y_unit, channel_id, new ParameterRef[0], new TimeSeriesDataSel());
        this.data.sht_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, ParameterRef[] parm_ids, TimeSeriesDataSel data) {
        super(id, properties, begin_time, num_points, sampling, y_unit, channel_id, parm_ids);
        if (data == null) {
            this.num_points = 0;
        }
        if (y_unit == null) {
            throw new IllegalArgumentException("y_unit must not be null");
        }
        this.data = data;
    }

    public LocalSeismogramImpl(String id, Property[] properties, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, ParameterRef[] parm_ids, short[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, new TimeSeriesDataSel());
        this.data.sht_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, ParameterRef[] parm_ids, int[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, new TimeSeriesDataSel());
        this.data.int_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, ParameterRef[] parm_ids, float[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, new TimeSeriesDataSel());
        this.data.flt_values(data);
    }

    public LocalSeismogramImpl(String id, Property[] properties, Instant begin_time, int num_points, SamplingImpl sampling, UnitImpl y_unit, ChannelId channel_id, ParameterRef[] parm_ids, double[] data) {
        this(id, properties, begin_time, data.length, sampling, y_unit, channel_id, parm_ids, new TimeSeriesDataSel());
        this.data.dbl_values(data);
    }

    public LocalSeismogramImpl(SeismogramAttrImpl attr, short[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.sht_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttrImpl attr, int[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.int_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttrImpl attr, float[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.flt_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttrImpl attr, double[] data) {
        this(attr, new TimeSeriesDataSel());
        this.data.dbl_values(data);
        this.num_points = data.length;
    }

    public LocalSeismogramImpl(SeismogramAttrImpl attr, TimeSeriesDataSel data) {
        this(attr.get_id(), attr.properties, attr.begin_time, attr.num_points, attr.sampling_info, attr.y_unit, attr.channel_id, attr.parm_ids, data);
    }

    public void setAttributes(SeismogramAttrImpl attr) {
        this.begin_time = attr.begin_time;
        this.num_points = attr.num_points;
        this.sampling_info = attr.sampling_info;
        this.y_unit = attr.y_unit;
        this.channel_id = attr.channel_id;
        this.parm_ids = attr.parm_ids;
        this.setProperties(attr.properties);
    }

    public void setData(TimeSeriesDataSel data) {
        this.data = data;
        this.dataChanged();
    }

    public void setData(short[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.sht_values(data);
        this.setData(d);
    }

    public void setData(int[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.int_values(data);
        this.setData(d);
    }

    public void setData(float[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.flt_values(data);
        this.setData(d);
    }

    public void setData(double[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.dbl_values(data);
        this.setData(d);
    }

    public void setData(EncodedData[] data) {
        TimeSeriesDataSel d = new TimeSeriesDataSel();
        d.encoded_values(data);
        this.setData(d);
    }

    @Override
    public int getNumPoints() {
        return this.num_points;
    }

    public QuantityImpl getMinValue() throws CodecException {
        return this.getMinValue(0, this.getNumPoints());
    }

    public QuantityImpl getMinValue(int startIndex, int endIndex) throws CodecException {
        double min;
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (startIndex < 0) {
                            throw new IllegalArgumentException("Can't calculate min value for start index < 0, " + startIndex);
                        }
                        if (endIndex > this.getNumPoints()) {
                            throw new IllegalArgumentException("Can't calculate min value for end index > numPoints, " + endIndex + ", numPoints = " + this.getNumPoints());
                        }
                        if (startIndex >= endIndex) {
                            throw new IllegalArgumentException("Can't calculate min value for start index >= end index,  start index = " + startIndex + " endIndex = " + endIndex);
                        }
                        if (this.decomp == null) {
                            this.decodeBits();
                        }
                        min = 3.4028234663852886E38;
                        if (this.decomp.getType() != 3) break block8;
                        int[] iData = this.decomp.getAsInt();
                        for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                            if (!((double)iData[i] < min)) continue;
                            min = iData[i];
                        }
                        break block9;
                    }
                    if (this.decomp.getType() != 1) break block10;
                    short[] iData = this.decomp.getAsShort();
                    for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                        if (!((double)iData[i] < min)) continue;
                        min = iData[i];
                    }
                    break block9;
                }
                if (this.decomp.getType() != 4) break block11;
                float[] iData = this.decomp.getAsFloat();
                for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                    if (!((double)iData[i] < min)) continue;
                    min = iData[i];
                }
                break block9;
            }
            if (this.decomp.getType() != 5) break block9;
            double[] iData = this.decomp.getAsDouble();
            for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                if (!(iData[i] < min)) continue;
                min = iData[i];
            }
        }
        return new QuantityImpl(min, this.getUnit());
    }

    public QuantityImpl getMaxValue() throws CodecException {
        return this.getMaxValue(0, this.getNumPoints());
    }

    public QuantityImpl getMaxValue(int startIndex, int endIndex) throws CodecException {
        double max;
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (startIndex < 0) {
                            throw new IllegalArgumentException("Can't calculate max value for start index < 0, " + startIndex);
                        }
                        if (endIndex > this.getNumPoints()) {
                            throw new IllegalArgumentException("Can't calculate max value for end index > numPoints, " + endIndex + ", numPoints = " + this.getNumPoints());
                        }
                        if (startIndex >= endIndex) {
                            throw new IllegalArgumentException("Can't calculate max value for start index >= end index,  start index = " + startIndex + " endIndex = " + endIndex);
                        }
                        if (this.decomp == null) {
                            this.decodeBits();
                        }
                        max = -3.4028234663852886E38;
                        if (this.decomp.getType() != 3) break block8;
                        int[] iData = this.decomp.getAsInt();
                        for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                            if (!((double)iData[i] > max)) continue;
                            max = iData[i];
                        }
                        break block9;
                    }
                    if (this.decomp.getType() != 1) break block10;
                    short[] iData = this.decomp.getAsShort();
                    for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                        if (!((double)iData[i] > max)) continue;
                        max = iData[i];
                    }
                    break block9;
                }
                if (this.decomp.getType() != 4) break block11;
                float[] iData = this.decomp.getAsFloat();
                for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                    if (!((double)iData[i] > max)) continue;
                    max = iData[i];
                }
                break block9;
            }
            if (this.decomp.getType() != 5) break block9;
            double[] iData = this.decomp.getAsDouble();
            for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                if (!(iData[i] > max)) continue;
                max = iData[i];
            }
        }
        return new QuantityImpl(max, this.getUnit());
    }

    public QuantityImpl getMeanValue() throws CodecException {
        return this.getMeanValue(0, this.getNumPoints());
    }

    public QuantityImpl getMeanValue(int startIndex, int endIndex) throws CodecException {
        block9: {
            block11: {
                block10: {
                    block8: {
                        if (startIndex < 0) {
                            throw new IllegalArgumentException("Can't calculate mean value for start index < 0, " + startIndex);
                        }
                        if (endIndex > this.getNumPoints()) {
                            throw new IllegalArgumentException("Can't calculate mean value for end index > numPoints, " + endIndex + ", numPoints = " + this.getNumPoints());
                        }
                        if (startIndex >= endIndex) {
                            throw new IllegalArgumentException("Can't calculate mean value for start index >= end index,  start index = " + startIndex + " endIndex = " + endIndex);
                        }
                        if (this.decomp == null) {
                            this.decodeBits();
                        }
                        double mean = 0.0;
                        if (this.decomp.getType() != 3) break block8;
                        int[] iData = this.decomp.getAsInt();
                        for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                            mean += (double)iData[i];
                        }
                        break block9;
                    }
                    if (this.decomp.getType() != 1) break block10;
                    short[] iData = this.decomp.getAsShort();
                    for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                        mean += (double)iData[i];
                    }
                    break block9;
                }
                if (this.decomp.getType() != 4) break block11;
                float[] iData = this.decomp.getAsFloat();
                for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                    mean += (double)iData[i];
                }
                break block9;
            }
            if (this.decomp.getType() != 5) break block9;
            double[] iData = this.decomp.getAsDouble();
            for (int i = startIndex; i < iData.length && i < endIndex; ++i) {
                mean += iData[i];
            }
        }
        return new QuantityImpl(mean /= (double)(endIndex - startIndex), this.getUnit());
    }

    public QuantityImpl getValueAt(int index) throws CodecException {
        if (this.decomp == null) {
            this.decodeBits();
        }
        if (this.decomp.getType() == 1) {
            return new QuantityImpl(this.decomp.getAsShort()[index], this.getUnit());
        }
        if (this.decomp.getType() == 3) {
            return new QuantityImpl(this.decomp.getAsInt()[index], this.getUnit());
        }
        if (this.decomp.getType() == 4) {
            return new QuantityImpl(this.decomp.getAsFloat()[index], this.getUnit());
        }
        return new QuantityImpl(this.decomp.getAsDouble()[index], this.getUnit());
    }

    public UnitRangeImpl getAmplitudeRange(int beginIndex, int endIndex) throws CodecException {
        QuantityImpl min = this.getMinValue(beginIndex, endIndex);
        QuantityImpl max = this.getMaxValue(beginIndex, endIndex);
        return new UnitRangeImpl(min.getValue(), max.getValue(), min.getUnit());
    }

    public UnitRangeImpl getAmplitudeRange() throws CodecException {
        QuantityImpl min = this.getMinValue();
        QuantityImpl max = this.getMaxValue();
        return new UnitRangeImpl(min.getValue(), max.getValue(), min.getUnit());
    }

    public boolean is_long() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_LONG);
    }

    public boolean is_float() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_FLOAT);
    }

    public boolean is_double() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_DOUBLE);
    }

    public boolean is_short() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_SHORT);
    }

    public boolean is_encoded() {
        TimeSeriesType discrim = this.data.discriminator();
        return discrim.equals(TimeSeriesType.TYPE_ENCODED);
    }

    public boolean can_convert_to_long() {
        TimeSeriesType discrim = this.data.discriminator();
        if (discrim.equals(TimeSeriesType.TYPE_LONG) || discrim.equals(TimeSeriesType.TYPE_SHORT)) {
            return true;
        }
        if (discrim.equals(TimeSeriesType.TYPE_FLOAT) || discrim.equals(TimeSeriesType.TYPE_DOUBLE)) {
            return false;
        }
        if (discrim.equals(TimeSeriesType.TYPE_ENCODED)) {
            try {
                EncodedData[] ebb = this.data.encoded_values();
                return codec.getDecompressedType((int)ebb[0].compression) == 3 || codec.getDecompressedType((int)ebb[0].compression) == 1;
            }
            catch (UnsupportedCompressionType e) {
                return false;
            }
        }
        throw new RuntimeException("Can't happen!!! Unknown encoding format: " + discrim.value());
    }

    public boolean can_convert_to_float() {
        TimeSeriesType discrim = this.data.discriminator();
        if (discrim.equals(TimeSeriesType.TYPE_DOUBLE)) {
            return false;
        }
        if (discrim.equals(TimeSeriesType.TYPE_SHORT) || discrim.equals(TimeSeriesType.TYPE_LONG) || discrim.equals(TimeSeriesType.TYPE_FLOAT)) {
            return true;
        }
        if (discrim.equals(TimeSeriesType.TYPE_ENCODED)) {
            EncodedData[] ebb = this.data.encoded_values();
            try {
                return codec.getDecompressedType((int)ebb[0].compression) == 3 || codec.getDecompressedType((int)ebb[0].compression) == 1 || codec.getDecompressedType((int)ebb[0].compression) == 4;
            }
            catch (UnsupportedCompressionType e) {
                return false;
            }
        }
        throw new RuntimeException("Can't happen!!! Unknown encoding format: " + discrim.value());
    }

    public boolean can_convert_to_double() {
        return true;
    }

    public boolean can_convert_to_short() {
        TimeSeriesType discrim = this.data.discriminator();
        if (discrim.equals(TimeSeriesType.TYPE_SHORT)) {
            return true;
        }
        if (discrim.equals(TimeSeriesType.TYPE_LONG) || discrim.equals(TimeSeriesType.TYPE_FLOAT) || discrim.equals(TimeSeriesType.TYPE_DOUBLE)) {
            return false;
        }
        if (discrim.equals(TimeSeriesType.TYPE_ENCODED)) {
            try {
                EncodedData[] ebb = this.data.encoded_values();
                return codec.getDecompressedType((int)ebb[0].compression) == 1;
            }
            catch (UnsupportedCompressionType e) {
                return false;
            }
        }
        throw new RuntimeException("Can't happen!!! Unknown encoding format: " + discrim.value());
    }

    public TimeSeriesDataSel getData() {
        return this.data;
    }

    protected FissuresException makeFissuresException(CodecException e) {
        FissuresException ee = this.makeFissuresException("Codec Exception: " + e.getMessage());
        ee.initCause(e);
        return ee;
    }

    protected FissuresException makeFissuresException(String e) {
        return new FissuresException(e);
    }

    public int[] get_as_longs() throws FissuresException {
        int[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsInt()) == null) {
            throw this.makeFissuresException("Can't convert to int " + this.decomp.getTypeString());
        }
        return out;
    }

    public short[] get_as_shorts() throws FissuresException {
        short[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsShort()) == null) {
            throw this.makeFissuresException("Can't convert to short " + this.decomp.getTypeString());
        }
        return out;
    }

    public float[] get_as_floats() throws FissuresException {
        float[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsFloat()) == null) {
            throw this.makeFissuresException("Can't convert to float " + this.decomp.getTypeString());
        }
        return out;
    }

    public double[] get_as_doubles() throws FissuresException {
        double[] out;
        if (this.decomp == null) {
            try {
                this.decodeBits();
            }
            catch (CodecException e) {
                throw this.makeFissuresException(e);
            }
        }
        if ((out = this.decomp.getAsDouble()) == null) {
            throw this.makeFissuresException("Can't convert to double " + this.decomp.getTypeString());
        }
        return out;
    }

    public EncodedData[] get_as_encoded() throws FissuresException {
        if (this.is_encoded()) {
            return this.data.encoded_values();
        }
        throw this.makeFissuresException("data is not encoded");
    }

    public void append_longs(int[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.int_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_shorts(short[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.sht_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_floats(float[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.flt_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_doubles(double[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.dbl_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_encoded_seq(EncodedData[] newData) throws FissuresException {
        if (this.getData() == null) {
            TimeSeriesDataSel tsds = new TimeSeriesDataSel();
            tsds.encoded_values(newData);
            this.setData(tsds);
        } else {
            DataAppend.append(this.getData(), newData);
        }
        this.dataChanged();
    }

    public void append_encoded(EncodedData newData) throws FissuresException {
        EncodedData[] temp = new EncodedData[]{newData};
        this.append_encoded_seq(temp);
    }

    public int calculateNumPoints() {
        switch (this.data.discriminator().value()) {
            case 0: {
                return this.data.sht_values().length;
            }
            case 1: {
                return this.data.int_values().length;
            }
            case 2: {
                return this.data.flt_values().length;
            }
            case 3: {
                return this.data.dbl_values().length;
            }
            case 4: {
                int num = 0;
                EncodedData[] temp = this.data.encoded_values();
                for (int i = 0; i < temp.length; ++i) {
                    num += temp[i].num_points;
                }
                return num;
            }
        }
        throw new RuntimeException("getNumPoints default");
    }

    public float[] getValues(int start, int length) throws CodecException {
        if (this.decomp == null) {
            this.decodeBits();
        }
        float[] out = new float[length];
        System.arraycopy(this.decomp.getAsFloat(), start, out, 0, length);
        return out;
    }

    public TimeSeriesType getDataType() {
        return this.data.discriminator();
    }

    public void append(TimeSeriesDataSel b) throws FissuresException {
        switch (b.discriminator().value()) {
            case 0: {
                this.append_shorts(b.sht_values());
                break;
            }
            case 1: {
                this.append_longs(b.int_values());
                break;
            }
            case 2: {
                this.append_floats(b.flt_values());
                break;
            }
            case 3: {
                this.append_doubles(b.dbl_values());
                break;
            }
            case 4: {
                this.append_encoded_seq(b.encoded_values());
                break;
            }
            default: {
                throw new FissuresException("Unknown data type." + b.discriminator().value());
            }
        }
        this.dataChanged();
    }

    public boolean isDataDecodable() {
        try {
            if (this.decomp == null) {
                this.decodeBits();
            }
            return true;
        }
        catch (CodecException e) {
            return false;
        }
    }

    public void dataChanged() {
        this.decomp = null;
        this.num_points = this.calculateNumPoints();
    }

    protected void decodeBits() throws CodecException {
        if (this.data.discriminator().equals(TimeSeriesType.TYPE_LONG)) {
            if (this.data.int_values().length != this.getNumPoints()) {
                throw new CodecException("Number of points in data (" + this.data.int_values().length + ") is not the same as the number of points in the seismogram (" + this.getNumPoints() + ").");
            }
            this.decomp = new DecompressedData(this.data.int_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_SHORT)) {
            if (this.data.sht_values().length != this.getNumPoints()) {
                throw new CodecException("Number of points in data (" + this.data.sht_values().length + ") is not the same as the number of points in the seismogram (" + this.getNumPoints() + ").");
            }
            this.decomp = new DecompressedData(this.data.sht_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_FLOAT)) {
            if (this.data.flt_values().length != this.getNumPoints()) {
                throw new CodecException("Number of points in data (" + this.data.flt_values().length + ") is not the same as the number of points in the seismogram (" + this.getNumPoints() + ").");
            }
            this.decomp = new DecompressedData(this.data.flt_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_DOUBLE)) {
            if (this.data.dbl_values().length != this.getNumPoints()) {
                throw new CodecException("Number of points in data (" + this.data.dbl_values().length + ") is not the same as the number of points in the seismogram (" + this.getNumPoints() + ").");
            }
            this.decomp = new DecompressedData(this.data.dbl_values());
        } else if (this.data.discriminator().equals(TimeSeriesType.TYPE_ENCODED)) {
            EncodedData[] eData = this.data.encoded_values();
            int numFound = 0;
            for (int ii = 0; ii < eData.length; ++ii) {
                numFound += eData[ii].num_points;
            }
            if (numFound != this.getNumPoints()) {
                throw new CodecException("Sum of number of points in all EncodedData objects (" + numFound + ") is not the same as the number of points in the seismogram (" + this.getNumPoints() + ").");
            }
            ArrayList<DecompressedData> decompBuffer = new ArrayList<DecompressedData>(eData.length);
            for (int i = 0; i < eData.length; ++i) {
                if (eData[i].num_points == 0) continue;
                decompBuffer.add(codec.decompress((int)eData[i].compression, eData[i].values, eData[i].num_points, eData[i].byte_order));
            }
            int type = -1;
            for (DecompressedData decompressedData : decompBuffer) {
                if (decompressedData.getType() <= type) continue;
                type = decompressedData.getType();
            }
            int numSoFar = 0;
            switch (type) {
                case 1: {
                    short[] buffer = new short[this.getNumPoints()];
                    for (DecompressedData decompressedData : decompBuffer) {
                        short[] temp = decompressedData.getAsShort();
                        System.arraycopy(temp, 0, buffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(buffer);
                    break;
                }
                case 3: {
                    int[] ibuffer = new int[this.getNumPoints()];
                    for (DecompressedData decompressedData : decompBuffer) {
                        int[] temp = decompressedData.getAsInt();
                        System.arraycopy(temp, 0, ibuffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(ibuffer);
                    break;
                }
                case 4: {
                    float[] fbuffer = new float[this.getNumPoints()];
                    for (DecompressedData decompressedData : decompBuffer) {
                        float[] temp = decompressedData.getAsFloat();
                        System.arraycopy(temp, 0, fbuffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(fbuffer);
                    break;
                }
                case 5: {
                    double[] dbuffer = new double[this.getNumPoints()];
                    for (DecompressedData decompressedData : decompBuffer) {
                        double[] temp = decompressedData.getAsDouble();
                        System.arraycopy(temp, 0, dbuffer, numSoFar, temp.length);
                        numSoFar += temp.length;
                    }
                    this.decomp = new DecompressedData(dbuffer);
                    break;
                }
                default: {
                    throw new CodecException("decompressed primitive type " + type + " is not known");
                }
            }
        }
    }
}

