/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.seismogram;

import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.EncodedData;
import edu.sc.seis.sod.model.seismogram.TimeSeriesDataSel;
import edu.sc.seis.sod.model.seismogram.TimeSeriesType;

public class DataAppend {
    public static void append(TimeSeriesDataSel firstData, int[] second) throws FissuresException {
        if (firstData.discriminator() != TimeSeriesType.TYPE_LONG) {
            throw new FissuresException("Can't append int to data type " + String.valueOf(firstData.discriminator()));
        }
        int[] first = firstData.int_values();
        int[] newData = new int[first.length + second.length];
        System.arraycopy(first, 0, newData, 0, first.length);
        System.arraycopy(second, 0, newData, first.length, second.length);
        firstData.int_values(newData);
    }

    public static void append(TimeSeriesDataSel firstData, short[] second) throws FissuresException {
        if (firstData.discriminator() != TimeSeriesType.TYPE_SHORT) {
            throw new FissuresException("Can't append short to data type " + String.valueOf(firstData.discriminator()));
        }
        short[] first = firstData.sht_values();
        short[] newData = new short[first.length + second.length];
        System.arraycopy(first, 0, newData, 0, first.length);
        System.arraycopy(second, 0, newData, first.length, second.length);
        firstData.sht_values(newData);
    }

    public static void append(TimeSeriesDataSel firstData, float[] second) throws FissuresException {
        if (firstData.discriminator() != TimeSeriesType.TYPE_FLOAT) {
            throw new FissuresException("Can't append float to data type " + String.valueOf(firstData.discriminator()));
        }
        float[] first = firstData.flt_values();
        float[] newData = new float[first.length + second.length];
        System.arraycopy(first, 0, newData, 0, first.length);
        System.arraycopy(second, 0, newData, first.length, second.length);
        firstData.flt_values(newData);
    }

    public static void append(TimeSeriesDataSel firstData, double[] second) throws FissuresException {
        if (firstData.discriminator() != TimeSeriesType.TYPE_DOUBLE) {
            throw new FissuresException("Can't append double to data type " + String.valueOf(firstData.discriminator()));
        }
        double[] first = firstData.dbl_values();
        double[] newData = new double[first.length + second.length];
        System.arraycopy(first, 0, newData, 0, first.length);
        System.arraycopy(second, 0, newData, first.length, second.length);
        firstData.dbl_values(newData);
    }

    public static void append(TimeSeriesDataSel firstData, EncodedData[] second) throws FissuresException {
        if (firstData.discriminator() != TimeSeriesType.TYPE_ENCODED) {
            throw new FissuresException("Can't append encoded to data type " + firstData.discriminator().value());
        }
        EncodedData[] first = firstData.encoded_values();
        EncodedData[] newData = new EncodedData[first.length + second.length];
        System.arraycopy(first, 0, newData, 0, first.length);
        System.arraycopy(second, 0, newData, first.length, second.length);
        firstData.encoded_values(newData);
    }

    public static void append(TimeSeriesDataSel firstData, EncodedData second) throws FissuresException {
        if (firstData.discriminator() != TimeSeriesType.TYPE_ENCODED) {
            throw new FissuresException("Can't append encoded to data type " + firstData.discriminator().value());
        }
        EncodedData[] first = firstData.encoded_values();
        EncodedData[] newData = new EncodedData[first.length + 1];
        System.arraycopy(first, 0, newData, 0, first.length);
        newData[first.length] = second;
        firstData.encoded_values(newData);
    }
}

