/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.event;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.LocationUtil;
import edu.sc.seis.sod.model.common.ParameterRef;
import edu.sc.seis.sod.model.common.ParameterRefUtil;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.MagnitudeUtil;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;

public class OriginImpl {
    protected String id;
    protected String catalog;
    protected String contributor;
    protected Instant originTime;
    protected Location my_location;
    protected Magnitude[] magnitudes;
    protected ParameterRef[] parm_ids;
    private int dbid;
    protected List<Magnitude> hibernateMagList = null;

    public String get_id() {
        return this.id;
    }

    protected OriginImpl() {
        this.setParmIds(new ParameterRef[0]);
        this.set_id("");
    }

    public static OriginImpl createEmpty() {
        return new OriginImpl();
    }

    public OriginImpl(String id, String catalog, String contributor, Instant origin_time, Location my_location, Magnitude[] magnitudes, ParameterRef[] parm_ids) {
        this.id = id;
        this.setCatalog(catalog);
        this.setContributor(contributor);
        this.setOriginTime(origin_time);
        this.setLocation(my_location);
        this.setMagnitudes(magnitudes);
        this.setParmIds(parm_ids);
    }

    public boolean equals(Object o) {
        OriginImpl oOrigin;
        if (o == this) {
            return true;
        }
        return o instanceof OriginImpl && this.equalsExceptTime(oOrigin = (OriginImpl)o) && oOrigin.getOriginTime().equals(this.getOriginTime());
    }

    public boolean equalsExceptTime(OriginImpl oOrigin) {
        if (oOrigin == this) {
            return true;
        }
        return LocationUtil.areEqual(oOrigin.getLocation(), this.getLocation()) && oOrigin.getCatalog().equals(this.getCatalog()) && oOrigin.getContributor().equals(this.getContributor()) && MagnitudeUtil.areEqual(this.getMagnitudes(), oOrigin.getMagnitudes()) && ParameterRefUtil.areEqual(this.getParmIds(), oOrigin.getParmIds());
    }

    public boolean close(OriginImpl oOrigin) {
        if (oOrigin == this) {
            return true;
        }
        if (this.equalsExceptTime(oOrigin)) {
            Instant myOTime = this.getOriginTime();
            Instant eventOTime = oOrigin.getOriginTime();
            if (TimeUtils.durationToDoubleSeconds((Duration)Duration.between(eventOTime, myOTime)) < 1.0E-4) {
                return true;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 29;
        result += 89 * result + LocationUtil.hash(this.getLocation());
        result += 89 * result + this.getOriginTime().hashCode();
        result += 89 * result + this.getContributor().hashCode();
        result += 89 * result + this.getCatalog().hashCode();
        result += 89 * result + ParameterRefUtil.hash(this.getParmIds());
        result += 89 * result + MagnitudeUtil.hash(this.getMagnitudes());
        return result;
    }

    @Deprecated
    public Instant getFissuresTime() {
        return this.getOriginTime();
    }

    protected void setDbid(int dbid) {
        this.dbid = dbid;
    }

    public int getDbid() {
        return this.dbid;
    }

    protected void set_id(String id) {
        this.id = id == null ? "" + this.getDbid() : id;
    }

    public List<Magnitude> getMagnitudeList() {
        if (this.hibernateMagList != null) {
            return this.hibernateMagList;
        }
        ArrayList<Magnitude> out = new ArrayList<Magnitude>();
        for (int i = 0; i < this.getMagnitudes().length; ++i) {
            out.add(this.getMagnitudes()[i]);
        }
        return out;
    }

    protected void setMagnitudeList(List<Magnitude> list) {
        this.hibernateMagList = list;
        this.setMagnitudes(new Magnitude[list.size()]);
        this.setMagnitudes(list.toArray(this.getMagnitudes()));
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public String getCatalog() {
        return this.catalog;
    }

    public void setContributor(String contributor) {
        this.contributor = contributor;
    }

    public String getContributor() {
        return this.contributor;
    }

    public void setOriginTime(Instant origin_time) {
        this.originTime = origin_time;
    }

    public Instant getOriginTime() {
        return this.originTime;
    }

    public void setLocation(Location my_location) {
        this.my_location = my_location;
    }

    public Location getLocation() {
        return this.my_location;
    }

    public void setMagnitudes(Magnitude[] magnitudes) {
        this.magnitudes = magnitudes;
    }

    public Magnitude[] getMagnitudes() {
        return this.magnitudes;
    }

    public void setParmIds(ParameterRef[] parm_ids) {
        this.parm_ids = parm_ids;
    }

    public ParameterRef[] getParmIds() {
        return this.parm_ids;
    }

    public String toString() {
        return String.valueOf(this.getOriginTime()) + " " + String.valueOf(this.getMagnitudeList().get(0)) + " " + String.valueOf(this.getLocation());
    }
}

