/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.event;

import edu.sc.seis.sod.model.common.ParameterRef;
import edu.sc.seis.sod.model.common.ParameterRefUtil;
import edu.sc.seis.sod.model.event.FlinnEngdahlRegion;
import edu.sc.seis.sod.model.event.FlinnEngdahlType;

public class EventAttrImpl {
    public String name;
    public FlinnEngdahlRegion region;
    public ParameterRef[] parm_ids;

    public EventAttrImpl(String name) {
        this(name, new FlinnEngdahlRegion(FlinnEngdahlType.GEOGRAPHIC_REGION, 0));
    }

    public EventAttrImpl(String name, FlinnEngdahlRegion region) {
        this(name, region, new ParameterRef[0]);
    }

    public EventAttrImpl(String name, FlinnEngdahlRegion region, ParameterRef[] params) {
        this.name = name;
        this.region = region;
        this.parm_ids = params;
    }

    protected EventAttrImpl() {
        this.parm_ids = new ParameterRef[0];
    }

    public static EventAttrImpl createEmpty() {
        return new EventAttrImpl();
    }

    public int hashCode() {
        int result = 87;
        result = result * 34 + this.name.hashCode();
        result = result * 34 + this.region.hashCode();
        for (int i = 0; i < this.parm_ids.length; ++i) {
            result += result * 34 + ParameterRefUtil.hash(this.parm_ids[i]);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof EventAttrImpl) {
            EventAttrImpl oAttr = (EventAttrImpl)o;
            if (oAttr.name.equals(this.name) && this.region.equals(oAttr.region) && ParameterRefUtil.areEqual(this.parm_ids, oAttr.parm_ids)) {
                return true;
            }
        }
        return false;
    }

    public FlinnEngdahlRegion getRegion() {
        return this.region;
    }

    public String getName() {
        return this.name;
    }
}

