/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.event;

import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.event.OriginNotFound;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CacheEvent {
    protected CacheEvent event;
    private int dbid;
    protected EventAttrImpl attr;
    protected OriginImpl[] origins;
    protected OriginImpl preferred;
    private static final Logger logger = LoggerFactory.getLogger(CacheEvent.class);

    protected CacheEvent() {
    }

    public CacheEvent(EventAttrImpl attr, OriginImpl preferred) {
        this(attr, new OriginImpl[]{preferred}, preferred);
    }

    public CacheEvent(EventAttrImpl attr, OriginImpl[] origins, OriginImpl preferred) {
        if (attr == null) {
            throw new IllegalArgumentException("EventAttr cannot be null");
        }
        if (origins == null) {
            throw new IllegalArgumentException("origins cannot be null");
        }
        this.attr = attr;
        this.origins = origins;
        this.preferred = preferred != null ? preferred : origins[0];
    }

    @Deprecated
    public CacheEvent(CacheEvent event) {
        if (event == null) {
            throw new IllegalArgumentException("EventAccess cannot be null");
        }
        this.event = event;
        this.get_attributes();
        try {
            this.getPreferred();
        }
        catch (NoPreferredOrigin noPreferredOrigin) {
            // empty catch block
        }
    }

    public EventAttrImpl get_attributes() {
        if (this.attr == null && this.event != null) {
            this.attr = this.event.get_attributes();
        }
        if (this.attr == null) {
            this.attr = EventAttrImpl.createEmpty();
        }
        return this.attr;
    }

    public EventAttrImpl getAttributes() {
        return this.get_attributes();
    }

    public OriginImpl[] get_origins() {
        if (this.origins == null && this.event != null) {
            this.origins = this.event.get_origins();
        }
        if (this.origins == null) {
            try {
                this.origins = new OriginImpl[]{this.getPreferred()};
            }
            catch (NoPreferredOrigin e) {
                this.origins = new OriginImpl[0];
            }
        }
        return this.origins;
    }

    public OriginImpl[] getOrigins() {
        return this.get_origins();
    }

    protected void setOrigins(OriginImpl[] origins) {
        this.origins = origins;
    }

    public OriginImpl get_origin(String the_origin) throws OriginNotFound {
        if (this.event != null) {
            return this.event.get_origin(the_origin);
        }
        for (int i = 0; i < this.origins.length; ++i) {
            if (!this.origins[i].get_id().equals(the_origin)) continue;
            return this.origins[i];
        }
        throw new OriginNotFound();
    }

    public OriginImpl get_preferred_origin() throws NoPreferredOrigin {
        return this.getPreferred();
    }

    public OriginImpl getPreferred() throws NoPreferredOrigin {
        if (this.preferred == null) {
            if (this.event != null) {
                this.preferred = this.event.get_preferred_origin();
            } else {
                throw new NoPreferredOrigin();
            }
        }
        return this.preferred;
    }

    protected void setPreferred(OriginImpl o) {
        this.preferred = o;
    }

    public boolean isLoaded() {
        return this.attr != null && this.preferred != null;
    }

    public boolean hasDbid() {
        return this.dbid > -1;
    }

    public int getDbid() {
        return this.dbid;
    }

    public void setDbid(int id) {
        this.dbid = id;
    }

    @Deprecated
    public OriginImpl extractOrigin() {
        try {
            return this.get_preferred_origin();
        }
        catch (NoPreferredOrigin e) {
            logger.info("No preferred origin in event.  Trying get_origins instead");
            OriginImpl[] oArray = this.get_origins();
            if (oArray.length > 0) {
                return oArray[0];
            }
            throw new RuntimeException("No preferred origin", e);
        }
    }

    @Deprecated
    public OriginImpl getOrigin() {
        return this.extractOrigin();
    }

    public String toString() {
        try {
            return String.valueOf(this.getPreferred().getOriginTime()) + " " + String.valueOf(this.getPreferred().getMagnitudeList().get(0));
        }
        catch (NoPreferredOrigin e) {
            return "Event " + this.getAttributes().getName() + " no pref origin";
        }
    }
}

