/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.common;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnitRangeImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import java.time.Duration;
import java.time.Instant;

public class TimeRange {
    private final Instant beginTime;
    private final Instant endTime;

    public TimeRange(BaseNodeType node) {
        this(node.getStartDateTime(), node.getEndDateTime() != null ? node.getEndDateTime() : TimeUtils.future);
    }

    public TimeRange(LocalSeismogramImpl ls) {
        this(ls.getBeginTime(), ls.getEndTime());
    }

    public TimeRange(RequestFilter rf) {
        this(rf.startTime, rf.endTime);
    }

    public TimeRange(TimeRange timeRange) {
        this(timeRange.getBeginTime(), timeRange.getEndTime());
    }

    public TimeRange(Instant time, Instant anotherTime) {
        if (anotherTime == null || time.isBefore(anotherTime)) {
            this.beginTime = time;
            this.endTime = anotherTime;
        } else {
            this.beginTime = anotherTime;
            this.endTime = time;
        }
    }

    public TimeRange(Instant beginTime, Duration interval) {
        this(beginTime, beginTime.plus(interval));
    }

    public TimeRange(TimeRange timeRange, TimeRange timeRange2) {
        this(timeRange.getBeginTime().isBefore(timeRange2.getBeginTime()) ? timeRange.getBeginTime() : timeRange2.getBeginTime(), timeRange.getEndTime().isAfter(timeRange2.getEndTime()) ? timeRange.getEndTime() : timeRange2.getEndTime());
    }

    public boolean intersects(Instant newTime) {
        return this.contains(newTime);
    }

    public boolean contains(Instant newTime) {
        Instant tmpEndTime = this.endTime != null ? this.endTime : Instant.now();
        return !(!this.beginTime.isBefore(newTime) && !this.beginTime.equals(newTime) || !tmpEndTime.isAfter(newTime) && !tmpEndTime.equals(newTime));
    }

    public boolean intersects(TimeRange time) {
        Instant tmpEndTime = this.endTime != null ? this.endTime : Instant.now();
        return tmpEndTime.isAfter(time.getBeginTime()) && this.beginTime.isBefore(time.getEndTime());
    }

    public TimeRange intersection(TimeRange time) {
        if (this.intersects(time)) {
            Instant tmpEndTime = this.endTime != null ? this.endTime : Instant.now();
            return new TimeRange(this.beginTime.isAfter(time.getBeginTime()) ? this.beginTime : time.getBeginTime(), tmpEndTime.isBefore(time.getEndTime()) ? tmpEndTime : time.getEndTime());
        }
        return null;
    }

    public TimeRange shale(double shift, double scale) {
        if (shift == 0.0 && scale == 1.0) {
            return this;
        }
        Duration timeShift = TimeUtils.multiply((Duration)this.getInterval(), (double)Math.abs(shift));
        Instant newBeginTime = shift < 0.0 ? this.beginTime.minus(timeShift) : this.beginTime.plus(timeShift);
        return new TimeRange(newBeginTime, TimeUtils.multiply((Duration)this.getInterval(), (double)scale));
    }

    public TimeRange shift(Duration shift) {
        return new TimeRange(this.beginTime.plus(shift), this.endTime != null ? this.endTime.plus(shift) : null);
    }

    public TimeRange shift(double percentage) {
        if (percentage == 0.0) {
            return this;
        }
        Duration shift = TimeUtils.multiply((Duration)this.getInterval(), (double)Math.abs(percentage));
        if (percentage < 0.0) {
            return new TimeRange(this.beginTime.minus(shift), this.endTime != null ? this.endTime.minus(shift) : null);
        }
        return new TimeRange(this.beginTime.plus(shift), this.endTime != null ? this.endTime.plus(shift) : null);
    }

    public Instant getBeginTime() {
        return this.beginTime;
    }

    public Instant getEndTime() {
        return this.endTime;
    }

    public Duration getInterval() {
        Instant tmpEndTime = this.endTime != null ? this.endTime : Instant.now();
        return Duration.between(this.beginTime, tmpEndTime);
    }

    public UnitRangeImpl getMillis() {
        Instant tmpEndTime = this.endTime != null ? this.endTime : Instant.now();
        return new UnitRangeImpl(this.beginTime.toEpochMilli(), tmpEndTime.toEpochMilli(), UnitImpl.MILLISECOND);
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        TimeRange mstrTime = (TimeRange)other;
        return this.beginTime.equals(mstrTime.getBeginTime()) && (this.endTime == null && mstrTime.getEndTime() == null || this.endTime.equals(mstrTime.getEndTime()));
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + this.beginTime.hashCode();
        result = 37 * result + (this.endTime != null ? this.endTime.hashCode() : 19);
        return result;
    }

    public String toString() {
        return String.valueOf(this.beginTime) + " to " + String.valueOf(this.endTime != null ? this.endTime : "now");
    }
}

