/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.common;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import java.io.Serializable;
import java.time.Duration;

public class SamplingImpl
implements Serializable {
    public int numPoints;
    public Duration interval;

    protected SamplingImpl() {
    }

    public static Serializable createEmpty() {
        return new SamplingImpl();
    }

    public static SamplingImpl of(Channel chan) {
        return new SamplingImpl(1, Duration.ofNanos((long)(1.0E9 / (double)chan.getSampleRate().getValue())));
    }

    public static SamplingImpl ofSamplesSeconds(int numPoints, double seconds) {
        return new SamplingImpl(numPoints, Duration.ofNanos(Math.round(seconds * 1.0E9)));
    }

    public SamplingImpl(int numPoints, Duration interval) {
        if ((long)interval.getNano() == Long.MAX_VALUE && numPoints == 1) {
            interval = Duration.ofSeconds(1L);
            numPoints = 0;
        }
        this.interval = interval;
        this.numPoints = numPoints;
    }

    public Duration getPeriod() {
        return this.getTimeInterval().dividedBy(this.numPoints);
    }

    public QuantityImpl getFrequency() {
        return QuantityImpl.of(this.getTimeInterval()).inverse().multipliedByDbl(this.numPoints);
    }

    public int getNumPoints() {
        return this.numPoints;
    }

    protected void setNumPoints(int n) {
        this.numPoints = n;
    }

    public Duration getTimeInterval() {
        return this.interval;
    }

    protected void setTimeInterval(QuantityImpl i) {
        this.interval = Duration.ofNanos(Math.round(i.getValue(UnitImpl.NANOSECOND)));
    }

    public String toString() {
        return this.numPoints + " in " + String.valueOf(this.interval);
    }

    public int hashCode() {
        int result = 38;
        result += 37 * result + this.getTimeInterval().hashCode();
        result += 37 * result + this.getNumPoints();
        return result;
    }

    public boolean equals(Object o) {
        SamplingImpl sampImpl;
        if (super.equals(o)) {
            return true;
        }
        return o instanceof SamplingImpl && (sampImpl = (SamplingImpl)o).getPeriod().equals(this.getPeriod());
    }
}

