/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.common;

import edu.sc.seis.sod.model.common.UnitBase;
import edu.sc.seis.sod.model.common.UnitImpl;
import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.time.Duration;

public class QuantityImpl
implements Serializable {
    private double value;
    private UnitImpl the_units;
    protected NumberFormat format = null;

    protected QuantityImpl() {
    }

    public static Serializable createEmpty() {
        return new QuantityImpl();
    }

    public QuantityImpl(double f, UnitImpl the_unit) {
        this.value = f;
        this.the_units = the_unit;
    }

    public static QuantityImpl createQuantityImpl(QuantityImpl q) {
        if (q instanceof QuantityImpl) {
            return q;
        }
        return new QuantityImpl(q.value, UnitImpl.createUnitImpl(q.the_units));
    }

    public static QuantityImpl of(Duration duration) {
        return new QuantityImpl(duration.toNanos(), UnitImpl.NANOSECOND);
    }

    @Deprecated
    public void setFormat(NumberFormat format) {
        this.format = format;
    }

    public String formatValue(String format) {
        return new DecimalFormat(format).format(this.value);
    }

    public double getValue() {
        return this.value;
    }

    public double getValue(UnitImpl unit) {
        return this.convertTo(unit).getValue();
    }

    protected void setValue(double value) {
        this.value = value;
    }

    public double get_value() {
        return this.getValue();
    }

    public UnitImpl getUnit() {
        return this.the_units;
    }

    protected void setUnit(UnitImpl unit) {
        this.the_units = unit;
    }

    public UnitImpl get_unit() {
        return this.getUnit();
    }

    public static void internUnit(QuantityImpl q, UnitImpl internedUnit) {
        q.the_units = internedUnit;
    }

    public QuantityImpl convertTo(UnitImpl newUnit) {
        UnitImpl currUnit = this.getUnit();
        if (currUnit.equals(newUnit)) {
            return this;
        }
        if (!currUnit.isConvertableTo(newUnit)) {
            throw new IllegalArgumentException("Cannot convert, units are not compatible, " + String.valueOf(currUnit) + " and " + String.valueOf(newUnit));
        }
        if (currUnit.the_unit_base == UnitBase.KELVIN) {
            if (currUnit.name.equalsIgnoreCase("KELVIN")) {
                if (newUnit.name.equalsIgnoreCase("CELSIUS")) {
                    return new QuantityImpl(this.getValue() - 273.15, newUnit);
                }
                if (newUnit.name.equalsIgnoreCase("FAHRENHEIT")) {
                    return new QuantityImpl((this.getValue() - 273.15) * 9.0 / 5.0 + 32.0, newUnit);
                }
            } else if (currUnit.name.equalsIgnoreCase("CELSIUS")) {
                if (newUnit.name.equalsIgnoreCase("KELVIN")) {
                    return new QuantityImpl(this.getValue() + 273.15, newUnit);
                }
                if (newUnit.name.equalsIgnoreCase("FAHRENHEIT")) {
                    return new QuantityImpl(this.getValue() * 9.0 / 5.0 + 32.0, newUnit);
                }
            } else if (currUnit.name.equalsIgnoreCase("FAHRENHEIT")) {
                if (newUnit.name.equalsIgnoreCase("CELSIUS")) {
                    return new QuantityImpl((this.getValue() - 32.0) * 5.0 / 9.0, newUnit);
                }
                if (newUnit.name.equalsIgnoreCase("KELVIN")) {
                    return new QuantityImpl((this.getValue() - 32.0) * 5.0 / 9.0 + 273.15, newUnit);
                }
            }
        }
        double mulfac = currUnit.getTotalMultiFactor() / newUnit.getTotalMultiFactor();
        int powerDiff = currUnit.getTotalPower() - newUnit.getTotalPower();
        double newValue = this.getValue() * mulfac;
        if (powerDiff != 0) {
            newValue *= Math.pow(10.0, powerDiff);
        }
        return new QuantityImpl(newValue, newUnit);
    }

    public QuantityImpl add(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return new QuantityImpl(this.getValue() + val, this.getUnit());
    }

    public QuantityImpl subtract(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return new QuantityImpl(this.getValue() - val, this.getUnit());
    }

    public QuantityImpl multiplyBy(QuantityImpl q) {
        double val = q.getValue();
        return new QuantityImpl(this.getValue() * val, UnitImpl.multiply(this.getUnit(), q.getUnit()));
    }

    public QuantityImpl divideBy(QuantityImpl q) {
        double val = q.getValue();
        return new QuantityImpl(this.getValue() / val, UnitImpl.divide(this.getUnit(), q.getUnit()));
    }

    public QuantityImpl multipliedByDbl(double f) {
        return new QuantityImpl(this.getValue() * f, this.getUnit());
    }

    public QuantityImpl dividedByDbl(double f) {
        return new QuantityImpl(this.getValue() / f, this.getUnit());
    }

    public QuantityImpl abs() {
        return new QuantityImpl(Math.abs(this.getValue()), this.getUnit());
    }

    public QuantityImpl inverse() {
        return new QuantityImpl(1.0 / this.getValue(), this.getUnit().inverse());
    }

    public String toString() {
        if (this.format == null) {
            return this.getValue() + " " + String.valueOf(this.getUnit());
        }
        return this.format.format(this.getValue()) + " " + String.valueOf(this.getUnit());
    }

    public Duration toDuration() {
        return Duration.ofNanos(Math.round(this.getValue(UnitImpl.NANOSECOND)));
    }

    public boolean greaterThan(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() > val;
    }

    public boolean greaterThanEqual(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() >= val;
    }

    public boolean lessThan(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() < val;
    }

    public boolean lessThanEqual(QuantityImpl q) {
        double val = q.convertTo(this.getUnit()).getValue();
        return this.getValue() <= val;
    }

    public int hashCode() {
        int result = 22;
        long valBits = Double.doubleToLongBits(this.value);
        result = 37 * result + (int)(valBits ^ valBits >>> 32);
        result = 37 * result + this.the_units.hashCode();
        return result;
    }

    public boolean equals(Object o) {
        if (super.equals(o)) {
            return true;
        }
        if (o instanceof QuantityImpl) {
            QuantityImpl q = (QuantityImpl)o;
            if (this.getUnit().isConvertableTo(q.getUnit()) && q.convertTo(this.getUnit()).getValue() == this.getValue()) {
                return true;
            }
        }
        return false;
    }

    public static void main(String[] args) {
        QuantityImpl q = new QuantityImpl(5.0, UnitImpl.HOUR);
        QuantityImpl halfq = new QuantityImpl(2.5, UnitImpl.HOUR);
        System.out.println("q=" + String.valueOf(q));
        System.out.println("q.convertTo(UnitImpl.SECOND)=" + String.valueOf(q.convertTo(UnitImpl.SECOND)));
        System.out.println("q.inverse=" + String.valueOf(q.inverse()));
        System.out.println("q.add(q)=" + String.valueOf(q.add(q)));
        System.out.println("q.subtract(halfq)=" + String.valueOf(q.subtract(halfq)));
        System.out.println("q.convertTo(MICROSECOND)=" + String.valueOf(q.convertTo(UnitImpl.MICROSECOND)));
        QuantityImpl p = new QuantityImpl(10.0, UnitImpl.METER);
        System.out.println("p=" + String.valueOf(p));
        System.out.println("p.divideBy(q)=" + String.valueOf(p.divideBy(q)));
        System.out.println("p.multiplyBy(q)=" + String.valueOf(p.multiplyBy(q)));
    }
}

