/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.model.common;

import edu.sc.seis.seisFile.fdsnws.quakeml.Origin;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.LocationType;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import java.util.Objects;

public class Location {
    public float latitude;
    public float longitude;
    public QuantityImpl elevation;
    public QuantityImpl depth;
    public LocationType type;

    Location() {
    }

    public static Location of(Origin origin) {
        return new Location(origin.getLatitude().getValue().floatValue(), origin.getLongitude().getValue().floatValue(), new QuantityImpl(0.0, UnitImpl.METER), new QuantityImpl(origin.getDepth().getValue().floatValue(), UnitImpl.METER));
    }

    @Deprecated
    public Location(Origin origin) {
        this(origin.getLatitude().getValue().floatValue(), origin.getLongitude().getValue().floatValue(), new QuantityImpl(0.0, UnitImpl.METER), new QuantityImpl(origin.getDepth().getValue().floatValue(), UnitImpl.METER));
    }

    public static Location of(Channel channel) {
        if (!channel.getElevation().getUnit().equalsIgnoreCase("meter")) {
            throw new IllegalArgumentException("Units of elevation should be meter");
        }
        if (!channel.getDepth().getUnit().equalsIgnoreCase("meter")) {
            throw new IllegalArgumentException("Units of depth should be meter");
        }
        return new Location(channel.getLatitude().getValue(), channel.getLongitude().getValue(), new QuantityImpl(channel.getElevation().getValue(), UnitImpl.METER), new QuantityImpl(channel.getDepth().getValue(), UnitImpl.METER));
    }

    public static Location of(Station sta) {
        return new Location(sta.getLatitude().getValue(), sta.getLongitude().getValue(), new QuantityImpl(sta.getElevation().getValue(), UnitImpl.METER), new QuantityImpl(0.0, UnitImpl.METER));
    }

    public Location(float latitude, float longitude, QuantityImpl elevation, QuantityImpl depth) {
        this(latitude, longitude, elevation, depth, LocationType.GEOGRAPHIC);
    }

    public Location(float latitude, float longitude, QuantityImpl elevation, QuantityImpl depth, LocationType type) {
        this.latitude = latitude;
        this.longitude = longitude;
        this.elevation = elevation;
        this.depth = depth;
        this.type = type;
    }

    public String toString() {
        return "(" + this.latitude + ", " + this.longitude + ") " + String.valueOf(this.depth);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Location)) {
            return false;
        }
        Location location = (Location)o;
        return Float.compare(this.latitude, location.latitude) == 0 && Float.compare(this.longitude, location.longitude) == 0 && Objects.equals(this.elevation, location.elevation) && Objects.equals(this.depth, location.depth) && Objects.equals(this.type, location.type);
    }

    public int hashCode() {
        return Objects.hash(Float.valueOf(this.latitude), Float.valueOf(this.longitude), this.elevation, this.depth, this.type);
    }
}

