/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.mock.station;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.mock.station.MockStation;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.Orientation;
import edu.sc.seis.sod.model.station.ChannelGroup;

public class MockChannel {
    private static final Orientation VERTICAL = new Orientation(0.0f, -90.0f);
    private static final Orientation EAST = new Orientation(90.0f, 0.0f);
    private static final Orientation NORTH = new Orientation(0.0f, 0.0f);
    private static final Orientation[] ORIENTATIONS = new Orientation[]{VERTICAL, NORTH, EAST};

    public static Channel createChannel() {
        return MockChannel.createChannel(MockStation.createStation(), "00", "BHZ", 20.0f, 0.0f, -90.0f, 0.0f, "Vertical Channel");
    }

    public static Channel createNorthChannel() {
        return MockChannel.createChannel(MockStation.createStation(), "00", "BHN", 20.0f, 0.0f, 0.0f, 0.0f, "North Channel");
    }

    public static Channel createEastChannel() {
        return MockChannel.createChannel(MockStation.createStation(), "00", "BHE", 20.0f, 90.0f, 0.0f, 0.0f, "East Channel");
    }

    public static Channel createOtherSiteSameStationChan() {
        Channel out = MockChannel.createChannel(MockStation.createStation(), "01", "BHZ", 20.0f, 0.0f, -90.0f, 0.0f, "Nearby Vertical Channel");
        out.setLatitude(out.getLatitude().getValue() + 0.001f);
        return out;
    }

    public static Channel createOtherNetChan() {
        Channel out = MockChannel.createChannel(MockStation.createOtherStation(), "00", "BHZ", 20.0f, 0.0f, -90.0f, 0.0f, "Vertical Channel");
        return out;
    }

    public static Channel[] createChannelsAtLocs(Location[] locs) {
        Channel[] chans = new Channel[locs.length];
        for (int i = 0; i < chans.length; ++i) {
            chans[i] = MockChannel.createChannel(locs[i]);
        }
        return chans;
    }

    public static Channel createChannel(Location location) {
        return MockChannel.createChannel(MockStation.createStation(location));
    }

    public static Channel createChannel(Station station) {
        return MockChannel.createChannel(station, "00", "BHZ");
    }

    public static Channel createChannel(Station station, String siteCode, String chanCode) {
        float az = 0.0f;
        float dip = -90.0f;
        if (chanCode.endsWith("N")) {
            az = 0.0f;
            dip = 0.0f;
        } else if (chanCode.endsWith("E")) {
            az = 90.0f;
            dip = 0.0f;
        }
        return MockChannel.createChannel(MockStation.createStation(), "00", chanCode, 20.0f, az, dip, 0.0f, chanCode + " Channel");
    }

    public static Channel createChannel(Station station, String locCode, String chanCode, float sampleRate, float azimuth, float dip, float depth, String desc) {
        Channel out = new Channel(station, locCode, chanCode);
        out.setAzimuth(azimuth);
        out.setDepth(depth);
        out.setDescription(desc);
        out.setDip(dip);
        out.setElevation(station.getElevation());
        out.setEndDateTime(station.getEndDateTime());
        out.setLatitude(station.getLatitude());
        out.setLongitude(station.getLongitude());
        out.setSampleRate(sampleRate);
        out.setStartDateTime(station.getStartDateTime());
        return out;
    }

    public static Channel[] createMotionVector() {
        return MockChannel.createMotionVector(MockStation.createStation());
    }

    public static Channel[] createMotionVector(Station station) {
        Channel[] channels = new Channel[3];
        String[] codes = new String[]{"BHZ", "BHN", "BHE"};
        String locCode = "00";
        for (int i = 0; i < codes.length; ++i) {
            channels[i] = MockChannel.createChannel(station, locCode, codes[i]);
        }
        return channels;
    }

    public static ChannelGroup createGroup() {
        return new ChannelGroup(MockChannel.createMotionVector());
    }
}

