/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.mock.event;

import edu.sc.seis.sod.mock.Defaults;
import edu.sc.seis.sod.mock.MockLocation;
import edu.sc.seis.sod.mock.MockParameterRef;
import edu.sc.seis.sod.mock.event.MockMagnitude;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.OriginImpl;
import java.time.Instant;

public class MockOrigin {
    public static OriginImpl create() {
        return MockOrigin.create(Defaults.EPOCH, MockMagnitude.createMagnitudes());
    }

    public static OriginImpl create(Instant time, float lat, float lon) {
        return new OriginImpl("latlon event", "Test Data", "Charlie Groves", time, MockLocation.create(lat, lon), MockMagnitude.createMagnitudes(), MockParameterRef.createParams());
    }

    public static OriginImpl create(Instant time, Magnitude[] mags) {
        return new OriginImpl("Epoch in Central Alaska", "Test Data", "Charlie Groves", time, MockLocation.create(), mags, MockParameterRef.createParams());
    }

    public static OriginImpl createWallFallOrigin() {
        return new OriginImpl("Fall of the Berlin Wall", "Test Data", "Charlie Groves", Defaults.WALL_FALL, MockLocation.createBerlin(), MockMagnitude.createMagnitudes(), MockParameterRef.createParams());
    }

    public static OriginImpl[] createOrigins() {
        OriginImpl[] origins = new OriginImpl[]{MockOrigin.create(), MockOrigin.createWallFallOrigin()};
        return origins;
    }

    public static OriginImpl createOrigin() {
        return MockOrigin.create();
    }

    public static OriginImpl[] createOrigins(int num) {
        OriginImpl[] out = new OriginImpl[num];
        for (int i = 0; i < out.length; ++i) {
            out[i] = MockOrigin.create(Instant.now(), MockMagnitude.createMagnitudes());
        }
        return out;
    }
}

