/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.mock.event;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.mock.MockLocation;
import edu.sc.seis.sod.mock.MockParameterRef;
import edu.sc.seis.sod.mock.event.MockEventAttr;
import edu.sc.seis.sod.mock.event.MockMagnitude;
import edu.sc.seis.sod.mock.event.MockOrigin;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.EventAttrImpl;
import edu.sc.seis.sod.model.event.Magnitude;
import edu.sc.seis.sod.model.event.OriginImpl;
import java.time.Duration;
import java.time.Instant;

public class MockEventAccessOperations {
    public static synchronized CacheEvent[] createEvents() {
        return new CacheEvent[]{MockEventAccessOperations.createEvent(), MockEventAccessOperations.createFallEvent()};
    }

    public static CacheEvent createEvent() {
        return MockEventAccessOperations.createEvent(MockOrigin.create(), MockEventAttr.create());
    }

    public static CacheEvent createEvent(Instant time, float lat, float lon) {
        return MockEventAccessOperations.createEvent(MockOrigin.create(time, lat, lon), MockEventAttr.create());
    }

    public static CacheEvent createFallEvent() {
        return MockEventAccessOperations.createEvent(MockOrigin.createWallFallOrigin(), MockEventAttr.createWallFallAttr());
    }

    public static CacheEvent createEvent(Instant eventTime, int magnitudeAndDepth, int feRegion) {
        Magnitude[] mags = new Magnitude[]{new Magnitude("test", magnitudeAndDepth, "another")};
        return MockEventAccessOperations.createEvent(MockOrigin.create(eventTime, mags), MockEventAttr.create(feRegion));
    }

    public static CacheEvent createEvent(OriginImpl origin, EventAttrImpl attr) {
        OriginImpl[] origins = new OriginImpl[]{origin};
        return new CacheEvent(attr, origins, origins[0]);
    }

    public static CacheEvent[] createEventTimeRange() {
        Instant t = TimeUtils.parseISOString((String)"20010101T000000.000Z");
        TimeRange tr = new TimeRange(t, Duration.ofDays(30L));
        return MockEventAccessOperations.createEvents(tr, 3, 6);
    }

    public static CacheEvent[] createEvents(TimeRange timeRange, int rows, int cols) {
        int numEvents = rows * cols;
        Duration timeBetweenEvents = timeRange.getInterval().dividedBy(numEvents);
        CacheEvent[] events = new CacheEvent[numEvents];
        Location[] locs = MockLocation.create(rows, cols);
        Magnitude[][] mags = MockMagnitude.getMagnitudes(4.0f, 10.0f, numEvents);
        for (int i = 0; i < numEvents; ++i) {
            Instant eventBegin = timeRange.getBeginTime().plus(timeBetweenEvents.multipliedBy(i));
            OriginImpl o = new OriginImpl("Mock Event " + i, "Mockalog", "Charlie Groves", eventBegin, locs[i], mags[i], MockParameterRef.createParams());
            EventAttrImpl ea = MockEventAttr.create();
            events[i] = new CacheEvent(ea, o);
        }
        return events;
    }
}

