/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.mock;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.InvalidResponse;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.mock.station.MockNetworkAccess;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.model.station.StationId;
import edu.sc.seis.sod.source.SodSourceException;
import edu.sc.seis.sod.source.network.AbstractNetworkSource;
import edu.sc.seis.sod.source.network.NetworkQueryConstraints;
import edu.sc.seis.sod.source.network.NetworkSource;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MockNetworkSource
extends AbstractNetworkSource
implements NetworkSource {
    Duration refresh;
    MockNetworkAccess[] nets = new MockNetworkAccess[]{MockNetworkAccess.createNetworkAccess(), MockNetworkAccess.createOtherNetworkAccess(), MockNetworkAccess.createManySplendoredNetworkAccess()};

    public MockNetworkSource(Duration refresh) {
        super("MockNetworkSource", 0);
        this.refresh = refresh;
    }

    public MockNetworkSource() {
        this(Duration.ofDays(3L));
    }

    @Override
    public String getName() {
        return "MockNetworkSource";
    }

    @Override
    public Duration getRefreshInterval() {
        return this.refresh;
    }

    @Override
    public List<? extends Network> getNetworks() {
        ArrayList<Network> out = new ArrayList<Network>();
        for (int i = 0; i < this.nets.length; ++i) {
            out.add(this.nets[i].get_attributes());
        }
        return out;
    }

    @Override
    public List<? extends Station> getStations(Network net) {
        for (int i = 0; i < this.nets.length; ++i) {
            if (!NetworkIdUtil.areEqual(this.nets[i].get_attributes().getNetworkId(), net.getNetworkId())) continue;
            return Arrays.asList(this.nets[i].retrieve_stations());
        }
        return null;
    }

    @Override
    public List<? extends Channel> getChannels(Station station) {
        for (int i = 0; i < this.nets.length; ++i) {
            if (!NetworkIdUtil.areEqual(this.nets[i].get_attributes().getNetworkId(), station.getNetwork().getNetworkId())) continue;
            return Arrays.asList(this.nets[i].retrieve_for_station(StationId.of(station)));
        }
        return null;
    }

    @Override
    public void setConstraints(NetworkQueryConstraints constraints) {
    }

    @Override
    public Response getResponse(Channel chanId) throws ChannelNotFound, InvalidResponse, SodSourceException {
        throw new ChannelNotFound("Not implemented", chanId);
    }
}

