/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate.eventpair;

import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventVectorPair
extends AbstractEventChannelPair {
    ChannelGroup channelGroup;
    private static final Logger logger = LoggerFactory.getLogger(EventVectorPair.class);

    protected EventVectorPair() {
    }

    public EventVectorPair(StatefulEvent event, ChannelGroup channelGroup, EventStationPair esp) {
        this(event, channelGroup, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT), esp);
    }

    public EventVectorPair(StatefulEvent event, ChannelGroup channelGroup, Status status, EventStationPair esp) {
        super(event, status, esp);
        this.channelGroup = channelGroup;
    }

    public ChannelGroup getChannelGroup() {
        return this.channelGroup;
    }

    protected void setChannelGroup(ChannelGroup cg) {
        this.channelGroup = cg;
    }

    @Override
    public void run() {
        try {
            ((MotionVectorArm)Start.getWaveformRecipe()).processMotionVectorArm(this);
            SodDB.commit();
            logger.debug("Finish EVP: " + String.valueOf(this));
        }
        catch (Throwable t) {
            System.err.println(EventChannelPair.BIG_ERROR_MSG);
            t.printStackTrace(System.err);
            GlobalExceptionHandler.handle(EventChannelPair.BIG_ERROR_MSG, t);
            try {
                SodDB.rollback();
                this.update(t, Status.get(Stage.PROCESSOR, Standing.SYSTEM_FAILURE));
                SodDB.commit();
            }
            catch (Throwable tt) {
                System.err.println("SOD cannot update status of evp, this indicates a significant problem with the database. SOD is now exiting with shame and dispair");
                Start.cataclysmicFailureOfUnbelievableProportions();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventVectorPair)) {
            return false;
        }
        EventVectorPair ecp = (EventVectorPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getChannelGroup().getChannels()[0].getDbid() == this.getChannelGroup().getChannels()[0].getDbid() && ecp.getChannelGroup().getChannels()[1].getDbid() == this.getChannelGroup().getChannels()[1].getDbid() && ecp.getChannelGroup().getChannels()[2].getDbid() == this.getChannelGroup().getChannels()[2].getDbid();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getChannelGroup().getChannels()[0].getDbid();
        code += 17 * this.getChannelGroup().getChannels()[1].getDbid();
        code += 19 * this.getChannelGroup().getChannels()[2].getDbid();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        String s = "ECGroup: " + String.valueOf(this.getEvent()) + " ";
        s = s + ChannelIdUtil.toString(this.getChannelGroup().getChannels()[0]) + " , ";
        s = s + ChannelIdUtil.toString(this.getChannelGroup().getChannels()[1]) + " , ";
        s = s + ChannelIdUtil.toString(this.getChannelGroup().getChannels()[2]) + " , ";
        s = s + " " + String.valueOf(this.getStatus());
        return s;
    }
}

