/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate.eventpair;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.MotionVectorArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventPair;
import edu.sc.seis.sod.hibernate.eventpair.CookieEventPair;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.status.StringTree;
import edu.sc.seis.sod.status.StringTreeLeaf;
import edu.sc.seis.sod.subsetter.EventEffectiveTimeOverlap;
import edu.sc.seis.sod.subsetter.eventStation.EventStationSubsetter;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventStationPair
extends CookieEventPair {
    private Station station;
    private static final Logger logger = LoggerFactory.getLogger(EventStationPair.class);

    protected EventStationPair() {
    }

    public EventStationPair(StatefulEvent event, Station station) {
        this(event, station, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
    }

    public EventStationPair(StatefulEvent event, Station station, Status status) {
        super(event, status);
        this.setStation(station);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SodDB sodDb = SodDB.getSingleton();
        logger.debug("Begin EventStationPair (e=" + this.getEvent().getDbid() + ",s=" + this.getStationDbId() + ") " + String.valueOf(this));
        Location l = this.getEvent().getOrigin().getLocation();
        l = Location.of(this.getStation());
        try {
            AbstractEventChannelPair p;
            EventEffectiveTimeOverlap overlap = new EventEffectiveTimeOverlap(this.getEvent());
            HashMap cookies = new HashMap();
            StringTree accepted = new StringTreeLeaf(this, false);
            try {
                EventStationSubsetter esSub = Start.getWaveformRecipe().getEventStationSubsetter();
                EventStationSubsetter eventStationSubsetter = esSub;
                synchronized (eventStationSubsetter) {
                    accepted = esSub.accept(this.getEvent(), this.getStation(), this.getMeasurements());
                }
            }
            catch (Throwable e) {
                if (e instanceof IOException) {
                    this.update(e, Status.get(Stage.EVENT_STATION_SUBSETTER, Standing.CORBA_FAILURE));
                    this.updateRetries();
                    failLogger.info("Network or server problem, SOD will continue to retry this item periodically: (" + e.getClass().getName() + ") " + String.valueOf(this));
                    logger.debug(this.toString(), e);
                } else {
                    this.update(e, Status.get(Stage.EVENT_STATION_SUBSETTER, Standing.SYSTEM_FAILURE));
                    failLogger.warn(this.toString(), e);
                }
                SodDB.commit();
                logger.debug("Finish (fail) EStaP: " + String.valueOf(this));
                SodDB.commit();
                return;
            }
            if (!accepted.isSuccess()) {
                this.update(Status.get(Stage.EVENT_STATION_SUBSETTER, Standing.REJECT));
                SodDB.commit();
                failLogger.info(String.valueOf(this) + "  " + accepted.toString());
                return;
            }
            SodDB.commit();
            SodDB.getSession().update((Object)this);
            ArrayList<EventChannelPair> chanPairs = new ArrayList<EventChannelPair>();
            if (Start.getWaveformRecipe() instanceof MotionVectorArm) {
                List<ChannelGroup> chanGroups = Start.getNetworkArm().getSuccessfulChannelGroups(this.getStation());
                if (chanGroups.size() == 0) {
                    logger.info("No successful channel groups for " + String.valueOf(this));
                }
                ArrayList<ChannelGroup> arrayList = new ArrayList<ChannelGroup>();
                for (ChannelGroup channelGroup : chanGroups) {
                    if (overlap.overlaps(channelGroup.getChannels()[0])) {
                        arrayList.add(channelGroup);
                        continue;
                    }
                    failLogger.info(ChannelIdUtil.toString(channelGroup.getChannels()[0]) + "'s channel effective time does not overlap the event time");
                }
                for (ChannelGroup channelGroup : arrayList) {
                    logger.debug("Put EventVectorPair (" + this.getEventDbId() + ", cg " + channelGroup.getDbid() + " (" + channelGroup.getChannel1().getDbid() + " " + channelGroup.getChannel2().getDbid() + " " + channelGroup.getChannel3().getDbid());
                    p = new EventVectorPair(this.getEvent(), channelGroup, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG), this);
                    chanPairs.add((EventChannelPair)p);
                    sodDb.put((EventVectorPair)p);
                }
            } else {
                List<Channel> channels = Start.getNetworkArm().getSuccessfulChannels(this.getStation());
                if (channels.size() == 0) {
                    logger.info("No successful channels for " + String.valueOf(this));
                }
                ArrayList<Channel> arrayList = new ArrayList<Channel>();
                for (Channel channel : channels) {
                    if (overlap.overlaps(channel)) {
                        arrayList.add(channel);
                    } else {
                        failLogger.info(ChannelIdUtil.toString(channel) + "'s channel effective time does not overlap the event time");
                    }
                    logger.info(ChannelIdUtil.toString(channel) + "' passed");
                }
                for (Channel channel : arrayList) {
                    p = sodDb.createEventChannelPair(this.getEvent(), channel, this);
                    p.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG));
                    chanPairs.add((EventChannelPair)p);
                }
            }
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS));
            SodDB.commit();
            for (AbstractEventPair abstractEventPair : chanPairs) {
                SodDB.getSession().update((Object)abstractEventPair);
                SodDB.getSession().update((Object)this);
                abstractEventPair.run();
                SodDB.commit();
            }
            logger.debug("End EventStationPair (e=" + this.getEvent().getDbid() + ",s=" + this.getStationDbId() + ") " + String.valueOf(this));
        }
        catch (NoPreferredOrigin e) {
            GlobalExceptionHandler.handle(e);
            SodDB.getSession().update((Object)this);
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SYSTEM_FAILURE));
            SodDB.commit();
            return;
        }
        finally {
            SodDB.commit();
        }
    }

    @Override
    public void update(Status status) {
        this.setStatus(status);
        if (Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().setStatus(this);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventStationPair)) {
            return false;
        }
        EventStationPair ecp = (EventStationPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getStationDbId() == this.getStationDbId();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getStationDbId();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        return "EventStationPair: (" + this.getDbid() + " -> " + this.getEvent().getDbid() + "," + this.getStationDbId() + ") " + String.valueOf(this.getEvent()) + " " + StationIdUtil.toStringFormatDates(this.getStation()) + " " + String.valueOf(this.getStatus());
    }

    public int getStationDbId() {
        return this.station.getDbid();
    }

    public Station getStation() {
        return this.station;
    }

    protected void setStation(Station sta) {
        this.station = sta;
    }
}

