/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate.eventpair;

import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.WaveformArm;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.event.NoPreferredOrigin;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.station.StationIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.subsetter.EventEffectiveTimeOverlap;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventNetworkPair
extends AbstractEventPair {
    private Network networkAttr;
    private static final Logger logger = LoggerFactory.getLogger(EventNetworkPair.class);

    protected EventNetworkPair() {
    }

    public EventNetworkPair(StatefulEvent event, Network net) {
        this(event, net, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
    }

    public EventNetworkPair(StatefulEvent event, Network net, Status status) {
        super(event, status);
        this.setNetwork(net);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        List<EventStationPair> alreadyInDb = SodDB.getSingleton().loadESPForNetwork(this.getEvent(), this.getNetwork());
        ArrayList<EventStationPair> staPairList = new ArrayList<EventStationPair>();
        try {
            int i;
            EventEffectiveTimeOverlap overlap = new EventEffectiveTimeOverlap(this.getEvent());
            Station[] stations = Start.getNetworkArm().getSuccessfulStations(this.getNetwork());
            logger.debug("Begin EventNetworkPair (" + this.getEvent().getDbid() + ",s " + this.getNetworkDbId() + ") " + String.valueOf(this));
            logger.debug(stations.length + " successful stations for " + String.valueOf(this));
            for (i = 0; i < stations.length; ++i) {
                logger.debug("Station successful (" + stations[i].getDbid() + ") " + StationIdUtil.toString(stations[i]));
            }
            for (i = 0; i < stations.length; ++i) {
                EventStationPair p;
                if (!overlap.overlaps(stations[i])) {
                    failLogger.info(StationIdUtil.toString(stations[i]) + "'s station effective time does not overlap the event time.");
                    continue;
                }
                try {
                    p = new EventStationPair(this.getEvent(), NetworkDB.getSingleton().getStation(stations[i].getDbid()));
                    logger.debug("Created ESP " + String.valueOf(p));
                }
                catch (NotFound e) {
                    throw new RuntimeException("Should never happen but I guess it did!", e);
                }
                staPairList.add(p);
            }
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS));
            Class<WaveformArm> clazz = WaveformArm.class;
            synchronized (WaveformArm.class) {
                Iterator it = staPairList.iterator();
                while (it.hasNext()) {
                    EventStationPair p = (EventStationPair)it.next();
                    boolean found = false;
                    for (EventStationPair dbEsp : alreadyInDb) {
                        if (dbEsp.getStationDbId() != p.getStationDbId()) continue;
                        found = true;
                        p = dbEsp;
                        break;
                    }
                    if (found) {
                        if (!p.getStatus().getStanding().equals(Standing.REJECT) && !p.getStatus().getStanding().equals(Standing.SUCCESS)) {
                            p.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
                            SodDB.getSession().update((Object)p);
                            continue;
                        }
                        it.remove();
                        continue;
                    }
                    SodDB.getSession().save((Object)p);
                }
                SodDB.commit();
                // ** MonitorExit[var5_7] (shouldn't be in output)
                SodDB.getSingleton().offerEventStationPair(staPairList);
            }
        }
        catch (NoPreferredOrigin e) {
            GlobalExceptionHandler.handle(e);
            this.update(Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SYSTEM_FAILURE));
            failLogger.warn(this.toString(), (Throwable)e);
        }
        finally {
            SodDB.rollback();
        }
        {
            logger.debug("End EventNetworkPair (" + this.getEvent().getDbid() + ",s " + this.getNetworkDbId() + ") " + String.valueOf(this));
            return;
        }
    }

    @Override
    public void update(Status status) {
        this.setStatus(status);
        Start.getWaveformRecipe().setStatus(this);
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventNetworkPair)) {
            return false;
        }
        EventNetworkPair ecp = (EventNetworkPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getNetworkDbId() == this.getNetworkDbId();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getNetworkDbId();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        return "EventNetworkPair: (" + this.getDbid() + ") " + String.valueOf(this.getEvent()) + " " + String.valueOf(this.getNetwork()) + " " + String.valueOf(this.getStatus());
    }

    public int getNetworkDbId() {
        return this.getNetwork().getDbid();
    }

    public Network getNetwork() {
        return this.networkAttr;
    }

    protected void setNetwork(Network attr) {
        this.networkAttr = attr;
    }
}

