/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate.eventpair;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.BuildVersion;
import edu.sc.seis.sod.LocalSeismogramArm;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.SodDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EventChannelPair
extends AbstractEventChannelPair {
    private Channel chan;
    public static final String BIG_ERROR_MSG = BuildVersion.getVersion() + " An exception occured that would've croaked a waveform worker thread!  These types of exceptions are certainly possible, but they shouldn't be allowed to percolate this far up the stack.  If you are one of those esteemed few working on SOD, it behooves you to attempt to trudge down the stack trace following this message and make certain that whatever threw this exception is no longer allowed to throw beyond its scope.  If on the other hand, you are a user of SOD it would be most appreciated if you would send an email containing the text immediately following this mesage to sod@seis.sc.edu ";
    private static Logger logger = LoggerFactory.getLogger(EventChannelPair.class);

    protected EventChannelPair() {
    }

    public EventChannelPair(StatefulEvent event, Channel chan, EventStationPair esp) {
        this(event, chan, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT), esp);
    }

    public EventChannelPair(StatefulEvent event, Channel chan, Status status, EventStationPair esp) {
        super(event, status, esp);
        this.setChannel(chan);
    }

    @Override
    public void run() {
        try {
            ((LocalSeismogramArm)Start.getWaveformRecipe()).processLocalSeismogramArm(this);
            SodDB.commit();
            logger.debug("Finish ECP: " + String.valueOf(this));
        }
        catch (Throwable t) {
            System.err.println(BIG_ERROR_MSG);
            t.printStackTrace(System.err);
            GlobalExceptionHandler.handle(BIG_ERROR_MSG, t);
            try {
                SodDB.rollback();
                this.update(t, Status.get(Stage.PROCESSOR, Standing.SYSTEM_FAILURE));
                SodDB.commit();
            }
            catch (Throwable tt) {
                System.err.println("SOD cannot update status of ecp, this indicates a significant problem with the database. SOD is now exiting with shame and dispair");
                Start.cataclysmicFailureOfUnbelievableProportions();
            }
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof EventChannelPair)) {
            return false;
        }
        EventChannelPair ecp = (EventChannelPair)o;
        return ecp.getEventDbId() == this.getEventDbId() && ecp.getChannelDbId() == this.chan.getDbid();
    }

    @Override
    public int hashCode() {
        int code = 47 * this.getChannelDbId();
        return code += 23 * this.getEventDbId();
    }

    public String toString() {
        return "EventChannelPair: (" + this.getDbid() + ") " + String.valueOf(this.getEvent()) + " " + ChannelIdUtil.toStringNoDates(this.getChannel()) + " " + String.valueOf(this.getStatus());
    }

    public int getChannelDbId() {
        return this.chan.getDbid();
    }

    public Channel getChannel() {
        return this.chan;
    }

    protected void setChannel(Channel chan) {
        this.chan = chan;
    }
}

