/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate.eventpair;

import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.hibernate.eventpair.CookieEventPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.hibernate.eventpair.MeasurementStorage;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;

public abstract class AbstractEventChannelPair
extends CookieEventPair {
    protected EventStationPair esp;
    private MeasurementStorage cookieJar;

    protected AbstractEventChannelPair() {
    }

    public AbstractEventChannelPair(StatefulEvent event, EventStationPair esp) {
        this(event, Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT), esp);
    }

    public AbstractEventChannelPair(StatefulEvent event, Status status, EventStationPair esp) {
        super(event, status);
        this.setEsp(esp);
    }

    @Override
    public void update(Status status) {
        this.setStatus(status);
        this.updateRetries();
        if (Start.getWaveformRecipe() != null) {
            Start.getWaveformRecipe().setStatus(this);
        }
    }

    protected void setEsp(EventStationPair esp) {
        this.esp = esp;
    }

    public EventStationPair getEsp() {
        return this.esp;
    }

    public MeasurementStorage getCookieJar() {
        if (this.cookieJar == null) {
            this.cookieJar = new MeasurementStorage();
        }
        return this.cookieJar;
    }
}

