/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.sod.hibernate.EventToStatefulDBTranslater;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StatefulEventDB {
    EventToStatefulDBTranslater trans = new EventToStatefulDBTranslater();
    public static final String TIME_ORDER = "preferred.originTime";
    private static StatefulEventDB singleton;
    private static final Logger logger;
    private static Status success;
    private static String baseSuccessfulQuery;

    protected StatefulEventDB() {
    }

    public long put(StatefulEvent event) {
        return this.trans.put(event);
    }

    public List<StatefulEvent> getAll() {
        ArrayList<StatefulEvent> out = new ArrayList<StatefulEvent>();
        List<CacheEvent> l = this.trans.getAll();
        for (CacheEvent e : l) {
            out.add((StatefulEvent)e);
        }
        return out;
    }

    public List<StatefulEvent> getAll(Status status) {
        String q = "from " + StatefulEvent.class.getName() + " e where e.status.stageInt = " + status.getStageInt() + " and e.status.standingInt = " + status.getStandingInt();
        StatefulEventDB statefulEventDB = this;
        Query query = statefulEventDB.trans.getSession().createQuery(q);
        return query.list();
    }

    public int getNumEventsOfStatus(Standing standing) {
        String q = "select count(*) from " + StatefulEvent.class.getName() + " e where e.status.standingInt = " + standing.getVal();
        Query query = this.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return ((Number)result.get(0)).intValue();
        }
        return 0;
    }

    public StatefulEvent getEvent(int dbid) throws NotFound {
        return (StatefulEvent)this.trans.getEvent(dbid);
    }

    public List<StatefulEvent> getEventInTimeRange(TimeRange range) {
        return this.getEventInTimeRange(range, Status.getFromShort((short)2310));
    }

    public List<StatefulEvent> getEventInTimeRange(TimeRange range, Status status) {
        String q = "from " + StatefulEvent.class.getName() + " e where ";
        if (status != null) {
            q = q + " e.status.stageInt = " + status.getStageInt() + " and e.status.standingInt = " + status.getStandingInt() + " AND ";
        }
        q = q + " e.preferred.originTime between :minTime AND :maxTime  ";
        StatefulEventDB statefulEventDB = this;
        Query query = statefulEventDB.trans.getSession().createQuery(q);
        query.setParameter("minTime", (Object)range.getBeginTime());
        query.setParameter("maxTime", (Object)range.getEndTime());
        return query.list();
    }

    public List<StatefulEvent> getEventInTimeRangeRegardlessOfStatus(TimeRange range) {
        return this.getEventInTimeRange(range, null);
    }

    public StatefulEvent getLastEvent() throws NotFound {
        return (StatefulEvent)this.trans.getLastEvent();
    }

    public StatefulEvent[] getEventsByTimeAndDepthRanges(Instant minTime, Instant maxTime, double minDepth, double maxDepth) {
        CacheEvent[] ans = this.trans.getEventsByTimeAndDepthRanges(minTime, maxTime, minDepth, maxDepth);
        StatefulEvent[] out = new StatefulEvent[ans.length];
        for (int i = 0; i < out.length; ++i) {
            out[i] = (StatefulEvent)ans[i];
        }
        return out;
    }

    public int getNumWaiting() {
        Status status = Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT);
        String q = "select count(*) from " + StatefulEvent.class.getName() + " e where e.status.stageInt = " + status.getStageInt() + " and e.status.standingInt = " + status.getStandingInt();
        StatefulEventDB statefulEventDB = this;
        Session session = statefulEventDB.trans.getSession();
        Query query = session.createQuery(q);
        List result = query.list();
        if (result.size() > 0) {
            return ((Long)result.get(0)).intValue();
        }
        return 0;
    }

    public StatefulEvent getNext(Standing standing) {
        Status status = Status.get(Stage.EVENT_CHANNEL_POPULATION, standing);
        String q = "from " + StatefulEvent.class.getName() + " e where e.status.stageInt = " + status.getStageInt() + " and e.status.standingInt = " + status.getStandingInt();
        StatefulEventDB statefulEventDB = this;
        Session session = statefulEventDB.trans.getSession();
        Query query = session.createQuery(q);
        List result = query.list();
        if (result.size() > 0) {
            return (StatefulEvent)result.get(0);
        }
        return null;
    }

    public StatefulEvent getIdenticalEvent(CacheEvent e) {
        return (StatefulEvent)this.trans.getIdenticalEvent(e);
    }

    public List get(String statii, String order, boolean ascending) {
        StatefulEventDB statefulEventDB = this;
        Query q = statefulEventDB.trans.getSession().createQuery("from " + StatefulEvent.class.getName() + " e  where e.status in :statii order by :order :direction");
        q.setString("statii", statii);
        q.setString("order", order);
        q.setString("direction", ascending ? "asc" : "desc");
        return q.list();
    }

    public void flush() {
        StatefulEventDB statefulEventDB = this;
        statefulEventDB.trans.flush();
    }

    public void commit() {
        StatefulEventDB statefulEventDB = this;
        statefulEventDB.trans.commit();
    }

    public void rollback() {
        StatefulEventDB statefulEventDB = this;
        statefulEventDB.trans.rollback();
    }

    public Session getSession() {
        StatefulEventDB statefulEventDB = this;
        return statefulEventDB.trans.getSession();
    }

    public void restartCompletedEvents() {
        Status success = Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS);
        Status inProg = Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.IN_PROG);
        String q = "update " + StatefulEvent.class.getName() + " e set e.status.standingInt = :inProg where e.status.stageInt = " + success.getStageInt() + " and e.status.standingInt = " + success.getStandingInt();
        StatefulEventDB statefulEventDB = this;
        Query query = statefulEventDB.trans.getSession().createQuery(q);
        query.setShort("inProg", inProg.getAsShort());
        int updates = query.executeUpdate();
        logger.info("Reopen " + updates + " events");
    }

    public static StatefulEventDB getSingleton() {
        if (singleton == null) {
            singleton = new StatefulEventDB();
        }
        return singleton;
    }

    public CacheEvent[] getByName(String name) {
        String q = baseSuccessfulQuery + " AND e.attr.name = :name";
        StatefulEventDB statefulEventDB = this;
        Query query = statefulEventDB.trans.getSession().createQuery(q);
        query.setString("name", name);
        List result = query.list();
        CacheEvent[] out = result.toArray(new CacheEvent[0]);
        return out;
    }

    public String[] getCatalogs() {
        return this.trans.getCatalogs();
    }

    public String[] getContributors() {
        return this.trans.getContributors();
    }

    public String[] getCatalogsFor(String contributor) {
        return this.trans.getCatalogsFor(contributor);
    }

    static {
        logger = LoggerFactory.getLogger(StatefulEventDB.class);
        success = Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.SUCCESS);
        baseSuccessfulQuery = "from " + StatefulEvent.class.getName() + " e where  ( e.status.stageInt = " + success.getStageInt() + " and e.status.standingInt = " + success.getStandingInt() + " ) ";
    }
}

