/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.QueryTime;
import edu.sc.seis.sod.SodConfig;
import edu.sc.seis.sod.Start;
import edu.sc.seis.sod.VersionHistory;
import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.AbstractEventPair;
import edu.sc.seis.sod.hibernate.eventpair.EventChannelPair;
import edu.sc.seis.sod.hibernate.eventpair.EventNetworkPair;
import edu.sc.seis.sod.hibernate.eventpair.EventStationPair;
import edu.sc.seis.sod.hibernate.eventpair.EventVectorPair;
import edu.sc.seis.sod.model.common.Version;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.event.StatefulEvent;
import edu.sc.seis.sod.model.status.Stage;
import edu.sc.seis.sod.model.status.Standing;
import edu.sc.seis.sod.model.status.Status;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.io.Serializable;
import java.time.Duration;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import org.hibernate.LockMode;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SodDB
extends AbstractHibernateDB {
    private static final Logger logger = LoggerFactory.getLogger(SodDB.class);
    static String configFile = "edu/sc/seis/sod/hibernate/sod.hbm.xml";
    Duration minRetryDelay = Duration.ofHours(2L);
    float maxRetryDelay = (float)((double)Start.getRunProps().getMaxRetryDelay().toNanos() / 1.0E9);
    float seismogramLatency = (float)((double)Start.getRunProps().getSeismogramLatency().toNanos() / 1.0E9);
    int maxRetries = 5;
    float retryBase = 2.0f;
    private static final String MATCH_CHANNEL_CODES = " channel.id.channel_code = :chanCode and channel.locCode = :locCode and channel.id.station_code = :staCode and channel.station.network.id.network_code = :netCode";
    private Queue<AbstractEventChannelPair> retryToDo = new LinkedList<AbstractEventChannelPair>();
    private Queue<EventNetworkPair> enpToDo = new LinkedList<EventNetworkPair>();
    private Queue<EventStationPair> espToDo = new LinkedList<EventStationPair>();
    private Queue<AbstractEventChannelPair> ecpToDo = new LinkedList<AbstractEventChannelPair>();
    private String retry;
    private String failed;
    private String success;
    private String successPerEvent;
    private String failedPerEvent;
    private String retryPerEvent;
    private String successPerEventStation;
    private String failedPerEventStation;
    private String retryPerEventStation;
    private String totalSuccess;
    private String eventBase;
    private static final String COUNT = "SELECT COUNT(*) ";
    private String espFromNet;
    public static Class<? extends AbstractEventChannelPair> defaultEcpClass = null;
    public Class<? extends AbstractEventChannelPair> ecpClass = null;
    private static SodDB singleton;
    public static final String AT_LEAST_ONCE = "atLeastOnce";
    public static final String AT_MOST_ONCE = "atMostOnce";

    protected SodDB() {
    }

    public void reopenSuspendedEventChannelPairs(String processingRule, boolean vector) {
        Stage[] stages = new Stage[]{Stage.EVENT_CHANNEL_POPULATION, Stage.EVENT_STATION_SUBSETTER, Stage.EVENT_CHANNEL_SUBSETTER, Stage.REQUEST_SUBSETTER, Stage.AVAILABLE_DATA_SUBSETTER, Stage.DATA_RETRIEVAL, Stage.PROCESSOR};
        Object stageList = " ( ";
        for (int i = 0; i < stages.length; ++i) {
            stageList = (String)stageList + stages[i].getVal() + ", ";
        }
        stageList = ((String)stageList).substring(0, ((String)stageList).length() - 2);
        stageList = (String)stageList + " ) ";
        Standing[] standings = new Standing[]{Standing.IN_PROG, Standing.INIT, Standing.SUCCESS};
        Object standingList = " ( ";
        for (int i = 0; i < standings.length; ++i) {
            standingList = (String)standingList + standings[i].getVal() + ", ";
        }
        standingList = ((String)standingList).substring(0, ((String)standingList).length() - 2);
        standingList = (String)standingList + " ) ";
        String setStmt = processingRule.equals(AT_LEAST_ONCE) ? " stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + ", standingInt = " + Standing.INIT.getVal() : " standingInt = " + Standing.SYSTEM_FAILURE.getVal();
        String queryEnd = " set " + setStmt + " WHERE status.stageInt in " + (String)stageList + " AND status.standingInt in " + (String)standingList + " AND NOT (status.stageInt = " + Stage.PROCESSOR.getVal() + " AND status.standingInt = " + Standing.SUCCESS.getVal() + " )  AND NOT (status.stageInt = " + Stage.EVENT_STATION_SUBSETTER.getVal() + " AND status.standingInt = " + Standing.INIT.getVal() + " ) ";
        String query = "UPDATE " + EventChannelPair.class.getName() + queryEnd;
        int out = SodDB.getSession().createQuery(query).executeUpdate();
        query = "UPDATE " + EventVectorPair.class.getName() + queryEnd;
        out += SodDB.getSession().createQuery(query).executeUpdate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventNetworkPair createEventNetworkPair(StatefulEvent event, Network net) {
        Session session = SodDB.getSession();
        EventNetworkPair enp = new EventNetworkPair(event, (Network)session.merge((Object)net), Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
        logger.debug("Put " + String.valueOf(enp));
        session.save((Object)enp);
        Queue<EventNetworkPair> queue = this.enpToDo;
        synchronized (queue) {
            this.enpToDo.offer(enp);
        }
        return enp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerEventNetworkPairs(List<EventNetworkPair> staPairList) {
        for (EventNetworkPair pair : staPairList) {
            Queue<EventNetworkPair> queue = this.enpToDo;
            synchronized (queue) {
                this.enpToDo.offer(pair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerEventStationPair(List<EventStationPair> staPairList) {
        for (EventStationPair eventStationPair : staPairList) {
            Queue<EventStationPair> queue = this.espToDo;
            synchronized (queue) {
                this.espToDo.offer(eventStationPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void offerEventChannelPair(List<AbstractEventChannelPair> chanPairList) {
        for (AbstractEventChannelPair ecp : chanPairList) {
            Queue<AbstractEventChannelPair> queue = this.ecpToDo;
            synchronized (queue) {
                this.ecpToDo.offer(ecp);
            }
        }
    }

    public List<EventStationPair> loadESPForNetwork(StatefulEvent event, Network net) {
        if (this.espFromNet == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.espFromNet);
        query.setEntity("event", (Object)event);
        query.setEntity("net", (Object)net);
        return query.list();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EventStationPair createEventStationPair(StatefulEvent event, Station station) {
        logger.debug("Put esp (" + event.getDbid() + ",s " + station.getDbid() + ") ");
        Session session = SodDB.getSession();
        EventStationPair esp = new EventStationPair(event, (Station)session.merge((Object)station), Status.get(Stage.EVENT_CHANNEL_POPULATION, Standing.INIT));
        session.save((Object)esp);
        Queue<EventStationPair> queue = this.espToDo;
        synchronized (queue) {
            this.espToDo.offer(esp);
        }
        return esp;
    }

    public EventChannelPair createEventChannelPair(StatefulEvent event, Channel chan, EventStationPair esp) {
        Session session = SodDB.getSession();
        EventChannelPair eventChannelPair = new EventChannelPair(event, (Channel)session.merge((Object)chan), esp);
        logger.debug("Put " + String.valueOf(eventChannelPair));
        session.save((Object)eventChannelPair);
        return eventChannelPair;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isECPTodo() {
        Queue<AbstractEventChannelPair> queue = this.ecpToDo;
        synchronized (queue) {
            return !this.ecpToDo.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isESPTodo() {
        Queue<EventStationPair> queue = this.espToDo;
        synchronized (queue) {
            return !this.espToDo.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isENPTodo() {
        Queue<EventNetworkPair> queue = this.enpToDo;
        synchronized (queue) {
            return !this.enpToDo.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventNetworkPair getNextENPFromCache() {
        EventNetworkPair enp;
        Queue<EventNetworkPair> queue = this.enpToDo;
        synchronized (queue) {
            ArrayList<EventNetworkPair> beingLoaded = new ArrayList<EventNetworkPair>();
            enp = this.enpToDo.poll();
            while (enp != null && Start.getNetworkArm().isBeingRefreshed(enp.getNetwork())) {
                beingLoaded.add(enp);
                enp = this.enpToDo.poll();
            }
            this.enpToDo.addAll(beingLoaded);
        }
        if (enp != null) {
            return (EventNetworkPair)SodDB.getSession().merge((Object)enp);
        }
        return null;
    }

    public synchronized EventNetworkPair getNextENP() {
        if (!this.isENPTodo()) {
            this.populateENPToDo();
        }
        return this.getNextENPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateENPToDo() {
        String q = "from " + EventNetworkPair.class.getName() + " e  left join fetch e.event  left join fetch e.network  where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = :standing";
        Query query = SodDB.getSession().createQuery(q);
        query.setInteger("standing", Standing.INIT.getVal());
        query.setMaxResults(100);
        List result = query.list();
        for (EventNetworkPair enpResult : result) {
            Queue<EventNetworkPair> queue = this.enpToDo;
            synchronized (queue) {
                this.enpToDo.offer(enpResult);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized EventStationPair getNextESPFromCache() {
        EventStationPair esp;
        Queue<EventStationPair> queue = this.espToDo;
        synchronized (queue) {
            esp = this.espToDo.poll();
        }
        if (esp != null) {
            return (EventStationPair)SodDB.getSession().merge((Object)esp);
        }
        return null;
    }

    public synchronized EventStationPair getNextESP() {
        if (!this.isESPTodo()) {
            this.populateESPToDo();
        }
        return this.getNextESPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateESPToDo() {
        String q = "from " + EventStationPair.class.getName() + " e  left join fetch e.event  left join fetch e.station  left join fetch e.station.network  where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = :standing ";
        Query query = SodDB.getSession().createQuery(q);
        query.setInteger("standing", Standing.INIT.getVal());
        query.setMaxResults(1000);
        List result = query.list();
        for (EventStationPair eventStationPair : result) {
            Queue<EventStationPair> queue = this.espToDo;
            synchronized (queue) {
                this.espToDo.offer(eventStationPair);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void populateECPToDo() {
        logger.debug("populateECPToDo");
        String q = "from " + this.getEcpClass().getName() + " e  left join fetch e.event ";
        q = this.getEcpClass().equals(EventChannelPair.class) ? q + " left join fetch e.channel  left join fetch e.channel.station  left join fetch e.channel.station.network " : q + " left join fetch e.channelGroup  left join fetch e.channelGroup.channel1.station  left join fetch e.channelGroup.channel1.station.network  left join fetch e.channelGroup.channel2.station  left join fetch e.channelGroup.channel2.station.network  left join fetch e.channelGroup.channel3.station  left join fetch e.channelGroup.channel3.station.network ";
        q = q + " where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = :standing ";
        Query query = SodDB.getSession().createQuery(q);
        query.setInteger("standing", Standing.INIT.getVal());
        query.setMaxResults(1000);
        List result = query.list();
        if (result.size() > 0) {
            logger.info("populate ECP/EVP ToDo: " + result.size());
        }
        for (AbstractEventChannelPair ecp : result) {
            Queue<AbstractEventChannelPair> queue = this.ecpToDo;
            synchronized (queue) {
                this.ecpToDo.offer(ecp);
            }
        }
        logger.debug("Done populateECPToDo " + result.size());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized AbstractEventChannelPair getNextECPFromCache() {
        AbstractEventChannelPair ecp;
        Queue<AbstractEventChannelPair> queue = this.ecpToDo;
        synchronized (queue) {
            ecp = this.ecpToDo.poll();
        }
        if (ecp != null) {
            return (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
        }
        return null;
    }

    public AbstractEventChannelPair getNextECP() {
        if (!this.isECPTodo()) {
            this.populateECPToDo();
        }
        return this.getNextECPFromCache();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEventChannelPair getNextRetryECPFromCache() {
        AbstractEventChannelPair ecp;
        Queue<AbstractEventChannelPair> queue = this.retryToDo;
        synchronized (queue) {
            ecp = this.retryToDo.poll();
        }
        if (ecp != null) {
            return (AbstractEventChannelPair)SodDB.getSession().merge((Object)ecp);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRetryTodo() {
        Queue<AbstractEventChannelPair> queue = this.retryToDo;
        synchronized (queue) {
            return !this.retryToDo.isEmpty();
        }
    }

    public List<AbstractEventChannelPair> getRetryToDo() {
        logger.debug("Getting retry from db");
        String q = "from " + this.getEcpClass().getName() + "  where (status.standingInt = " + Standing.RETRY.getVal() + " or status.standingInt = " + Standing.CORBA_FAILURE.getVal() + " )  and seconds_between(:now, lastQuery) > :minDelay  and numRetries < " + this.maxRetries + " and (seconds_between(:now, lastQuery) > :maxDelay or seconds_between(:now, lastQuery) > power(:base, numRetries))  order by numRetries";
        Query query = SodDB.getSession().createQuery(q);
        query.setParameter("now", (Object)ClockUtil.now());
        query.setFloat("base", this.retryBase);
        query.setFloat("minDelay", (float)TimeUtils.durationToDoubleSeconds((Duration)this.getMinRetryDelay()));
        query.setFloat("maxDelay", (float)((double)Start.getRunProps().getMaxRetryDelay().toNanos() / 1.0E9));
        query.setMaxResults(10000);
        logger.info("retry query: " + q);
        List result = query.list();
        logger.debug("retry query: " + q);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void populateRetryToDo() {
        List<AbstractEventChannelPair> result = this.getRetryToDo();
        for (AbstractEventChannelPair abstractEventChannelPair : result) {
            Queue<AbstractEventChannelPair> queue = this.retryToDo;
            synchronized (queue) {
                this.retryToDo.offer(abstractEventChannelPair);
            }
        }
        logger.debug("Got " + result.size() + " retries from db.");
    }

    public int getNumWorkUnits(Standing standing) {
        return this.getNumWorkUnits(standing, AbstractEventPair.class);
    }

    public int getNumEventNetworkWorkUnits(Standing standing) {
        return this.getNumWorkUnits(standing, EventNetworkPair.class);
    }

    private int getNumWorkUnits(Standing standing, Class EventPairClass) {
        String q = "select count(*) from " + EventPairClass.getName() + " e where e.status.stageInt = " + Stage.EVENT_CHANNEL_POPULATION.getVal() + " and e.status.standingInt = " + standing.getVal() + " and e.numRetries =  0";
        Query query = SodDB.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return ((Number)result.get(0)).intValue();
        }
        return 0;
    }

    public EventChannelPair getECP(CacheEvent event, Channel chan) {
        Query query = SodDB.getSession().createQuery("from " + EventChannelPair.class.getName() + " where event = :event and channel = :channel");
        query.setEntity("event", (Object)event);
        query.setEntity("channel", (Object)chan);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return (EventChannelPair)result.get(0);
        }
        return null;
    }

    public EventVectorPair put(EventVectorPair eventVectorPair) {
        Session session = SodDB.getSession();
        session.lock((Object)eventVectorPair.getEvent(), LockMode.NONE);
        Channel[] chan = eventVectorPair.getChannelGroup().getChannels();
        for (int i = 0; i < chan.length; ++i) {
            session.lock((Object)chan[i], LockMode.NONE);
        }
        session.saveOrUpdate((Object)eventVectorPair);
        return eventVectorPair;
    }

    public Duration getMinRetryDelay() {
        return this.minRetryDelay;
    }

    public int getMaxRetries() {
        return this.maxRetries;
    }

    public int getNumSuccessful() {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.totalSuccess);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumSuccessful(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.successPerEvent);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumSuccessful(Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.success);
        query.setEntity("sta", (Object)station);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumSuccessful(CacheEvent event, Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.successPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumFailed(Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.failed);
        query.setEntity("sta", (Object)station);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumFailed(CacheEvent event, Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.failedPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumFailed(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.failedPerEvent);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumRetry(Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.retry);
        query.setEntity("sta", (Object)station);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumRetry(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.retryPerEvent);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public int getNumRetry(CacheEvent event, Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(COUNT + this.retryPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return ((Long)query.uniqueResult()).intValue();
    }

    public List<AbstractEventChannelPair> getAll(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.eventBase);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getSuccessful(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.successPerEvent);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getSuccessful(Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.success);
        query.setEntity("sta", (Object)station);
        return query.list();
    }

    public List<AbstractEventChannelPair> getSuccessful(CacheEvent event, Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.successPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getFailed(Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.failed);
        query.setEntity("sta", (Object)station);
        return query.list();
    }

    public List<AbstractEventChannelPair> getFailed(CacheEvent event, Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.failedPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getFailed(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.failedPerEvent);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getRetry(Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.retry);
        query.setEntity("sta", (Object)station);
        return query.list();
    }

    public List<AbstractEventChannelPair> getRetry(CacheEvent event) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.retryPerEvent);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<AbstractEventChannelPair> getRetry(CacheEvent event, Station station) {
        if (this.totalSuccess == null) {
            this.initHQLStmts();
        }
        Query query = SodDB.getSession().createQuery(this.retryPerEventStation);
        query.setEntity("sta", (Object)station);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<Station> getStationsForEvent(CacheEvent event) {
        String q = "select distinct ecp.esp.station from " + this.getEcpClass().getName() + " ecp where ecp.event = :event";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public EventStationPair getEventStationPair(CacheEvent event, Station station) {
        String q = "from EventStationPair where event = :event and station = :station";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        query.setEntity("station", (Object)station);
        return (EventStationPair)query.uniqueResult();
    }

    public List<Station> getSuccessfulStationsForEvent(CacheEvent event) {
        String q = "select distinct ecp.esp.station from " + this.getEcpClass().getName() + " ecp where ecp.event = :event and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<Station> getUnsuccessfulStationsForEvent(CacheEvent event) {
        String q = "from " + Station.class.getName() + " s where s not in (select distinct ecp.esp.station from " + this.getEcpClass().getName() + " ecp where ecp.event = :event and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal() + " )";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<EventStationPair> getSuccessfulESPForEvent(CacheEvent event) {
        String q = "from EventStationPair where event = :event and status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("event", (Object)event);
        return query.list();
    }

    public List<CacheEvent> getEventsForStation(Station sta) {
        String q = "select distinct ecp.event from " + this.getEcpClass().getName() + " ecp where ecp.esp.station = :sta ";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public List<EventStationPair> getSuccessfulESPForStation(Station sta) {
        String q = "from EventStationPair where station = :sta and status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public List<StatefulEvent> getSuccessfulEventsForStation(Station sta) {
        String q = "select distinct ecp.event from " + this.getEcpClass().getName() + " ecp where ecp.esp.station = :sta  and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal();
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public List<CacheEvent> getUnsuccessfulEventsForStation(Station sta) {
        String q = "from " + CacheEvent.class.getName() + " e where e not in (select distinct ecp.event from " + this.getEcpClass().getName() + " ecp where ecp.esp.station = :sta  and ecp.status.stageInt = " + Stage.PROCESSOR.getVal() + " and ecp.status.standingInt = " + Standing.SUCCESS.getVal() + " )";
        Query query = SodDB.getSession().createQuery(q);
        query.setEntity("sta", (Object)sta);
        return query.list();
    }

    public int putConfig(SodConfig sodConfig) {
        Integer dbid = (Integer)SodDB.getSession().save((Object)sodConfig);
        return dbid;
    }

    public SodConfig getCurrentConfig() {
        String q = "From edu.sc.seis.sod.SodConfig c ORDER BY c.time desc";
        Query query = SodDB.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return (SodConfig)result.get(0);
        }
        return null;
    }

    public SodConfig getConfig(int configid) {
        return (SodConfig)SodDB.getSession().get(SodConfig.class, (Serializable)Integer.valueOf(configid));
    }

    public QueryTime getQueryTime(String serverName) {
        String q = "From edu.sc.seis.sod.QueryTime q WHERE q.serverName = :serverName";
        Query query = SodDB.getSession().createQuery(q);
        query.setString("serverName", serverName);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            return (QueryTime)result.get(0);
        }
        return null;
    }

    public int putQueryTime(QueryTime qtime) {
        QueryTime indb = this.getQueryTime(qtime.getServerName());
        if (indb != null) {
            indb.setTime(qtime.getTime());
            SodDB.getSession().saveOrUpdate((Object)indb);
            return indb.getDbid();
        }
        Integer dbid = (Integer)SodDB.getSession().save((Object)qtime);
        return dbid;
    }

    public Version getDBVersion() {
        String q = "From " + Version.class.getName() + " ORDER BY dbid desc";
        Session session = SodDB.getSession();
        Query query = SodDB.getSession().createQuery(q);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() > 0) {
            Version out = (Version)result.get(0);
            return out;
        }
        Version v = VersionHistory.current();
        session.save((Object)v);
        return v;
    }

    protected Version putDBVersion() {
        Version v = this.getDBVersion();
        Version current = VersionHistory.current();
        current.setDbid(v.getDbid());
        SodDB.getSession().merge((Object)current);
        SodDB.commit();
        return current;
    }

    public void initHQLStmts() {
        String baseStatement = "FROM " + this.getEcpClass().getName() + " ecp WHERE ";
        String staBase = baseStatement + " ecp.esp.station = :sta ";
        String staEventBase = baseStatement + " ecp.esp.station = :sta and ecp.event = :event ";
        Status pass = Status.get(Stage.PROCESSOR, Standing.SUCCESS);
        String PROCESS_SUCCESS = " ecp.status.stageInt = " + pass.getStageInt() + " AND ecp.status.standingInt = " + pass.getStandingInt();
        this.eventBase = baseStatement + " ecp.event = :event ";
        this.success = staBase + " AND " + PROCESS_SUCCESS;
        String failReq = " AND ecp.status.standingInt in (" + Standing.REJECT.getVal() + " , " + Standing.SYSTEM_FAILURE.getVal() + ")";
        this.failed = staBase + failReq;
        String retryReq = " AND ecp.status.standingInt in (" + Standing.RETRY.getVal() + " , " + Standing.CORBA_FAILURE.getVal() + ")";
        this.retry = staBase + retryReq;
        this.successPerEvent = this.eventBase + " AND " + PROCESS_SUCCESS;
        this.failedPerEvent = this.eventBase + failReq;
        this.retryPerEvent = this.eventBase + retryReq;
        this.successPerEventStation = staEventBase + "  AND " + PROCESS_SUCCESS;
        this.failedPerEventStation = staEventBase + failReq;
        this.retryPerEventStation = staEventBase + retryReq;
        this.totalSuccess = baseStatement + " " + PROCESS_SUCCESS;
        this.espFromNet = "FROM " + EventStationPair.class.getName() + " esp WHERE  esp.event = :event and esp.station.network = :net";
    }

    public static Class<? extends AbstractEventChannelPair> discoverDbEcpClass() {
        try {
            String q = "from " + EventVectorPair.class.getName();
            Query query = SodDB.getSession().createQuery(q);
            query.setMaxResults(1);
            List result = query.list();
            if (result.size() > 0) {
                Class<EventVectorPair> clazz = EventVectorPair.class;
                return clazz;
            }
            Class<EventChannelPair> clazz = EventChannelPair.class;
            return clazz;
        }
        catch (Throwable e) {
            logger.warn("Exception in SodDB.discoverDbEcpClass()", e);
            throw new RuntimeException("Exception in SodDB.discoverDbEcpClass()", e);
        }
        finally {
            SodDB.rollback();
        }
    }

    public static void setDefaultEcpClass(Class<? extends AbstractEventChannelPair> ecpClass) {
        if (ecpClass == null) {
            throw new IllegalArgumentException("ECP Class cannot be null");
        }
        defaultEcpClass = ecpClass;
        if (singleton != null && SodDB.singleton.ecpClass != null && SodDB.singleton.ecpClass != ecpClass) {
            throw new RuntimeException("Setting ecpClass but session is already open with different ecpClass: set(" + String.valueOf(ecpClass) + ") != " + String.valueOf(SodDB.singleton.ecpClass));
        }
    }

    public Class<? extends AbstractEventChannelPair> getEcpClass() {
        if (this.ecpClass == null) {
            if (defaultEcpClass == null) {
                defaultEcpClass = SodDB.discoverDbEcpClass();
            }
            this.ecpClass = defaultEcpClass;
        }
        return this.ecpClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SodDB getSingleton() {
        Class<SodDB> clazz = SodDB.class;
        synchronized (SodDB.class) {
            if (singleton == null) {
                singleton = new SodDB();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return singleton;
        }
    }
}

