/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.bag.Cut;
import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.EventSeismogramFileReference;
import edu.sc.seis.sod.hibernate.NetworkDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.hibernate.SeismogramFileReference;
import edu.sc.seis.sod.hibernate.SeismogramFileTypes;
import edu.sc.seis.sod.model.event.CacheEvent;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.RequestFilter;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.process.waveform.URLDataSetSeismogram;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ReduceTool;
import java.io.File;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SeismogramFileRefDB
extends AbstractHibernateDB {
    private static SeismogramFileRefDB singleton;
    protected NetworkDB chanTable = NetworkDB.getSingleton();
    private static final Duration ONE_SECOND;
    private static final Logger logger;

    public void saveSeismogramToDatabase(Channel channel, SeismogramAttrImpl seis, String fileLocation, SeismogramFileTypes filetype) {
        this.saveSeismogramToDatabase(new SeismogramFileReference(channel, seis, fileLocation, filetype));
    }

    public void saveSeismogramToDatabase(SeismogramFileReference seisRef) {
        SeismogramFileRefDB.getSession().save((Object)seisRef);
    }

    public void saveSeismogramToDatabase(CacheEvent event, Channel channel, SeismogramAttrImpl seis, String fileLocation, SeismogramFileTypes filetype) {
        this.saveSeismogramToDatabase(new EventSeismogramFileReference(event, channel, seis, fileLocation, filetype));
    }

    public void saveSeismogramToDatabase(EventSeismogramFileReference seisRef) {
        SeismogramFileRefDB.getSession().save((Object)seisRef);
    }

    public List<EventSeismogramFileReference> getSeismogramsForEvent(CacheEvent event) {
        String query = "from " + EventSeismogramFileReference.class.getName() + " where event = :event";
        Query q = SeismogramFileRefDB.getSession().createQuery(query);
        q.setEntity("event", (Object)event);
        return q.list();
    }

    public List<EventSeismogramFileReference> getSeismogramsForEventForChannel(CacheEvent event, Channel chan) {
        return this.getSeismogramsForEventForChannel(event, ChannelId.of(chan));
    }

    public List<EventSeismogramFileReference> getSeismogramsForEventForChannel(CacheEvent event, ChannelId chan) {
        String query = "from " + EventSeismogramFileReference.class.getName() + " where event = :event and  networkCode = :netCode and stationCode = :staCode and locCode = :locCode and channelCode = :chanCode ";
        Query q = SeismogramFileRefDB.getSession().createQuery(query);
        q.setEntity("event", (Object)event);
        q.setString("netCode", chan.getNetworkId());
        q.setString("staCode", chan.getStationCode());
        q.setString("locCode", chan.getLocCode());
        q.setString("chanCode", chan.getChannelCode());
        logger.debug("Before query for event: " + event.getDbid() + "  " + ChannelIdUtil.toStringNoDates(chan));
        List esRefList = q.list();
        logger.debug("After query for event: " + event.getDbid() + "  " + ChannelIdUtil.toStringNoDates(chan) + "  found:" + esRefList.size());
        return esRefList;
    }

    public RequestFilter[] findMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) {
        List results = this.queryDatabaseForSeismograms(requestArray, false, ignoreNetworkTimes);
        RequestFilter[] request = results.toArray(new RequestFilter[results.size()]);
        RequestFilter[] reduced = ReduceTool.merge(request);
        return reduced;
    }

    public LocalSeismogramImpl[] getMatchingSeismograms(RequestFilter[] requestArray, boolean ignoreNetworkTimes) {
        List results = this.queryDatabaseForSeismograms(requestArray, true, ignoreNetworkTimes);
        LocalSeismogramImpl[] seis = results.toArray(new LocalSeismogramImpl[0]);
        LocalSeismogramImpl[] reduced = ReduceTool.merge(seis);
        return reduced;
    }

    public List queryDatabaseForSeismograms(RequestFilter[] request, boolean returnSeismograms, boolean ignoreNetworkTimes) {
        RequestFilter[] minimalRequest = ReduceTool.merge(request);
        ArrayList resultCollector = new ArrayList();
        for (int i = 0; i < minimalRequest.length; ++i) {
            this.queryDatabaseForSeismogram(resultCollector, minimalRequest[i], returnSeismograms, ignoreNetworkTimes);
        }
        return resultCollector;
    }

    private void queryDatabaseForSeismogram(List resultCollector, RequestFilter request, boolean returnSeismograms, boolean ignoreNetworkTimes) {
        Channel chanId;
        Cut cutter = new Cut(request);
        try {
            chanId = ignoreNetworkTimes ? this.chanTable.getChannel(request.channelId.getNetworkId(), request.channelId.getStationCode(), request.channelId.getLocCode(), request.channelId.getChannelCode(), request.startTime) : this.chanTable.getChannel(request.channelId);
        }
        catch (NotFound e) {
            logger.warn("Can not find channel ID in database.");
            return;
        }
        Instant adjustedBeginTime = request.startTime.minus(ONE_SECOND);
        Instant adjustedEndTime = request.endTime.plus(ONE_SECOND);
        String query = "from " + SeismogramFileReference.class.getName() + " where networkCode = :netCode and stationCode = :staCode and locCode = :locCode and channelCode = :chanCode  and beginTime < :end and endTime >= :begin";
        Query q = SeismogramFileRefDB.getSession().createQuery(query);
        ChannelId chanIdxxx = ChannelId.of(chanId);
        q.setString("netCode", chanIdxxx.getNetworkId());
        q.setString("staCode", chanIdxxx.getStationCode());
        q.setString("locCode", chanIdxxx.getLocCode());
        q.setString("chanCode", chanIdxxx.getChannelCode());
        q.setParameter("end", (Object)adjustedEndTime);
        q.setParameter("begin", (Object)adjustedBeginTime);
        List databaseResults = q.list();
        if (returnSeismograms) {
            for (SeismogramFileReference seisRef : databaseResults) {
                try {
                    SeismogramFileTypes filetype;
                    File seismogramFile = new File(seisRef.getFilePath());
                    LocalSeismogramImpl curSeis = URLDataSetSeismogram.getSeismogram(seismogramFile, filetype = SeismogramFileTypes.fromInt(seisRef.getFileType()));
                    LocalSeismogramImpl seis = cutter.applyEncoded(curSeis);
                    if (seis == null) continue;
                    resultCollector.add(seis);
                }
                catch (Exception e) {
                    GlobalExceptionHandler.handle("Problem occured while returning seismograms from the database.\nThe problem file is located at " + seisRef.getFilePath(), e);
                }
            }
        } else {
            for (SeismogramFileReference seisRef : databaseResults) {
                RequestFilter req = new RequestFilter(chanIdxxx, seisRef.getBeginTime(), seisRef.getEndTime());
                if ((req = cutter.apply(req)) == null) continue;
                resultCollector.add(req);
            }
        }
    }

    public int removeSeismogramFromDatabase(String seisFile) {
        String query = "delete  " + SeismogramFileReference.class.getName() + " where filePath = " + seisFile;
        return SeismogramFileRefDB.getSession().createQuery(query).executeUpdate();
    }

    public static SeismogramFileRefDB getSingleton() {
        if (singleton == null) {
            singleton = new SeismogramFileRefDB();
        }
        return singleton;
    }

    static {
        ONE_SECOND = Duration.ofSeconds(1L);
        logger = LoggerFactory.getLogger(SeismogramFileRefDB.class);
    }
}

