/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.hibernate.AbstractHibernateDB;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.hibernate.ChannelSensitivity;
import edu.sc.seis.sod.hibernate.InstrumentationBlob;
import edu.sc.seis.sod.hibernate.InstrumentationDB;
import edu.sc.seis.sod.hibernate.NotFound;
import edu.sc.seis.sod.model.station.ChannelGroup;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.NetworkId;
import edu.sc.seis.sod.model.station.NetworkIdUtil;
import edu.sc.seis.sod.model.station.StationId;
import java.io.IOException;
import java.io.Serializable;
import java.time.Instant;
import java.util.Iterator;
import java.util.List;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkDB
extends AbstractHibernateDB {
    private static NetworkDB singleton;
    public static InstrumentationDB instrumentationDB;
    static String getStationByCodes;
    static String getAllStationsByCode;
    static String getStationByIdString;
    static String getStationForNetwork;
    static String getChannelForNetwork;
    static String getStationForNetworkStation;
    static String getChannelForStation;
    static String getChannelGroupForStation;
    static String getChannelForStationAtTime;
    static String chanCodeHQL;
    static String getChannelByCode;
    static String getChannelById;
    static String getAllStationsString;
    static String getAllNetsString;
    static String getNetworkByCodeString;
    private static final Logger logger;

    protected NetworkDB() {
    }

    public int put(Network net) {
        Session session = NetworkDB.getSession();
        if (net.getDbid() != 0) {
            session.saveOrUpdate((Object)net);
            return net.getDbid();
        }
        Iterator<Network> fromDB = this.getNetworkByCode(net.getCode()).iterator();
        if (fromDB.hasNext()) {
            if (NetworkIdUtil.isTemporary(net.getCode())) {
                while (fromDB.hasNext()) {
                    Network indb = fromDB.next();
                    if (!net.getCode().equals(indb.getCode()) || !net.getStartYearString().equals(indb.getStartYearString())) continue;
                    net.associateInDb(indb);
                    NetworkDB.getSession().evict((Object)indb);
                    NetworkDB.getSession().saveOrUpdate((Object)net);
                    return net.getDbid();
                }
            } else {
                Network indb = fromDB.next();
                net.associateInDb(indb);
                NetworkDB.getSession().evict((Object)indb);
                NetworkDB.getSession().saveOrUpdate((Object)net);
                return net.getDbid();
            }
        }
        return (Integer)session.save((Object)net);
    }

    public int put(Station sta) {
        if (sta.getNetwork().getDbid() == 0) {
            throw new IllegalArgumentException("Must put Network before put Station" + sta.toString());
        }
        this.internUnit(sta);
        if (sta.getDbid() != 0) {
            NetworkDB.getSession().saveOrUpdate((Object)sta);
            return sta.getDbid();
        }
        try {
            Station indb = this.getStationById(sta);
            sta.associateInDb(indb);
            NetworkDB.getSession().evict((Object)indb);
            NetworkDB.getSession().evict((Object)indb.getNetwork());
            NetworkDB.getSession().saveOrUpdate((Object)sta);
            return sta.getDbid();
        }
        catch (NotFound e) {
            Integer dbid = (Integer)NetworkDB.getSession().save((Object)sta);
            return dbid;
        }
    }

    public int put(Channel chan) {
        Integer dbid;
        this.internUnit(chan);
        if (chan.getStation().getDbid() == 0) {
            try {
                chan.setStation(this.getStationById(chan.getStation()));
            }
            catch (NotFound e) {
                int n = this.put(chan.getStation());
            }
        }
        try {
            Channel indb = this.getChannelById(chan);
            chan.associateInDb(indb);
            NetworkDB.getSession().evict((Object)indb);
            NetworkDB.getSession().evict((Object)indb.getStation());
            NetworkDB.getSession().evict((Object)indb.getStation().getNetwork());
            NetworkDB.getSession().saveOrUpdate((Object)chan);
            dbid = chan.getDbid();
        }
        catch (NotFound nf) {
            dbid = (Integer)NetworkDB.getSession().save((Object)chan);
        }
        logger.debug("Put channel as " + dbid + " " + ChannelIdUtil.toStringFormatDates(chan) + "  sta dbid=" + chan.getStation().getDbid());
        return dbid;
    }

    public int put(ChannelGroup cg) {
        ChannelGroup indb = this.getChannelGroup(cg.getChannel1(), cg.getChannel2(), cg.getChannel3());
        Channel[] chans = cg.getChannels();
        for (int i = 0; i < chans.length; ++i) {
            if (chans[i].getDbid() != 0) continue;
            try {
                chans[i] = this.getChannelById(chans[i]);
                continue;
            }
            catch (NotFound e) {
                this.put(chans[i]);
            }
        }
        if (indb != null) {
            cg.setDbid(indb.getDbid());
            NetworkDB.getSession().evict((Object)indb);
            NetworkDB.getSession().saveOrUpdate((Object)cg);
            return cg.getDbid();
        }
        int dbid = (Integer)NetworkDB.getSession().save((Object)cg);
        return dbid;
    }

    public List<ChannelGroup> getChannelGroup(Channel chan) {
        Query query = NetworkDB.getSession().createQuery("from " + ChannelGroup.class.getName() + " where channel1 = :chan or channel2 = :chan or channel3 = :chan");
        query.setParameter("chan", (Object)chan);
        return query.list();
    }

    public ChannelGroup getChannelGroup(Channel chanA, Channel chanB, Channel chanC) {
        Query query = NetworkDB.getSession().createQuery("from " + ChannelGroup.class.getName() + " where     ( channel1 = :chanA and channel2 = :chanB and channel3 = :chanC ) or ( channel1 = :chanB and channel2 = :chanA and channel3 = :chanC ) or ( channel1 = :chanC and channel2 = :chanA and channel3 = :chanB ) or ( channel1 = :chanA and channel2 = :chanC and channel3 = :chanB ) or ( channel1 = :chanB and channel2 = :chanC and channel3 = :chanA ) or ( channel1 = :chanC and channel2 = :chanB and channel3 = :chanA )");
        query.setParameter("chanA", (Object)chanA);
        query.setParameter("chanB", (Object)chanB);
        query.setParameter("chanC", (Object)chanC);
        query.setMaxResults(1);
        List l = query.list();
        if (l.size() != 0) {
            return (ChannelGroup)l.get(0);
        }
        return null;
    }

    public List<Station> getStationByCodes(String netCode, String staCode) {
        Query query = NetworkDB.getSession().createQuery(getStationByCodes);
        query.setString("netCode", netCode);
        query.setString("staCode", staCode);
        return query.list();
    }

    public List<Station> getAllStationsByCode(String staCode) {
        Query query = NetworkDB.getSession().createQuery(getAllStationsByCode);
        query.setString("staCode", staCode);
        return query.list();
    }

    public Station getStationById(Station sta) throws NotFound {
        return this.getStationById(StationId.of(sta));
    }

    public Station getStationById(StationId staId) throws NotFound {
        Query query = NetworkDB.getSession().createQuery(getStationByIdString);
        query.setString("netCode", staId.getNetworkId());
        query.setString("staCode", staId.getStationCode());
        query.setParameter("staStart", (Object)staId.getStartTime());
        query.setMaxResults(1);
        List l = query.list();
        logger.debug("getStationById(" + staId.getNetworkId() + "." + staId.getStationCode() + "." + String.valueOf(staId.getStartTime()) + "  return size: " + l.size());
        if (l.size() != 0) {
            return (Station)l.get(0);
        }
        throw new NotFound();
    }

    public List<Network> getNetworkByCode(String netCode) {
        Query query = NetworkDB.getSession().createQuery(getNetworkByCodeString);
        query.setString("netCode", netCode);
        return query.list();
    }

    public Network getNetwork(int dbid) throws NotFound {
        Network out = (Network)NetworkDB.getSession().get(Network.class, (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public List<Network> getAllNetworks() {
        Query query = NetworkDB.getSession().createQuery(getAllNetsString);
        return query.list();
    }

    public Station getStation(int dbid) throws NotFound {
        Station out = (Station)NetworkDB.getSession().get(Station.class, (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public Station[] getAllStations() {
        Query query = NetworkDB.getSession().createQuery(getAllStationsString);
        List result = query.list();
        return result.toArray(new Station[0]);
    }

    public List<Station> getStationForNet(Network attr) {
        Query query = NetworkDB.getSession().createQuery(getStationForNetwork);
        query.setParameter("netAttr", (Object)attr);
        return query.list();
    }

    public List<Station> getStationForNet(Network attr, String staCode) {
        Query query = NetworkDB.getSession().createQuery(getStationForNetworkStation);
        query.setParameter("netAttr", (Object)attr);
        query.setString("staCode", staCode);
        return query.list();
    }

    public List<Channel> getChannelsForNet(Network attr) {
        Query query = NetworkDB.getSession().createQuery(getChannelForNetwork);
        query.setParameter("netAttr", (Object)attr);
        return query.list();
    }

    public Channel getChannel(int dbid) throws NotFound {
        Channel out = (Channel)NetworkDB.getSession().get(Channel.class, (Serializable)new Integer(dbid));
        if (out == null) {
            throw new NotFound();
        }
        return out;
    }

    public List<Channel> getAllChannels() {
        return NetworkDB.getSession().createQuery("from " + Channel.class.getName()).list();
    }

    public List<Channel> getChannelsForStation(Station station) {
        Query query = NetworkDB.getSession().createQuery(getChannelForStation);
        query.setParameter("station", (Object)station);
        List out = query.list();
        logger.debug("getChannelsForStation(" + station.getDbid() + " found " + out.size() + "  query=" + String.valueOf(query));
        return out;
    }

    public List<ChannelGroup> getChannelGroupsForStation(Station station) {
        if (!NetworkDB.getSession().contains((Object)station)) {
            NetworkDB.getSession().saveOrUpdate((Object)station);
        }
        Query query = NetworkDB.getSession().createQuery(getChannelGroupForStation);
        query.setParameter("station", (Object)station);
        List out = query.list();
        logger.info("NetworkDB replace station to avoid null " + String.valueOf(station));
        for (ChannelGroup cg : out) {
            for (Channel c : cg.getChannels()) {
                c.setStation(station);
            }
        }
        return out;
    }

    public List<Channel> getChannelsForStation(Station station, Instant when) {
        Query query = NetworkDB.getSession().createQuery(getChannelForStationAtTime);
        query.setParameter("station", (Object)station);
        query.setParameter("when", (Object)when);
        return query.list();
    }

    public Channel getChannel(String net, String sta, String loc, String chan, Instant when) throws NotFound {
        return this.getChannel(net, sta, loc, chan, when, getChannelByCode);
    }

    public List<Channel> getChannelsByCode(NetworkId net, String sta, String loc, String chan) {
        String queryString = "From " + Channel.class.getName() + " WHERE " + chanCodeHQL + " AND station.network.startDateTime = :when";
        Query query = NetworkDB.getSession().createQuery(queryString);
        query.setString("netCode", net.getNetworkCode());
        query.setString("stationCode", sta);
        query.setString("locCode", loc);
        query.setString("channelCode", chan);
        query.setParameter("when", (Object)net.getStartYear());
        return query.list();
    }

    public Channel getChannelById(Channel chan) throws NotFound {
        return this.getChannel(ChannelId.of(chan));
    }

    public Channel getChannel(ChannelId id) throws NotFound {
        return this.getChannel(id.getNetworkId(), id.getStationCode(), id.getLocCode(), id.getChannelCode(), id.getStartTime(), getChannelById);
    }

    protected Channel getChannel(String net, String sta, String loc, String chan, Instant when, String queryString) throws NotFound {
        Query query = NetworkDB.getSession().createQuery(queryString);
        query.setString("netCode", net);
        query.setString("stationCode", sta);
        String sc = loc.trim();
        if (sc.equals("--") || sc.equals("") || sc.equals("  ")) {
            sc = "";
        }
        query.setString("locCode", sc);
        query.setString("channelCode", chan);
        query.setParameter("when", (Object)when);
        query.setMaxResults(1);
        List result = query.list();
        if (result.size() == 0) {
            throw new NotFound();
        }
        return (Channel)result.get(0);
    }

    public InstrumentationBlob getInstrumentationBlob(Channel chan) throws ChannelNotFound {
        String queryString = "WHERE channel = :chan";
        logger.warn("NetworkDB.getInstrumentationBlob : " + queryString);
        Query query = NetworkDB.getSession().createQuery(queryString, InstrumentationBlob.class);
        query.setParameter("chan", (Object)chan);
        Iterator it = query.iterate();
        if (it.hasNext()) {
            InstrumentationBlob ib = (InstrumentationBlob)it.next();
            return ib;
        }
        return null;
    }

    public Response getResponse(Channel chan) throws ChannelNotFound {
        try {
            return instrumentationDB.load(chan);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public ChannelSensitivity getSensitivity(Channel chan) {
        Query query = NetworkDB.getSession().createQuery("FROM " + ChannelSensitivity.class.getName() + " WHERE channel = :chan");
        query.setParameter("chan", (Object)chan);
        Iterator it = query.iterate();
        if (it.hasNext()) {
            ChannelSensitivity sense = (ChannelSensitivity)it.next();
            return sense;
        }
        return null;
    }

    public void putSensitivity(ChannelSensitivity sensitivity) {
        ChannelSensitivity inDb = this.getSensitivity(sensitivity.getChannel());
        if (inDb != null) {
            sensitivity.setDbid(inDb.getDbid());
            NetworkDB.getSession().evict((Object)inDb);
        }
        sensitivity.setInputUnits(NetworkDB.intern(sensitivity.getInputUnits()));
        NetworkDB.getSession().saveOrUpdate((Object)sensitivity);
    }

    public void putResponse(Channel chan, Response inst) {
        logger.debug("Put response: " + ChannelIdUtil.toStringNoDates(chan));
        try {
            instrumentationDB.save(chan, inst);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Deprecated
    public void internUnit(Station sta) {
    }

    @Deprecated
    public void internUnit(Channel chan) {
    }

    public static NetworkDB getSingleton() {
        if (singleton == null) {
            singleton = new NetworkDB();
        }
        return singleton;
    }

    static {
        getStationByCodes = "SELECT s From " + Station.class.getName() + " s WHERE s.network.networkCode = :netCode AND s.stationCode = :staCode";
        getAllStationsByCode = "SELECT s From " + Station.class.getName() + " s WHERE s.stationCode = :staCode";
        getStationByIdString = getStationByCodes + " AND s.startDateTime = :staStart";
        getStationForNetwork = "From " + Station.class.getName() + " s WHERE s.network = :netAttr";
        getChannelForNetwork = "From " + Channel.class.getName() + " WHERE station.network = :netAttr";
        getStationForNetworkStation = getStationForNetwork + " and s.stationCode = :staCode";
        getChannelForStation = "From " + Channel.class.getName() + " c WHERE c.station = :station";
        getChannelGroupForStation = "From " + ChannelGroup.class.getName() + " c WHERE c.channel1.station = :station";
        getChannelForStationAtTime = getChannelForStation + " and :when between c.startDateTime and c.endDateTime  order by c.startDateTime desc";
        chanCodeHQL = " channelCode = :channelCode AND locCode = :locCode AND station.stationCode = :stationCode AND station.network.networkCode = :netCode ";
        getChannelByCode = "From " + Channel.class.getName() + " WHERE " + chanCodeHQL + " AND :when between startDateTime and endDateTime order by startDateTime desc";
        getChannelById = "From " + Channel.class.getName() + " WHERE " + chanCodeHQL + " AND startDateTime =  :when";
        getAllStationsString = "From edu.sc.seis.seisFile.fdsnws.stationxml.Station s";
        getAllNetsString = "From edu.sc.seis.seisFile.fdsnws.stationxml.Network n";
        getNetworkByCodeString = getAllNetsString + " WHERE networkCode = :netCode";
        logger = LoggerFactory.getLogger(NetworkDB.class);
    }
}

