/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.seisFile.fdsnws.stationxml.BaseNodeType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Network;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.model.station.StationIdUtil;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NetworkConsistencyCheck {
    private static final Logger logger = LoggerFactory.getLogger(NetworkConsistencyCheck.class);

    public static boolean isConsistent(Network net, Station sta) {
        TimeRange staRange = new TimeRange((BaseNodeType)sta);
        TimeRange netRange = new TimeRange((BaseNodeType)net);
        if (netRange.getBeginTime().isAfter(staRange.getBeginTime())) {
            logger.warn("Network begins after station: " + net.toString() + "  " + StationIdUtil.toString(sta));
            return false;
        }
        return true;
    }

    public static boolean isConsistent(List<? extends Station> staList) {
        if (staList.size() < 2) {
            return true;
        }
        List<? extends Station> subStaList = staList.subList(1, staList.size());
        Station first = staList.get(0);
        for (Station station : subStaList) {
            if (NetworkConsistencyCheck.isConsistent(first, station)) continue;
            return false;
        }
        return NetworkConsistencyCheck.isConsistent(subStaList);
    }

    public static boolean isConsistent(Station staA, Station staB) {
        if (!staA.getNetwork().getCode().equals(staB.getNetwork().getCode()) || !staA.getCode().equals(staB.getCode())) {
            return true;
        }
        TimeRange staARange = new TimeRange((BaseNodeType)staA);
        TimeRange staBRange = new TimeRange((BaseNodeType)staB);
        if (staARange.intersects(staBRange)) {
            logger.warn("Station overlaps other station: " + StationIdUtil.toString(staA) + "-" + staA.getEndDate() + "   " + StationIdUtil.toString(staB) + "-" + staB.getEndDate().toString());
            return false;
        }
        return true;
    }

    public static boolean isConsistent(Station sta, Channel chan) {
        TimeRange staRange = new TimeRange((BaseNodeType)sta);
        TimeRange chanRange = new TimeRange((BaseNodeType)chan);
        if (staRange.getBeginTime().isAfter(chanRange.getBeginTime())) {
            logger.warn("Station begins after channel: " + ChannelIdUtil.toStringNoDates(chan) + " " + String.valueOf(chanRange) + "    " + StationIdUtil.toString(sta) + " " + String.valueOf(staRange));
            return false;
        }
        return true;
    }
}

