/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.sod.hibernate.ChannelNotFound;
import edu.sc.seis.sod.hibernate.InstrumentationBlob;
import edu.sc.seis.sod.status.FissuresFormatter;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;

public class InstrumentationDB {
    private final File dbdir;

    public InstrumentationDB(File dbdir) {
        this.dbdir = dbdir;
    }

    public File save(Channel channel, Response response) throws IOException {
        File instFile = this.instFile(channel);
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(instFile));
        if (response != null) {
            out.write(InstrumentationBlob.getResponseAsBlob(channel, response));
        }
        out.close();
        return instFile;
    }

    public Response load(Channel channel) throws IOException, ChannelNotFound {
        File instFile = this.instFile(channel);
        if (!instFile.exists()) {
            return null;
        }
        BufferedInputStream out = new BufferedInputStream(new FileInputStream(instFile));
        byte[] instBytes = out.readAllBytes();
        Response response = null;
        if (instBytes.length == 0) {
            throw new ChannelNotFound("File " + instFile.toString() + " is empty.", channel);
        }
        response = InstrumentationBlob.getResponseFromBlob(instBytes);
        return response;
    }

    public File instFile(Channel channel) {
        File staDir;
        File netDir = new File(this.dbdir, channel.getNetworkId());
        if (!netDir.exists()) {
            netDir.mkdirs();
        }
        if (!(staDir = new File(netDir, channel.getStationCode())).exists()) {
            staDir.mkdirs();
        }
        String chanFilename = FissuresFormatter.filize(channel.getNetworkCode() + "_" + channel.getStationCode() + "_" + channel.getLocCode() + "_" + channel.getChannelCode() + "_" + channel.getStartDate());
        File instFile = new File(staDir, chanFilename);
        return instFile;
    }
}

