/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Coefficients;
import edu.sc.seis.seisFile.fdsnws.stationxml.Decimation;
import edu.sc.seis.seisFile.fdsnws.stationxml.FIR;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatNoUnitType;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.GainSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentPolynomial;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.Pole;
import edu.sc.seis.seisFile.fdsnws.stationxml.PoleZero;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.Polynomial;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseList;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseListElement;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import edu.sc.seis.seisFile.fdsnws.stationxml.Zero;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.msgpack.core.MessageBufferPacker;
import org.msgpack.core.MessagePack;
import org.msgpack.core.MessageUnpacker;

public class InstrumentationBlob {
    Channel chan;
    Response response;
    int dbid;

    protected InstrumentationBlob() {
    }

    public InstrumentationBlob(Channel chan, Response response) {
        this.chan = chan;
        this.response = response;
    }

    public static byte[] getResponseAsBlob(Channel chan, Response response) throws IOException {
        MessageBufferPacker packer = MessagePack.newDefaultBufferPacker();
        int mapSize = 0;
        if (response.getResponseStageList() != null) {
            ++mapSize;
        }
        if (response.getInstrumentSensitivity() != null) {
            ++mapSize;
        }
        packer.packMapHeader(mapSize);
        if (response.getResponseStageList() != null) {
            List stageList = response.getResponseStageList();
            packer.packString("Stage");
            packer.packArrayHeader(stageList.size());
            for (ResponseStage stage : stageList) {
                InstrumentationBlob.packStage(packer, stage);
            }
        }
        if (response.getInstrumentSensitivity() != null) {
            packer.packString("InstrumentSensitivity");
            InstrumentationBlob.packGainSensitivity(packer, (GainSensitivity)response.getInstrumentSensitivity());
        }
        packer.close();
        return packer.toByteArray();
    }

    protected static MessageBufferPacker packStage(MessageBufferPacker packer, ResponseStage stage) throws IOException {
        int objSize = 1;
        if (stage.getResponseItem() != null) {
            ++objSize;
        }
        if (stage.getDecimation() != null) {
            ++objSize;
        }
        if (stage.getStageSensitivity() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        packer.packString("number").packInt(stage.getNumber().intValue());
        BaseFilterType respItem = stage.getResponseItem();
        if (respItem instanceof PolesZeros) {
            packer.packString("PolesZeros");
            InstrumentationBlob.packPolesZeros(packer, (PolesZeros)respItem);
        } else if (respItem instanceof Coefficients) {
            packer.packString("Coefficients");
            InstrumentationBlob.packCoefficients(packer, (Coefficients)respItem);
        } else if (respItem instanceof ResponseList) {
            packer.packString("ResponseList");
            InstrumentationBlob.packResponseList(packer, (ResponseList)respItem);
        } else if (respItem instanceof FIR) {
            packer.packString("FIR");
            InstrumentationBlob.packFIR(packer, (FIR)respItem);
        } else if (respItem instanceof Polynomial) {
            packer.packString("Polynomial");
            InstrumentationBlob.packPolynomial(packer, (Polynomial)respItem);
        }
        if (stage.getStageSensitivity() != null) {
            packer.packString("StageGain");
            InstrumentationBlob.packGainSensitivity(packer, stage.getStageSensitivity());
        }
        if (stage.getDecimation() != null) {
            packer.packString("Decimation");
            InstrumentationBlob.packDecimation(packer, stage.getDecimation());
        }
        return packer;
    }

    protected static ResponseStage unpackStage(MessageUnpacker unpacker) throws IOException {
        Integer number = 0;
        String resourceId = null;
        PolesZeros responseItem = null;
        Decimation decimation = null;
        GainSensitivity stageGain = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("resourceId".equals(key)) {
                resourceId = unpacker.unpackString();
                continue;
            }
            if ("number".equals(key)) {
                number = unpacker.unpackInt();
                continue;
            }
            if ("PolesZeros".equals(key)) {
                responseItem = InstrumentationBlob.unpackPolesZeros(unpacker);
                continue;
            }
            if ("Coefficients".equals(key)) {
                responseItem = InstrumentationBlob.unpackCoefficients(unpacker);
                continue;
            }
            if ("ResponseList".equals(key)) {
                responseItem = InstrumentationBlob.unpackResponseList(unpacker);
                continue;
            }
            if ("FIR".equals(key)) {
                responseItem = InstrumentationBlob.unpackFIR(unpacker);
                continue;
            }
            if ("Polynomial".equals(key)) {
                responseItem = InstrumentationBlob.unpackPolynomial(unpacker);
                continue;
            }
            if ("Decimation".equals(key)) {
                decimation = InstrumentationBlob.unpackDecimation(unpacker);
                continue;
            }
            if ("StageGain".equals(key)) {
                stageGain = InstrumentationBlob.unpackGainSensitivity(unpacker);
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new ResponseStage(number, resourceId, responseItem, decimation, stageGain);
    }

    protected static MessageBufferPacker packPolesZeros(MessageBufferPacker packer, PolesZeros polesZeros) throws IOException {
        int objSize = 7;
        if (polesZeros.getDescription() != null) {
            ++objSize;
        }
        if (polesZeros.getResourceId() != null) {
            ++objSize;
        }
        if (polesZeros.getName() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        if (polesZeros.getResourceId() != null) {
            packer.packString("resourceId").packString(polesZeros.getResourceId());
        }
        if (polesZeros.getName() != null) {
            packer.packString("Name").packString(polesZeros.getName());
        }
        if (polesZeros.getDescription() != null) {
            packer.packString("Description").packString(polesZeros.getDescription());
        }
        packer.packString("InputUnits");
        InstrumentationBlob.packUnit(packer, polesZeros.getInputUnits());
        packer.packString("OutputUnits");
        InstrumentationBlob.packUnit(packer, polesZeros.getOutputUnits());
        packer.packString("PzTransferFunctionType").packString(polesZeros.getPzTransferType());
        packer.packString("NormalizationFactor").packFloat(polesZeros.getNormalizationFactor());
        packer.packString("NormalizationFrequency").packFloat(polesZeros.getNormalizationFreq());
        packer.packString("Zero").packArrayHeader(polesZeros.getZeroList().size());
        for (Zero z : polesZeros.getZeroList()) {
            InstrumentationBlob.packPoleZero(packer, (PoleZero)z);
        }
        packer.packString("Pole").packArrayHeader(polesZeros.getPoleList().size());
        for (Zero z : polesZeros.getPoleList()) {
            InstrumentationBlob.packPoleZero(packer, (PoleZero)z);
        }
        return packer;
    }

    protected static PolesZeros unpackPolesZeros(MessageUnpacker unpacker) throws IOException {
        String resourceId = null;
        String description = null;
        String name = null;
        Unit inputUnits = null;
        Unit outputUnits = null;
        String pzTransferFunctionType = null;
        float normalizationFactor = 1.0f;
        float normalizationFrequency = Float.NaN;
        ArrayList<Zero> zeroList = new ArrayList<Zero>();
        ArrayList<Pole> poleList = new ArrayList<Pole>();
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            int j;
            int size;
            String key = unpacker.unpackString();
            if ("resourceId".equals(key)) {
                resourceId = unpacker.unpackString();
                continue;
            }
            if ("Name".equals(key)) {
                name = unpacker.unpackString();
                continue;
            }
            if ("Description".equals(key)) {
                description = unpacker.unpackString();
                continue;
            }
            if ("InputUnits".equals(key)) {
                inputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("OutputUnits".equals(key)) {
                outputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("PzTransferFunctionType".equals(key)) {
                pzTransferFunctionType = unpacker.unpackString();
                continue;
            }
            if ("NormalizationFactor".equals(key)) {
                normalizationFactor = unpacker.unpackFloat();
                continue;
            }
            if ("NormalizationFrequency".equals(key)) {
                normalizationFrequency = unpacker.unpackFloat();
                continue;
            }
            if ("Pole".equals(key)) {
                size = unpacker.unpackArrayHeader();
                for (j = 0; j < size; ++j) {
                    poleList.add((Pole)InstrumentationBlob.unpackPoleZero(unpacker, "Pole"));
                }
                continue;
            }
            if ("Zero".equals(key)) {
                size = unpacker.unpackArrayHeader();
                for (j = 0; j < size; ++j) {
                    zeroList.add((Zero)InstrumentationBlob.unpackPoleZero(unpacker, "Zero"));
                }
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new PolesZeros(resourceId, name, description, inputUnits, outputUnits, pzTransferFunctionType, normalizationFactor, normalizationFrequency, zeroList, poleList);
    }

    protected static MessageBufferPacker packPoleZero(MessageBufferPacker packer, PoleZero poleZero) throws IOException {
        int objSize = 2;
        packer.packMapHeader(objSize);
        packer.packString("Real");
        InstrumentationBlob.packFloatNoUnitType(packer, poleZero.getRealWithError());
        packer.packString("Imaginary");
        InstrumentationBlob.packFloatNoUnitType(packer, poleZero.getImaginaryWithError());
        return packer;
    }

    protected static PoleZero unpackPoleZero(MessageUnpacker unpacker, String tagName) throws IOException {
        FloatNoUnitType realWithError = null;
        FloatNoUnitType imaginaryWithError = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Real".equals(key)) {
                realWithError = InstrumentationBlob.unpackFloatNoUnitType(unpacker);
                continue;
            }
            if ("Imaginary".equals(key)) {
                imaginaryWithError = InstrumentationBlob.unpackFloatNoUnitType(unpacker);
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        if (tagName.equals("Pole")) {
            return new Pole(realWithError, imaginaryWithError);
        }
        return new Zero(realWithError, imaginaryWithError);
    }

    protected static MessageBufferPacker packCoefficients(MessageBufferPacker packer, Coefficients coefficients) throws IOException {
        int objSize = 5;
        if (coefficients.getDescription() != null) {
            ++objSize;
        }
        if (coefficients.getResourceId() != null) {
            ++objSize;
        }
        if (coefficients.getName() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        if (coefficients.getResourceId() != null) {
            packer.packString("resourceId").packString(coefficients.getResourceId());
        }
        if (coefficients.getName() != null) {
            packer.packString("Name").packString(coefficients.getName());
        }
        if (coefficients.getDescription() != null) {
            packer.packString("Description").packString(coefficients.getDescription());
        }
        packer.packString("InputUnits");
        InstrumentationBlob.packUnit(packer, coefficients.getInputUnits());
        packer.packString("OutputUnits");
        InstrumentationBlob.packUnit(packer, coefficients.getOutputUnits());
        packer.packString("CfTransferFunctionType").packString(coefficients.getCfTransferType());
        packer.packString("Numerator").packArrayHeader(coefficients.getNumeratorList().size());
        for (FloatType f : coefficients.getNumeratorList()) {
            InstrumentationBlob.packFloatType(packer, f);
        }
        packer.packString("Denominator").packArrayHeader(coefficients.getDenominatorList().size());
        for (FloatType f : coefficients.getDenominatorList()) {
            InstrumentationBlob.packFloatType(packer, f);
        }
        return packer;
    }

    protected static Coefficients unpackCoefficients(MessageUnpacker unpacker) throws IOException {
        String resourceId = null;
        String description = null;
        String name = null;
        Unit inputUnits = null;
        Unit outputUnits = null;
        String cfTransferType = null;
        ArrayList<FloatType> numeratorList = new ArrayList<FloatType>();
        ArrayList<FloatType> denomenatorList = new ArrayList<FloatType>();
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            int j;
            int size;
            String key = unpacker.unpackString();
            if ("resourceId".equals(key)) {
                resourceId = unpacker.unpackString();
                continue;
            }
            if ("Name".equals(key)) {
                name = unpacker.unpackString();
                continue;
            }
            if ("Description".equals(key)) {
                description = unpacker.unpackString();
                continue;
            }
            if ("InputUnits".equals(key)) {
                inputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("OutputUnits".equals(key)) {
                outputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("CfTransferFunctionType".equals(key)) {
                cfTransferType = unpacker.unpackString();
                continue;
            }
            if ("Numerator".equals(key)) {
                size = unpacker.unpackArrayHeader();
                for (j = 0; j < size; ++j) {
                    numeratorList.add(InstrumentationBlob.unpackFloatType(unpacker));
                }
                continue;
            }
            if ("Denominator".equals(key)) {
                size = unpacker.unpackArrayHeader();
                for (j = 0; j < size; ++j) {
                    denomenatorList.add(InstrumentationBlob.unpackFloatType(unpacker));
                }
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new Coefficients(resourceId, name, description, inputUnits, outputUnits, cfTransferType, numeratorList, denomenatorList);
    }

    protected static MessageBufferPacker packResponseList(MessageBufferPacker packer, ResponseList responseList) throws IOException {
        int objSize = 3;
        if (responseList.getDescription() != null) {
            ++objSize;
        }
        if (responseList.getResourceId() != null) {
            ++objSize;
        }
        if (responseList.getName() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        if (responseList.getResourceId() != null) {
            packer.packString("resourceId").packString(responseList.getResourceId());
        }
        if (responseList.getName() != null) {
            packer.packString("Name").packString(responseList.getName());
        }
        if (responseList.getDescription() != null) {
            packer.packString("Description").packString(responseList.getDescription());
        }
        packer.packString("InputUnits");
        InstrumentationBlob.packUnit(packer, responseList.getInputUnits());
        packer.packString("OutputUnits");
        InstrumentationBlob.packUnit(packer, responseList.getOutputUnits());
        packer.packString("ResponseListElement").packArrayHeader(responseList.getResponseElements().size());
        for (ResponseListElement f : responseList.getResponseElements()) {
            InstrumentationBlob.packResponseListElement(packer, f);
        }
        return packer;
    }

    protected static ResponseList unpackResponseList(MessageUnpacker unpacker) throws IOException {
        String resourceId = null;
        String description = null;
        String name = null;
        Unit inputUnits = null;
        Unit outputUnits = null;
        ArrayList<ResponseListElement> responseElements = new ArrayList<ResponseListElement>();
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("resourceId".equals(key)) {
                resourceId = unpacker.unpackString();
                continue;
            }
            if ("Name".equals(key)) {
                name = unpacker.unpackString();
                continue;
            }
            if ("Description".equals(key)) {
                description = unpacker.unpackString();
                continue;
            }
            if ("InputUnits".equals(key)) {
                inputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("OutputUnits".equals(key)) {
                outputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("ResponseListElement".equals(key)) {
                int size = unpacker.unpackArrayHeader();
                for (int j = 0; j < size; ++j) {
                    responseElements.add(InstrumentationBlob.unpackResponseListElement(unpacker));
                }
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new ResponseList(resourceId, name, description, inputUnits, outputUnits, responseElements);
    }

    protected static MessageBufferPacker packResponseListElement(MessageBufferPacker packer, ResponseListElement rle) throws IOException {
        int objSize = 3;
        packer.packMapHeader(objSize);
        packer.packString("Frequency");
        InstrumentationBlob.packFloatType(packer, rle.getFrequency());
        packer.packString("Amplitude");
        InstrumentationBlob.packFloatType(packer, rle.getAmplitude());
        packer.packString("Phase");
        InstrumentationBlob.packFloatType(packer, rle.getPhase());
        return packer;
    }

    protected static ResponseListElement unpackResponseListElement(MessageUnpacker unpacker) throws IOException {
        FloatType frequency = null;
        FloatType amplitude = null;
        FloatType phase = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Frequency".equals(key)) {
                frequency = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            if ("Amplitude".equals(key)) {
                amplitude = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            if ("Phase".equals(key)) {
                phase = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new ResponseListElement(frequency, amplitude, phase);
    }

    protected static MessageBufferPacker packPolynomial(MessageBufferPacker packer, Polynomial polynomial) throws IOException {
        int objSize = 9;
        if (polynomial.getDescription() != null) {
            ++objSize;
        }
        if (polynomial.getResourceId() != null) {
            ++objSize;
        }
        if (polynomial.getName() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        if (polynomial.getResourceId() != null) {
            packer.packString("resourceId").packString(polynomial.getResourceId());
        }
        if (polynomial.getName() != null) {
            packer.packString("Name").packString(polynomial.getName());
        }
        if (polynomial.getDescription() != null) {
            packer.packString("Description").packString(polynomial.getDescription());
        }
        packer.packString("InputUnits");
        InstrumentationBlob.packUnit(packer, polynomial.getInputUnits());
        packer.packString("OutputUnits");
        InstrumentationBlob.packUnit(packer, polynomial.getOutputUnits());
        packer.packString("ApproximationType").packString(polynomial.getApproximationType());
        packer.packString("FrequencyLowerBound");
        InstrumentationBlob.packFloatType(packer, polynomial.getFreqLowerBound());
        packer.packString("FrequencyUpperBound");
        InstrumentationBlob.packFloatType(packer, polynomial.getFreqUpperBound());
        packer.packString("ApproximationLowerBound").packFloat(polynomial.getApproxLowerBound());
        packer.packString("ApproximationUpperBound").packFloat(polynomial.getApproxUpperBound());
        packer.packString("MaximumError").packFloat(polynomial.getMaxError());
        packer.packString("Coefficient").packArrayHeader(polynomial.getCoefficientList().size());
        for (FloatNoUnitType f : polynomial.getCoefficientList()) {
            InstrumentationBlob.packFloatNoUnitType(packer, f);
        }
        return packer;
    }

    protected static Polynomial unpackPolynomial(MessageUnpacker unpacker) throws IOException {
        String resourceId = null;
        String description = null;
        String name = null;
        Unit inputUnits = null;
        Unit outputUnits = null;
        String approximationType = null;
        FloatType freqLowerBound = null;
        FloatType freqUpperBound = null;
        float approxLowerBound = Float.NaN;
        float approxUpperBound = Float.NaN;
        float maxError = Float.NaN;
        ArrayList<FloatNoUnitType> coefficientList = new ArrayList<FloatNoUnitType>();
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("resourceId".equals(key)) {
                resourceId = unpacker.unpackString();
                continue;
            }
            if ("Name".equals(key)) {
                name = unpacker.unpackString();
                continue;
            }
            if ("Description".equals(key)) {
                description = unpacker.unpackString();
                continue;
            }
            if ("InputUnits".equals(key)) {
                inputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("OutputUnits".equals(key)) {
                outputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("ApproximationType".equals(key)) {
                approximationType = unpacker.unpackString();
                continue;
            }
            if ("FrequencyLowerBound".equals(key)) {
                freqLowerBound = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            if ("FrequencyUpperBound".equals(key)) {
                freqUpperBound = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            if ("ApproximationLowerBound".equals(key)) {
                approxLowerBound = unpacker.unpackFloat();
                continue;
            }
            if ("ApproximationUpperBound".equals(key)) {
                approxUpperBound = unpacker.unpackFloat();
                continue;
            }
            if ("MaximumError".equals(key)) {
                maxError = unpacker.unpackFloat();
                continue;
            }
            if ("Coefficient".equals(key)) {
                int size = unpacker.unpackArrayHeader();
                for (int j = 0; j < size; ++j) {
                    coefficientList.add(InstrumentationBlob.unpackFloatNoUnitType(unpacker));
                }
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new Polynomial(resourceId, name, description, inputUnits, outputUnits, approximationType, freqLowerBound, freqUpperBound, approxLowerBound, approxUpperBound, maxError, coefficientList);
    }

    protected static MessageBufferPacker packFIR(MessageBufferPacker packer, FIR fir) throws IOException {
        int objSize = 4;
        if (fir.getDescription() != null) {
            ++objSize;
        }
        if (fir.getResourceId() != null) {
            ++objSize;
        }
        if (fir.getName() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        if (fir.getResourceId() != null) {
            packer.packString("resourceId").packString(fir.getResourceId());
        }
        if (fir.getName() != null) {
            packer.packString("Name").packString(fir.getName());
        }
        if (fir.getDescription() != null) {
            packer.packString("Description").packString(fir.getDescription());
        }
        packer.packString("InputUnits");
        InstrumentationBlob.packUnit(packer, fir.getInputUnits());
        packer.packString("OutputUnits");
        InstrumentationBlob.packUnit(packer, fir.getOutputUnits());
        packer.packString("Symmetry").packString(fir.getSymmetry());
        packer.packString("NumeratorCoefficient").packArrayHeader(fir.getNumeratorCoefficientList().size());
        for (Float f : fir.getNumeratorCoefficientList()) {
            packer.packFloat(f.floatValue());
        }
        return packer;
    }

    protected static FIR unpackFIR(MessageUnpacker unpacker) throws IOException {
        String resourceId = null;
        String description = null;
        String name = null;
        Unit inputUnits = null;
        Unit outputUnits = null;
        String symmetry = null;
        ArrayList<Float> numeratorCoefficientList = new ArrayList<Float>();
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("NumeratorCoefficient".equals(key)) {
                numeratorCoefficientList.add(Float.valueOf(unpacker.unpackFloat()));
                continue;
            }
            if ("resourceId".equals(key)) {
                resourceId = unpacker.unpackString();
                continue;
            }
            if ("Name".equals(key)) {
                name = unpacker.unpackString();
                continue;
            }
            if ("Description".equals(key)) {
                description = unpacker.unpackString();
                continue;
            }
            if ("InputUnits".equals(key)) {
                inputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("OutputUnits".equals(key)) {
                outputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("Symmetry".equals(key)) {
                symmetry = unpacker.unpackString();
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new FIR(resourceId, name, description, inputUnits, outputUnits, symmetry, numeratorCoefficientList);
    }

    protected static MessageBufferPacker packDecimation(MessageBufferPacker packer, Decimation decimation) throws IOException {
        int objSize = 5;
        packer.packMapHeader(objSize);
        packer.packString("InputSampleRate").packFloat(decimation.getInputSampleRate());
        packer.packString("Factor").packInt(decimation.getFactor());
        packer.packString("Offset").packInt(decimation.getOffset());
        packer.packString("Delay");
        InstrumentationBlob.packFloatType(packer, decimation.getDelay());
        packer.packString("Correction");
        InstrumentationBlob.packFloatType(packer, decimation.getCorrection());
        return packer;
    }

    protected static Decimation unpackDecimation(MessageUnpacker unpacker) throws IOException {
        float inputSampleRate = Float.NaN;
        int factor = 0;
        int offset = 0;
        FloatType delay = null;
        FloatType correction = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("InputSampleRate".equals(key)) {
                inputSampleRate = unpacker.unpackFloat();
                continue;
            }
            if ("Factor".equals(key)) {
                factor = unpacker.unpackInt();
                continue;
            }
            if ("Offset".equals(key)) {
                offset = unpacker.unpackInt();
                continue;
            }
            if ("Delay".equals(key)) {
                delay = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            if ("Correction".equals(key)) {
                correction = InstrumentationBlob.unpackFloatType(unpacker);
                continue;
            }
            throw new IOException("unknown key in object: " + key);
        }
        return new Decimation(inputSampleRate, factor, offset, delay, correction);
    }

    protected static MessageBufferPacker packGainSensitivity(MessageBufferPacker packer, GainSensitivity gain) throws IOException {
        int objSize = 2;
        packer.packMapHeader(objSize);
        packer.packString("Value").packFloat(gain.getSensitivityValue());
        packer.packString("Frequency").packFloat(gain.getFrequency());
        return packer;
    }

    protected static GainSensitivity unpackGainSensitivity(MessageUnpacker unpacker) throws IOException {
        float sensitivityValue = Float.NaN;
        float frequency = Float.NaN;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Value".equals(key)) {
                sensitivityValue = unpacker.unpackFloat();
                continue;
            }
            if (!"Frequency".equals(key)) continue;
            frequency = unpacker.unpackFloat();
        }
        return new GainSensitivity(sensitivityValue, frequency);
    }

    protected static MessageBufferPacker packSensitivity(MessageBufferPacker packer, InstrumentSensitivity sensitivity) throws IOException {
        int objSize = 2;
        if (sensitivity.getFrequencyStart() != 0.0f) {
            ++objSize;
        }
        if (sensitivity.getFrequencyEnd() != 0.0f) {
            ++objSize;
        }
        if (sensitivity.getFrequencyDbVariation() != 0.0f) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        packer.packString("Value").packFloat(sensitivity.getSensitivityValue());
        packer.packString("Frequency").packFloat(sensitivity.getFrequency());
        if (sensitivity.getFrequencyStart() != 0.0f) {
            packer.packString("FrequencyStart").packFloat(sensitivity.getFrequencyStart());
        }
        if (sensitivity.getFrequencyEnd() != 0.0f) {
            packer.packString("FrequencyEnd").packFloat(sensitivity.getFrequencyEnd());
        }
        if (sensitivity.getFrequencyDbVariation() != 0.0f) {
            packer.packString("FrequencyDBVariation").packFloat(sensitivity.getFrequencyDbVariation());
        }
        return packer;
    }

    protected static InstrumentSensitivity unpackSensitivity(MessageUnpacker unpacker) throws IOException {
        Unit inputUnits = null;
        Unit outputUnits = null;
        float frequencyStart = Float.NaN;
        float frequencyEnd = Float.NaN;
        float frequencyDbVariation = Float.NaN;
        float sensitivityValue = Float.NaN;
        float frequency = Float.NaN;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Value".equals(key)) {
                sensitivityValue = unpacker.unpackFloat();
                continue;
            }
            if ("Frequency".equals(key)) {
                frequency = unpacker.unpackFloat();
                continue;
            }
            if ("InputUnits".equals(key)) {
                inputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("OutputUnits".equals(key)) {
                outputUnits = InstrumentationBlob.unpackUnit(unpacker);
                continue;
            }
            if ("FrequencyStart".equals(key)) {
                frequencyStart = unpacker.unpackFloat();
                continue;
            }
            if ("FrequencyEnd".equals(key)) {
                frequencyEnd = unpacker.unpackFloat();
                continue;
            }
            if (!"FrequencyDBVariation".equals(key)) continue;
            frequencyDbVariation = unpacker.unpackFloat();
        }
        return new InstrumentSensitivity(sensitivityValue, frequency, inputUnits, outputUnits, frequencyStart, frequencyEnd, frequencyDbVariation);
    }

    protected static MessageBufferPacker packUnit(MessageBufferPacker packer, Unit unit) throws IOException {
        int objSize = 1;
        if (unit.getDescription() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        packer.packString("Name").packString(unit.getName());
        if (unit.getDescription() != null) {
            packer.packString("Description").packString(unit.getDescription());
        }
        return packer;
    }

    protected static Unit unpackUnit(MessageUnpacker unpacker) throws IOException {
        String name = null;
        String description = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Name".equals(key)) {
                name = unpacker.unpackString();
                continue;
            }
            if (!"Description".equals(key)) continue;
            description = unpacker.unpackString();
        }
        return new Unit(name, description);
    }

    protected static MessageBufferPacker packFloatType(MessageBufferPacker packer, FloatType floatType) throws IOException {
        int objSize = 1;
        if (floatType.getUnit() != null) {
            ++objSize;
        }
        if (floatType.getPlusError() != null) {
            ++objSize;
        }
        if (floatType.getMinusError() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        packer.packString("Value").packFloat(floatType.getValue());
        if (floatType.getUnit() != null) {
            packer.packString("unit").packString(floatType.getUnit());
        }
        if (floatType.getPlusError() != null) {
            packer.packString("plusError").packFloat(floatType.getPlusError().floatValue());
        }
        if (floatType.getMinusError() != null) {
            packer.packString("minusError").packFloat(floatType.getMinusError().floatValue());
        }
        return packer;
    }

    protected static FloatNoUnitType unpackFloatNoUnitType(MessageUnpacker unpacker) throws IOException {
        float value = Float.NaN;
        Float plusError = null;
        Float minusError = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Value".equals(key)) {
                value = unpacker.unpackFloat();
                continue;
            }
            if ("plusError".equals(key)) {
                plusError = Float.valueOf(unpacker.unpackFloat());
                continue;
            }
            if (!"minusError".equals(key)) continue;
            minusError = Float.valueOf(unpacker.unpackFloat());
        }
        return new FloatNoUnitType(value, plusError, minusError);
    }

    protected static MessageBufferPacker packFloatNoUnitType(MessageBufferPacker packer, FloatNoUnitType floatType) throws IOException {
        int objSize = 1;
        if (floatType.getPlusError() != null) {
            ++objSize;
        }
        if (floatType.getMinusError() != null) {
            ++objSize;
        }
        packer.packMapHeader(objSize);
        packer.packString("Value").packFloat(floatType.getValue());
        if (floatType.getPlusError() != null) {
            packer.packString("plusError").packFloat(floatType.getPlusError().floatValue());
        }
        if (floatType.getMinusError() != null) {
            packer.packString("minusError").packFloat(floatType.getMinusError().floatValue());
        }
        return packer;
    }

    protected static FloatType unpackFloatType(MessageUnpacker unpacker) throws IOException {
        float value = Float.NaN;
        String unit = null;
        Float plusError = null;
        Float minusError = null;
        int objSize = unpacker.unpackMapHeader();
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Value".equals(key)) {
                value = unpacker.unpackFloat();
                continue;
            }
            if ("unit".equals(key)) {
                unit = unpacker.unpackString();
                continue;
            }
            if ("plusError".equals(key)) {
                plusError = Float.valueOf(unpacker.unpackFloat());
                continue;
            }
            if (!"minusError".equals(key)) continue;
            minusError = Float.valueOf(unpacker.unpackFloat());
        }
        return new FloatType(value, unit, plusError, minusError);
    }

    public static Response unpackResponse(MessageUnpacker unpacker) throws IOException {
        int objSize = unpacker.unpackMapHeader();
        ArrayList<ResponseStage> stageList = new ArrayList<ResponseStage>();
        InstrumentSensitivity sensitivity = null;
        InstrumentPolynomial polynomial = null;
        for (int i = 0; i < objSize; ++i) {
            String key = unpacker.unpackString();
            if ("Stage".equals(key)) {
                int numStages = unpacker.unpackArrayHeader();
                stageList = new ArrayList(numStages);
                for (int j = 0; j < numStages; ++j) {
                    stageList.add(InstrumentationBlob.unpackStage(unpacker));
                }
                continue;
            }
            if (!"InstrumentSensitivity".equals(key)) continue;
            sensitivity = InstrumentationBlob.unpackSensitivity(unpacker);
        }
        return new Response(stageList, sensitivity, polynomial);
    }

    public static Response getResponseFromBlob(byte[] byteArray) throws IOException {
        if (byteArray.length > 0) {
            MessageUnpacker unpacker = MessagePack.newDefaultUnpacker((byte[])byteArray);
            return InstrumentationBlob.unpackResponse(unpacker);
        }
        return null;
    }

    public Response getResponse() {
        return this.response;
    }

    public Channel getChannel() {
        return this.chan;
    }

    public void setChannel(Channel chan) {
        this.chan = chan;
    }

    public int getDbid() {
        return this.dbid;
    }

    public void setDbid(int dbid) {
        this.dbid = dbid;
    }
}

