/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.sod.hibernate.CustomSessionFactoryObserver;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLSyntaxErrorException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.Predicate;
import net.sf.ehcache.CacheManager;
import org.hibernate.SessionFactory;
import org.hibernate.SessionFactoryObserver;
import org.hibernate.boot.Metadata;
import org.hibernate.boot.MetadataBuilder;
import org.hibernate.boot.MetadataSources;
import org.hibernate.boot.SessionFactoryBuilder;
import org.hibernate.boot.registry.StandardServiceRegistry;
import org.hibernate.boot.registry.StandardServiceRegistryBuilder;
import org.hibernate.dialect.function.SQLFunction;
import org.hibernate.dialect.function.SQLFunctionTemplate;
import org.hibernate.service.ServiceRegistry;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.hbm2ddl.TargetTypeHelper;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.Type;
import org.hsqldb.HsqlException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HibernateUtil {
    private static final Logger logger = LoggerFactory.getLogger(HibernateUtil.class);
    private static Metadata metadata;
    private static SessionFactory sessionFactory;
    private static Properties props;
    public static final URL DEFAULT_EHCACHE_CONFIG;

    public static synchronized SessionFactory getSessionFactory() {
        if (sessionFactory == null) {
            throw new RuntimeException("Sessionfactory is null, HibernateUtil.setUp must be called first.");
        }
        return sessionFactory;
    }

    private static void addDateFunctions(MetadataBuilder metadataBuilder) {
        String dbUrl = props.getProperty("hibernate.connection.url");
        if (dbUrl.startsWith("jdbc:hsql")) {
            metadataBuilder.applySqlFunction("datediff", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "datediff(?1, ?2, ?3)"));
            metadataBuilder.applySqlFunction("milliseconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "datediff('ms', ?1, ?2)"));
            metadataBuilder.applySqlFunction("seconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "datediff('ss', ?1, ?2)"));
        } else if (dbUrl.startsWith("jdbc:postgresql")) {
            metadataBuilder.applySqlFunction("milliseconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "extract(epoch from (?2 - ?1)) * 1000"));
            metadataBuilder.applySqlFunction("seconds_between", (SQLFunction)new SQLFunctionTemplate((Type)StandardBasicTypes.LONG, "extract(epoch from (?2 - ?1))"));
        }
    }

    public static void setUp(Properties props, URL ehcacheConfig) {
        if (!props.containsKey("ehcache.disk.store.dir")) {
            Object dirname = "hibernate_ehcache";
            try {
                File f = File.createTempFile((String)dirname, ".cache");
                f.delete();
                dirname = f.mkdir() ? f.getCanonicalPath() : (String)dirname + "_" + Math.random();
            }
            catch (IOException e) {
                dirname = (String)dirname + "_" + Math.random();
            }
            props.put("ehcache.disk.store.dir", dirname);
        }
        System.err.println("ToDo: set up ehcache or another...");
        HibernateUtil.setUp(props);
    }

    static void setUpEHCache(URL ehcacheConfig) {
        if (ehcacheConfig == null) {
            throw new IllegalArgumentException("ehcacheConfig cannot be null");
        }
        try {
            CacheManager cacheManager = CacheManager.create((InputStream)ehcacheConfig.openStream());
        }
        catch (IOException e) {
            throw new RuntimeException("Trouble finding EhCache config from " + ehcacheConfig.toString(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setUp(Properties inProps) {
        Class<HibernateUtil> clazz = HibernateUtil.class;
        synchronized (HibernateUtil.class) {
            props = inProps;
            StandardServiceRegistry standardRegistry = new StandardServiceRegistryBuilder().applySettings((Map)props).build();
            MetadataBuilder metadataBuilder = new MetadataSources((ServiceRegistry)standardRegistry).addResource("edu/sc/seis/sod/hibernate/StationXML.hbm.xml").addResource("edu/sc/seis/sod/hibernate/Common.hbm.xml").addResource("edu/sc/seis/sod/hibernate/Event.hbm.xml").addResource("edu/sc/seis/sod/hibernate/sod.hbm.xml").addResource("edu/sc/seis/sod/hibernate/SeisFileRef.hbm.xml").getMetadataBuilder();
            HibernateUtil.addDateFunctions(metadataBuilder);
            metadata = metadataBuilder.build();
            SessionFactoryBuilder sessionFactoryBuilder = metadata.getSessionFactoryBuilder();
            sessionFactoryBuilder.addSessionFactoryObservers(new SessionFactoryObserver[]{new CustomSessionFactoryObserver()});
            sessionFactory = sessionFactoryBuilder.build();
            HibernateUtil.deploySchema(true);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void deploySchema(boolean haltOnError) {
        EnumSet targetTypes = TargetTypeHelper.parseCommandLineOptions((String)"script,database");
        SchemaUpdate update = new SchemaUpdate().setOutputFile("sod_hibernate.out").setHaltOnError(haltOnError).setDelimiter(null);
        update.execute(targetTypes, metadata);
        List exceptions = update.getExceptions();
        for (Throwable t : exceptions) {
            logger.warn("problem update schema", t);
        }
        if (haltOnError && exceptions.size() > 0) {
            ArrayList<Throwable> filteredExceptions = new ArrayList<Throwable>();
            filteredExceptions.addAll(exceptions);
            filteredExceptions.removeIf(HibernateUtil.isSqlExceptionOK());
            if (filteredExceptions.size() > 0) {
                Throwable first = (Throwable)filteredExceptions.get(0);
                if (first instanceof Exception) {
                    throw new RuntimeException("Problem updating schema " + exceptions.size() + " exceptions, first is ", first);
                }
                throw (RuntimeException)first;
            }
        }
    }

    private static Predicate<Throwable> isSqlExceptionOK() {
        return new Predicate<Throwable>(){

            @Override
            public boolean test(Throwable t) {
                Throwable rootCause = t;
                while (rootCause.getCause() != null) {
                    rootCause = rootCause.getCause();
                }
                return (rootCause instanceof HsqlException || rootCause instanceof SQLSyntaxErrorException) && rootCause.getMessage().startsWith("a FOREIGN KEY constraint already exists");
            }
        };
    }

    static {
        DEFAULT_EHCACHE_CONFIG = HibernateUtil.class.getClassLoader().getResource("edu/sc/seis/sod/data/ehcache.xml");
    }
}

