/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.hibernate;

import edu.sc.seis.sod.hibernate.ConnMgr;
import edu.sc.seis.sod.hibernate.HibernateUtil;
import edu.sc.seis.sod.hibernate.PrintIfNotCalledOff;
import edu.sc.seis.sod.hibernate.SessionStackTrace;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitBase;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.util.exceptionHandler.DefaultExtractor;
import edu.sc.seis.sod.util.exceptionHandler.GlobalExceptionHandler;
import edu.sc.seis.sod.util.time.ClockUtil;
import java.lang.ref.WeakReference;
import java.sql.SQLException;
import java.time.Duration;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.StatelessSession;
import org.hibernate.query.NativeQuery;
import org.hibernate.query.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHibernateDB {
    public static boolean DEBUG_SESSION_CREATION = true;
    public static int DEBUG_SESSION_CREATION_SECONDS = 300;
    protected static SessionFactory sessionFactory;
    private static ThreadLocal<HashSet<UnitImpl>> unitCacheTL;
    private static boolean commonUnitsSaved;
    private static ThreadLocal<Session> sessionTL;
    private static List<WeakReference<SessionStackTrace>> knownSessions;
    private static Duration MAX_SESSION_LIFE;
    private static final Logger logger;

    public AbstractHibernateDB() {
        logger.debug("init " + String.valueOf(this));
    }

    public static Object getTXID() {
        if (ConnMgr.getDB_TYPE().equals("POSTGRES")) {
            NativeQuery query = AbstractHibernateDB.getSession().createSQLQuery("select virtualtransaction from pg_locks where pid = pg_backend_pid()");
            return query.list().get(0);
        }
        return "";
    }

    private static synchronized void saveCommonUnits() {
        Session s = HibernateUtil.getSessionFactory().openSession();
        s.beginTransaction();
        Query q = s.createQuery("From " + UnitImpl.class.getName());
        List result = q.list();
        if (result.size() == 0) {
            AbstractHibernateDB.saveCommonUnit(s, UnitImpl.METER);
            AbstractHibernateDB.saveCommonUnit(s, UnitImpl.KILOMETER);
            AbstractHibernateDB.saveCommonUnit(s, UnitImpl.SECOND);
            AbstractHibernateDB.saveCommonUnit(s, UnitImpl.METER_PER_SECOND);
        }
        s.getTransaction().commit();
        s.close();
        commonUnitsSaved = true;
    }

    private static synchronized void saveCommonUnit(Session s, UnitImpl unitToAdd) {
        if (!unitToAdd.isBaseUnit()) {
            for (UnitImpl subU : unitToAdd.getSubUnitsList()) {
                AbstractHibernateDB.saveCommonUnit(s, subU);
            }
        }
        s.saveOrUpdate((Object)unitToAdd);
        logger.debug("save " + String.valueOf(unitToAdd) + " to database");
    }

    private static void loadUnits(Session s) {
        Query q = s.createQuery("From edu.sc.seis.sod.model.common.UnitImpl");
        List result = q.list();
        AbstractHibernateDB.getUnitCache().addAll(result);
    }

    @Deprecated
    protected static SessionFactory getSessionFactory() throws Exception {
        return HibernateUtil.getSessionFactory();
    }

    protected static Session createSession() {
        if (!commonUnitsSaved) {
            AbstractHibernateDB.saveCommonUnits();
        }
        Session cacheSession = HibernateUtil.getSessionFactory().openSession();
        cacheSession.beginTransaction();
        if (DEBUG_SESSION_CREATION) {
            knownSessions.add(new WeakReference<SessionStackTrace>(new SessionStackTrace(cacheSession, Thread.currentThread().getStackTrace())));
        }
        return cacheSession;
    }

    public static StatelessSession getReadOnlySession() {
        return HibernateUtil.getSessionFactory().openStatelessSession();
    }

    public static boolean isSessionOpen() {
        return sessionTL.get() != null;
    }

    public static Session getSession() {
        Session s = sessionTL.get();
        if (s == null) {
            s = AbstractHibernateDB.createSession();
            sessionTL.set(s);
        }
        return s;
    }

    public static void flush() {
        Session s = sessionTL.get();
        if (s == null) {
            throw new RuntimeException("Can not flush before session creation");
        }
        s.flush();
    }

    public static void commit() {
        Session s = sessionTL.get();
        if (s == null) {
            logger.info("Commit session before creation, nothing to do");
            return;
        }
        PrintIfNotCalledOff delayMessage = new PrintIfNotCalledOff("TRANSACTION Commit on " + String.valueOf(s) + "  " + String.valueOf(AbstractHibernateDB.getTXID()));
        sessionTL.set(null);
        unitCacheTL.set(null);
        s.getTransaction().commit();
        s.close();
        delayMessage.callOff();
    }

    public static void rollback() {
        Session s = sessionTL.get();
        if (s == null) {
            return;
        }
        sessionTL.set(null);
        unitCacheTL.set(null);
        try {
            s.getTransaction().rollback();
        }
        catch (HibernateException hibernateException) {
        }
        finally {
            s.close();
        }
    }

    public static void internUnit(Location loc) {
        AbstractHibernateDB.internUnit(loc.depth);
        AbstractHibernateDB.internUnit(loc.elevation);
    }

    public static void internUnit(QuantityImpl q) {
        QuantityImpl.internUnit(q, AbstractHibernateDB.intern(q.getUnit()));
    }

    protected static UnitImpl intern(UnitImpl unit) {
        if (unit == null || unit.getDbid() != null && unit.getDbid() != 0) {
            return unit;
        }
        HashSet<UnitImpl> unitCache = AbstractHibernateDB.getUnitCache();
        if (unitCache.size() == 0) {
            AbstractHibernateDB.loadUnits(AbstractHibernateDB.getSession());
        }
        for (UnitImpl internUnit : unitCache) {
            if (!unit.equals(internUnit)) continue;
            return internUnit;
        }
        if (unit.getBaseUnit().equals(UnitBase.COMPOSITE)) {
            UnitImpl[] internedSubUnits = new UnitImpl[unit.getNumSubUnits()];
            for (int i = 0; i < unit.getNumSubUnits(); ++i) {
                internedSubUnits[i] = AbstractHibernateDB.intern(unit.getSubUnit(i));
            }
            unit = new UnitImpl(internedSubUnits, unit.getPower(), unit.name, unit.getMultiFactor(), unit.getExponent());
        }
        AbstractHibernateDB.getSession().save((Object)unit);
        unitCache.add(unit);
        return unit;
    }

    protected static HashSet<UnitImpl> getUnitCache() {
        HashSet<UnitImpl> out = unitCacheTL.get();
        if (out == null) {
            out = new HashSet();
            unitCacheTL.set(out);
        }
        return out;
    }

    static {
        unitCacheTL = new ThreadLocal<HashSet<UnitImpl>>(){

            @Override
            protected synchronized HashSet<UnitImpl> initialValue() {
                return new HashSet<UnitImpl>();
            }
        };
        commonUnitsSaved = false;
        sessionTL = new ThreadLocal();
        knownSessions = Collections.synchronizedList(new LinkedList());
        MAX_SESSION_LIFE = Duration.ofSeconds(300L);
        logger = LoggerFactory.getLogger(AbstractHibernateDB.class);
        GlobalExceptionHandler.add(new DefaultExtractor(){

            @Override
            public boolean canExtract(Throwable throwable) {
                return throwable instanceof SQLException;
            }

            @Override
            public String extract(Throwable throwable) {
                return super.extract(throwable);
            }

            @Override
            public Throwable getSubThrowable(Throwable throwable) {
                if (throwable instanceof SQLException) {
                    return ((SQLException)throwable).getNextException();
                }
                return null;
            }
        });
        if (DEBUG_SESSION_CREATION) {
            logger.info("zombie session checker started");
            Timer t = new Timer("zombie session checker", true);
            t.schedule(new TimerTask(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    List<WeakReference<SessionStackTrace>> list = knownSessions;
                    synchronized (list) {
                        Iterator<WeakReference<SessionStackTrace>> iterator = knownSessions.iterator();
                        while (iterator.hasNext()) {
                            SessionStackTrace item = (SessionStackTrace)iterator.next().get();
                            if (item == null || !item.session.isOpen()) {
                                iterator.remove();
                                continue;
                            }
                            if (!ClockUtil.now().minus(MAX_SESSION_LIFE).isAfter(item.createTime)) continue;
                            Duration aliveTime = Duration.between(item.createTime, ClockUtil.now());
                            logger.debug("Session still open after " + String.valueOf(aliveTime) + " seconds. create time=" + String.valueOf(item.createTime));
                            for (int i = 0; i < item.stackTrace.length; ++i) {
                                logger.debug(item.stackTrace[i].toString());
                            }
                        }
                    }
                }
            }, DEBUG_SESSION_CREATION_SECONDS * 1000, (long)(DEBUG_SESSION_CREATION_SECONDS * 1000));
        }
    }
}

