/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.channelGroup;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.channelGroup.SiteChannelRule;
import edu.sc.seis.sod.model.station.ChannelGroup;
import java.util.ArrayList;
import java.util.List;
import org.w3c.dom.Element;

public class SiteMatchRule
extends SiteChannelRule {
    public char[] codes;

    public SiteMatchRule(String orientationCodes) {
        this.codes = orientationCodes.trim().toCharArray();
    }

    public SiteMatchRule(Element el) {
        this(el.getAttribute("orientations"));
    }

    @Override
    public List<ChannelGroup> acceptable(List<Channel> chanList, List<Channel> failures) {
        List<ChannelGroup> out = this.acceptable(null, chanList, failures);
        return out;
    }

    List<ChannelGroup> acceptable(Channel first, List<Channel> chanList, List<Channel> failures) {
        ArrayList<ChannelGroup> out = new ArrayList<ChannelGroup>();
        if (first != null) {
            Channel second = null;
            Channel third = null;
            for (Channel chan : chanList) {
                if (this.codes[1] == chan.getChannelCode().charAt(2)) {
                    second = chan;
                }
                if (this.codes[2] != chan.getChannelCode().charAt(2)) continue;
                third = chan;
            }
            if (second != null && third != null) {
                out.add(new ChannelGroup(new Channel[]{first, second, third}));
                chanList.remove(second);
                chanList.remove(third);
            } else {
                failures.add(first);
            }
        }
        if (chanList.size() > 2) {
            Channel nextFirst = null;
            for (Channel c : chanList) {
                if (this.codes[0] != c.getChannelCode().charAt(2)) continue;
                nextFirst = c;
                chanList.remove(nextFirst);
                break;
            }
            if (nextFirst != null) {
                out.addAll(this.acceptable(nextFirst, chanList, failures));
            } else {
                failures.addAll(chanList);
                chanList.clear();
            }
        } else {
            failures.addAll(chanList);
            chanList.clear();
        }
        return out;
    }
}

