/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModel;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.TauP.TauP_Time;
import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.seisFile.fdsnws.stationxml.Station;
import edu.sc.seis.sod.model.common.DistAz;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.event.OriginImpl;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TauPUtil {
    static Map<String, TauPUtil> taupUtilMap = new HashMap<String, TauPUtil>();
    TauP_Time taup_time;
    private static final Logger logger = LoggerFactory.getLogger(TauPUtil.class);

    private TauPUtil(String modelName) throws TauModelException {
        this.taup_time = new TauP_Time(modelName);
    }

    public List<Arrival> calcTravelTimes(Station station, OriginImpl origin, String[] phaseNames) throws TauPException {
        return this.calcTravelTimes(Location.of(station), origin, phaseNames);
    }

    public List<Arrival> calcTravelTimes(Channel channel, OriginImpl origin, String[] phaseNames) throws TauPException {
        return this.calcTravelTimes(Location.of(channel), origin, phaseNames);
    }

    public synchronized List<Arrival> calcTravelTimes(Location stationLoc, OriginImpl origin, String[] phaseNames) throws TauPException {
        QuantityImpl depth = origin.getLocation().depth;
        double depthVal = (depth = depth.convertTo(UnitImpl.KILOMETER)).getValue();
        if (depthVal < 0.0) {
            logger.info("depth negative not allowed, setting to zero");
            depthVal = 0.0;
        }
        DistAz distAz = new DistAz(stationLoc, origin.getLocation());
        return this.calcTravelTimes(distAz.getDelta(), depthVal, phaseNames);
    }

    public synchronized List<Arrival> calcTravelTimes(double distDeg, double depthKm, String[] phaseNames) throws TauPException {
        this.taup_time.setSourceDepth(depthKm);
        this.taup_time.clearPhaseNames();
        for (int i = 0; i < phaseNames.length; ++i) {
            this.taup_time.appendPhaseName(phaseNames[i]);
        }
        this.taup_time.calculate(distDeg);
        List arrivals = this.taup_time.getArrivals();
        return arrivals;
    }

    public TauModel getTauModel() {
        return this.taup_time.getTauModel();
    }

    public static synchronized TauPUtil getTauPUtil() {
        try {
            return TauPUtil.getTauPUtil("prem");
        }
        catch (TauModelException e) {
            throw new RuntimeException("Should never happen as prem is bundled with TauP", e);
        }
    }

    public static synchronized TauPUtil getTauPUtil(String modelName) throws TauModelException {
        if (!taupUtilMap.containsKey(modelName)) {
            taupUtilMap.put(modelName, new TauPUtil(modelName));
        }
        return taupUtilMap.get(modelName);
    }
}

