/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.sod.bag.LocalSeismogramFunction;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;

public class Taper
implements LocalSeismogramFunction {
    public static int HANNING = 0;
    public static int HAMMING = 1;
    public static int COSINE = 2;
    float width;
    int type;

    public Taper() {
        this(0.05f);
    }

    public Taper(float width) {
        this(HANNING, width);
    }

    public Taper(int type, float width) {
        if (width >= 0.5f) {
            throw new IllegalArgumentException("width cannot be larger than .5, width=" + width);
        }
        this.type = type;
        this.width = width;
    }

    @Override
    public LocalSeismogramImpl apply(LocalSeismogramImpl seis) throws FissuresException {
        if (seis.can_convert_to_float()) {
            float[] fSeries = seis.get_as_floats();
            return new LocalSeismogramImpl((SeismogramAttrImpl)seis, this.apply(fSeries));
        }
        double[] dSeries = seis.get_as_doubles();
        return new LocalSeismogramImpl((SeismogramAttrImpl)seis, this.apply(dSeries));
    }

    public float[] apply(float[] data) {
        float[] out = new float[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(float[] data) {
        int w = Math.round((float)data.length * this.width);
        double[] coeff = this.getCoefficients(w);
        double omega = coeff[0];
        double f0 = coeff[1];
        double f1 = coeff[2];
        for (int i = 0; i < w; ++i) {
            data[i] = (float)((double)data[i] * (f0 - f1 * Math.cos(omega * (double)i)));
            data[data.length - i - 1] = (float)((double)data[data.length - i - 1] * (f0 - f1 * Math.cos(omega * (double)i)));
        }
    }

    public double[] apply(double[] data) {
        double[] out = new double[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(double[] data) {
        int w = Math.round((float)data.length * this.width);
        double[] coeff = this.getCoefficients(w);
        double omega = coeff[0];
        double f0 = coeff[1];
        double f1 = coeff[2];
        for (int i = 0; i < w; ++i) {
            data[i] = data[i] * (f0 - f1 * Math.cos(omega * (double)i));
            data[data.length - i - 1] = data[data.length - i - 1] * (f0 - f1 * Math.cos(omega * (double)i));
        }
    }

    public short[] apply(short[] data) {
        short[] out = new short[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(short[] data) {
        int w = Math.round((float)data.length * this.width);
        double[] coeff = this.getCoefficients(w);
        double omega = coeff[0];
        double f0 = coeff[1];
        double f1 = coeff[2];
        for (int i = 0; i < w; ++i) {
            data[i] = (short)Math.round((double)data[i] * (f0 - f1 * Math.cos(omega * (double)i)));
            data[data.length - i - 1] = (short)Math.round((double)data[data.length - i - 1] * (f0 - f1 * Math.cos(omega * (double)i)));
        }
    }

    public int[] apply(int[] data) {
        int[] out = new int[data.length];
        System.arraycopy(data, 0, out, 0, data.length);
        this.applyInPlace(out);
        return out;
    }

    public void applyInPlace(int[] data) {
        int w = Math.round((float)data.length * this.width);
        double[] coeff = this.getCoefficients(w);
        double omega = coeff[0];
        double f0 = coeff[1];
        double f1 = coeff[2];
        for (int i = 0; i < w; ++i) {
            data[i] = (int)Math.round((double)data[i] * (f0 - f1 * Math.cos(omega * (double)i)));
            data[data.length - i - 1] = (int)Math.round((double)data[data.length - i - 1] * (f0 - f1 * Math.cos(omega * (double)i)));
        }
    }

    double[] getCoefficients(int length) {
        double[] out = new double[3];
        if (this.type == HANNING) {
            out[0] = Math.PI / (double)length;
            out[1] = 0.5;
            out[2] = 0.5;
        } else if (this.type == HAMMING) {
            out[0] = Math.PI / (double)length;
            out[1] = 0.54f;
            out[2] = 0.46f;
        } else {
            out[0] = 1.5707963267948966 / (double)length;
            out[1] = 1.0;
            out[2] = 1.0;
        }
        return out;
    }
}

