/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.QuantityImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import java.util.List;

public class Statistics {
    protected int[] iSeries;
    protected short[] sSeries;
    protected float[] fSeries;
    protected double[] dSeries;
    protected boolean minMaxMeanCalculated = false;
    protected double[] minMaxMean = new double[3];
    protected double variance;
    protected boolean varianceCalculated = false;
    protected double[] autocorrelation = new double[0];
    protected double[] partialautocorr = new double[0];
    protected int beginIndex;
    protected int endIndex;
    private static int SPLIT_SUMMING_LIMIT = 16;

    public Statistics(int[] iSeries) {
        if (iSeries.length == 0) {
            throw new IllegalArgumentException("Data length is zero");
        }
        this.iSeries = iSeries;
        this.beginIndex = 0;
        this.endIndex = iSeries.length;
    }

    public Statistics(short[] sSeries) {
        if (sSeries.length == 0) {
            throw new IllegalArgumentException("Data length is zero");
        }
        this.sSeries = sSeries;
        this.beginIndex = 0;
        this.endIndex = sSeries.length;
    }

    public Statistics(float[] fSeries) {
        if (fSeries.length == 0) {
            throw new IllegalArgumentException("Data length is zero");
        }
        this.fSeries = fSeries;
        this.beginIndex = 0;
        this.endIndex = fSeries.length;
    }

    public Statistics(double[] dSeries) {
        if (dSeries.length == 0) {
            throw new IllegalArgumentException("Data length is zero");
        }
        this.dSeries = dSeries;
        this.beginIndex = 0;
        this.endIndex = dSeries.length;
    }

    public Statistics(LocalSeismogramImpl seismo) throws FissuresException {
        if (seismo.getNumPoints() == 0) {
            throw new IllegalArgumentException("Data length is zero");
        }
        if (seismo.can_convert_to_short()) {
            this.sSeries = seismo.get_as_shorts();
            this.endIndex = this.sSeries.length;
        } else if (seismo.can_convert_to_long()) {
            this.iSeries = seismo.get_as_longs();
            this.endIndex = this.iSeries.length;
        } else if (seismo.can_convert_to_float()) {
            this.fSeries = seismo.get_as_floats();
            this.endIndex = this.fSeries.length;
        } else {
            this.dSeries = seismo.get_as_doubles();
            this.endIndex = this.dSeries.length;
        }
        this.beginIndex = 0;
    }

    public Statistics(List<QuantityImpl> vals) {
        this(vals, vals.size() != 0 ? vals.get(0).getUnit() : UnitImpl.UNKNOWN);
    }

    public Statistics(List<QuantityImpl> vals, UnitImpl unit) {
        if (vals.size() == 0) {
            throw new IllegalArgumentException("Data length is zero");
        }
        this.dSeries = new double[vals.size()];
        for (int i = 0; i < this.dSeries.length; ++i) {
            QuantityImpl q = vals.get(i);
            this.dSeries[i] = q.getValue(unit);
            this.endIndex = this.dSeries.length;
        }
        this.beginIndex = 0;
    }

    public double min() {
        return this.minMaxMean()[0];
    }

    public double min(int beginIndex, int endIndex) {
        return this.minMaxMean(beginIndex, endIndex)[0];
    }

    public double max() {
        return this.minMaxMean()[1];
    }

    public double max(int beginIndex, int endIndex) {
        return this.minMaxMean(beginIndex, endIndex)[1];
    }

    public double maxDeviation() {
        return Math.max(Math.abs(this.max() - this.mean()), Math.abs(this.min() - this.mean()));
    }

    public double maxDeviation(int beginIndex, int endIndex) {
        return Math.max(Math.abs(this.max(beginIndex, endIndex) - this.mean(beginIndex, endIndex)), Math.abs(this.min(beginIndex, endIndex) - this.mean(beginIndex, endIndex)));
    }

    public double mean() {
        return this.minMaxMean()[2];
    }

    public double mean(int beginIndex, int endIndex) {
        return this.minMaxMean(beginIndex, endIndex)[2];
    }

    public double[] minMaxMean() {
        return this.minMaxMean(0, this.getLength());
    }

    public double[] minMaxMean(int beginIndex, int endIndex) {
        if (beginIndex < 0) {
            throw new IllegalArgumentException("begin Index < 0 " + beginIndex);
        }
        if (endIndex > this.getLength()) {
            throw new IllegalArgumentException("end Index > data length " + endIndex);
        }
        if (this.minMaxMeanCalculated) {
            int newDataEnd;
            int newDataStart;
            int removalEnd;
            int removalStart;
            if (beginIndex == this.beginIndex && endIndex == this.endIndex) {
                return this.minMaxMean;
            }
            this.flushCache();
            if (this.beginIndex > beginIndex && this.endIndex < endIndex || this.beginIndex < beginIndex && this.endIndex > endIndex) {
                this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                return this.minMaxMean;
            }
            if (this.beginIndex < beginIndex || this.endIndex < endIndex) {
                removalStart = this.beginIndex;
                removalEnd = beginIndex - 1;
                newDataStart = this.endIndex;
                newDataEnd = endIndex - 1;
            } else {
                removalStart = endIndex;
                removalEnd = this.endIndex - 1;
                newDataStart = beginIndex;
                newDataEnd = this.beginIndex;
            }
            this.minMaxMean[2] = this.minMaxMean[2] * (double)(this.endIndex - this.beginIndex);
            if (this.iSeries != null) {
                int j;
                for (j = removalStart; j <= removalEnd; ++j) {
                    if ((double)this.iSeries[j] <= this.minMaxMean[0]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    if ((double)this.iSeries[j] >= this.minMaxMean[1]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] - (double)this.iSeries[j];
                }
                for (j = newDataStart; j <= newDataEnd; ++j) {
                    if ((double)this.iSeries[j] < this.minMaxMean[0]) {
                        this.minMaxMean[0] = this.iSeries[j];
                    }
                    if ((double)this.iSeries[j] > this.minMaxMean[1]) {
                        this.minMaxMean[1] = this.iSeries[j];
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] + (double)this.iSeries[j];
                }
            } else if (this.sSeries != null) {
                int j;
                for (j = removalStart; j <= removalEnd; ++j) {
                    if ((double)this.sSeries[j] <= this.minMaxMean[0]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    if ((double)this.sSeries[j] >= this.minMaxMean[1]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] - (double)this.sSeries[j];
                }
                for (j = newDataStart; j <= newDataEnd; ++j) {
                    if ((double)this.sSeries[j] < this.minMaxMean[0]) {
                        this.minMaxMean[0] = this.sSeries[j];
                    }
                    if ((double)this.sSeries[j] > this.minMaxMean[1]) {
                        this.minMaxMean[1] = this.sSeries[j];
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] + (double)this.sSeries[j];
                }
            } else if (this.fSeries != null) {
                int j;
                for (j = removalStart; j <= removalEnd; ++j) {
                    if ((double)this.fSeries[j] <= this.minMaxMean[0]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    if ((double)this.fSeries[j] >= this.minMaxMean[1]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] - (double)this.fSeries[j];
                }
                for (j = newDataStart; j <= newDataEnd; ++j) {
                    if ((double)this.fSeries[j] < this.minMaxMean[0]) {
                        this.minMaxMean[0] = this.fSeries[j];
                    }
                    if ((double)this.fSeries[j] > this.minMaxMean[1]) {
                        this.minMaxMean[1] = this.fSeries[j];
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] + (double)this.fSeries[j];
                }
            } else if (this.dSeries != null) {
                int j;
                for (j = removalStart; j <= removalEnd; ++j) {
                    if (this.dSeries[j] <= this.minMaxMean[0]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    if (this.dSeries[j] >= this.minMaxMean[1]) {
                        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
                        return this.minMaxMean;
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] - this.dSeries[j];
                }
                for (j = newDataStart; j <= newDataEnd; ++j) {
                    if (this.dSeries[j] < this.minMaxMean[0]) {
                        this.minMaxMean[0] = this.dSeries[j];
                    }
                    if (this.dSeries[j] > this.minMaxMean[1]) {
                        this.minMaxMean[1] = this.dSeries[j];
                    }
                    this.minMaxMean[2] = this.minMaxMean[2] + this.dSeries[j];
                }
            }
            this.beginIndex = beginIndex;
            this.endIndex = endIndex;
            this.minMaxMeanCalculated = true;
            return this.minMaxMean;
        }
        this.minMaxMean = this.calculateMinMaxMean(beginIndex, endIndex);
        return this.minMaxMean;
    }

    private double[] calculateMinMaxMean(int beginIndex, int endIndex) {
        if (beginIndex == endIndex) {
            throw new RuntimeException("division by zero in mean");
        }
        double[] outMinMaxMean = new double[]{Double.POSITIVE_INFINITY, Double.NEGATIVE_INFINITY, 0.0};
        if (this.iSeries != null) {
            for (int i = beginIndex; i < endIndex; ++i) {
                outMinMaxMean[0] = Math.min(outMinMaxMean[0], (double)this.iSeries[i]);
                outMinMaxMean[1] = Math.max(outMinMaxMean[1], (double)this.iSeries[i]);
                outMinMaxMean[2] = outMinMaxMean[2] + (double)this.iSeries[i];
            }
        } else if (this.sSeries != null) {
            for (int i = beginIndex; i < endIndex; ++i) {
                outMinMaxMean[0] = Math.min(outMinMaxMean[0], (double)this.sSeries[i]);
                outMinMaxMean[1] = Math.max(outMinMaxMean[1], (double)this.sSeries[i]);
                outMinMaxMean[2] = outMinMaxMean[2] + (double)this.sSeries[i];
            }
        } else if (this.fSeries != null) {
            for (int i = beginIndex; i < endIndex; ++i) {
                outMinMaxMean[0] = Math.min(outMinMaxMean[0], (double)this.fSeries[i]);
                outMinMaxMean[1] = Math.max(outMinMaxMean[1], (double)this.fSeries[i]);
                outMinMaxMean[2] = outMinMaxMean[2] + (double)this.fSeries[i];
            }
        } else if (this.dSeries != null) {
            for (int i = beginIndex; i < endIndex; ++i) {
                outMinMaxMean[0] = Math.min(outMinMaxMean[0], this.dSeries[i]);
                outMinMaxMean[1] = Math.max(outMinMaxMean[1], this.dSeries[i]);
                outMinMaxMean[2] = outMinMaxMean[2] + this.dSeries[i];
            }
        }
        outMinMaxMean[2] = outMinMaxMean[2] / (double)(endIndex - beginIndex);
        return outMinMaxMean;
    }

    public double var() {
        if (!this.varianceCalculated) {
            this.variance = this.var(this.mean());
        }
        return this.variance;
    }

    public double var(double mean) {
        if (this.getLength() == 1) {
            throw new RuntimeException("Data length is " + this.getLength());
        }
        return this.binarySumDevSqr(0, this.getLength(), mean) / (double)(this.getLength() - 1);
    }

    public double rms() {
        return Math.sqrt(this.var(0.0));
    }

    public double stddev() {
        return Math.sqrt(this.var());
    }

    public double covariance(double[] other) {
        return this.covariance(new Statistics(other));
    }

    public double covariance(Statistics otherStat) {
        if (otherStat.dSeries.length != this.dSeries.length) {
            throw new IllegalArgumentException("covariance cannot be calculated if the data series are not of the same length: " + this.dSeries.length + " != " + otherStat.dSeries.length);
        }
        double ourMean = this.mean();
        double otherMean = otherStat.mean();
        double covar = 0.0;
        for (int i = 0; i < otherStat.dSeries.length; ++i) {
            covar += this.dSeries[i] * otherStat.dSeries[i];
        }
        covar /= (double)otherStat.dSeries.length;
        return covar -= ourMean * otherMean;
    }

    public double correlation(double[] other) {
        Statistics otherStat = new Statistics(other);
        double covar = this.covariance(otherStat);
        if (this.stddev() == 0.0) {
            throw new ArithmeticException("divide by zero if stddev == 0");
        }
        if (otherStat.stddev() == 0.0) {
            throw new ArithmeticException("divide by zero if other.stddev == 0");
        }
        return covar / otherStat.stddev() / this.stddev();
    }

    public double[] linearLeastSquares() {
        int n = this.getLength() - 1;
        double sumToN = 1.0 * (double)n * (double)(n + 1) / 2.0;
        double sumSqrToN = 1.0 * (double)n * (double)(n + 1) * (double)(2 * n + 1) / 6.0;
        double sumValues = this.binarySum(0, this.getLength());
        double indexSumValues = this.binaryIndexSum(0, this.getLength());
        double d = (double)(n + 1) * sumSqrToN - sumToN * sumToN;
        double[] out = new double[]{(sumSqrToN * sumValues - sumToN * indexSumValues) / d, ((double)(n + 1) * indexSumValues - sumToN * sumValues) / d};
        return out;
    }

    public double[] acf(int maxlag) {
        if (this.autocorrelation.length < maxlag + 1) {
            double[] tmp = new double[maxlag + 1];
            System.arraycopy(this.autocorrelation, 0, tmp, 0, this.autocorrelation.length);
            double normalizer = this.binarySumDevSqr(0, this.getLength(), this.mean());
            for (int i = this.autocorrelation.length; i < maxlag + 1; ++i) {
                tmp[i] = this.binarySumDevLag(0, this.getLength(), this.mean(), i) / normalizer;
            }
            this.autocorrelation = tmp;
        }
        return this.autocorrelation;
    }

    public double[] acf95conf(int maxlag) {
        double[] acfVals = this.acf(maxlag);
        double[] out = new double[acfVals.length];
        double sumsqrs = 0.0;
        for (int i = 0; i < acfVals.length; ++i) {
            out[i] = 1.96 * Math.sqrt(1.0 + 2.0 * (sumsqrs += acfVals[i] * acfVals[i])) / Math.sqrt(this.getLength());
        }
        return out;
    }

    public double[] acfTRatio(int maxlag) {
        double[] acfVals = this.acf(maxlag);
        double[] conf = this.acf95conf(maxlag);
        double[] out = new double[acfVals.length];
        for (int i = 0; i < acfVals.length; ++i) {
            out[i] = 1.96 * Math.abs(acfVals[i]) / conf[i];
        }
        return out;
    }

    public double[] pacf(int maxlag) {
        if (this.partialautocorr.length < maxlag) {
            int k;
            double[] tmp = new double[maxlag];
            System.arraycopy(this.partialautocorr, 0, tmp, 0, this.partialautocorr.length);
            double[] myacf = this.acf(maxlag);
            double[][] pacfMatrix = new double[maxlag + 1][maxlag + 1];
            pacfMatrix[1][1] = myacf[1];
            for (k = 2; k <= maxlag; ++k) {
                int j;
                double topSum = 0.0;
                double botSum = 0.0;
                for (j = 1; j < k; ++j) {
                    topSum += pacfMatrix[k - 1][j] * myacf[k - j];
                    botSum += pacfMatrix[k - 1][j] * myacf[j];
                }
                pacfMatrix[k][k] = (myacf[k] - topSum) / (1.0 - botSum);
                for (j = 1; j < k; ++j) {
                    pacfMatrix[k][j] = pacfMatrix[k - 1][j] - pacfMatrix[k][k] * pacfMatrix[k - 1][k - j];
                }
            }
            this.partialautocorr = new double[maxlag + 1];
            this.partialautocorr[0] = 1.0;
            for (k = 1; k <= maxlag; ++k) {
                this.partialautocorr[k] = pacfMatrix[k][k];
            }
        }
        return this.partialautocorr;
    }

    public double pacf95conf(int maxlag) {
        double out = 1.96 / Math.sqrt(this.getLength());
        return out;
    }

    public double[] pacfTRatio(int maxlag) {
        double[] pacfVals = this.pacf(maxlag);
        double conf = this.pacf95conf(maxlag);
        double[] out = new double[pacfVals.length];
        for (int i = 0; i < pacfVals.length; ++i) {
            out[i] = 1.96 * Math.abs(pacfVals[i]) / conf;
        }
        return out;
    }

    public int getLength() {
        if (this.iSeries != null) {
            return this.iSeries.length;
        }
        if (this.sSeries != null) {
            return this.sSeries.length;
        }
        if (this.fSeries != null) {
            return this.fSeries.length;
        }
        if (this.dSeries != null) {
            return this.dSeries.length;
        }
        return 0;
    }

    public int[] histogram(double start, double width, int number) {
        int[] histo = new int[number];
        if (this.iSeries != null) {
            for (int i = 0; i < this.iSeries.length; ++i) {
                int bin = (int)Math.floor(((double)this.iSeries[i] - start) / width);
                if (bin < 0 || bin >= number) continue;
                int n = bin;
                histo[n] = histo[n] + 1;
            }
            return histo;
        }
        if (this.sSeries != null) {
            for (int i = 0; i < this.sSeries.length; ++i) {
                int bin = (int)Math.floor(((double)this.sSeries[i] - start) / width);
                if (bin < 0 || bin >= number) continue;
                int n = bin;
                histo[n] = histo[n] + 1;
            }
            return histo;
        }
        if (this.fSeries != null) {
            for (int i = 0; i < this.fSeries.length; ++i) {
                int bin = (int)Math.floor(((double)this.fSeries[i] - start) / width);
                if (bin < 0 || bin >= number) continue;
                int n = bin;
                histo[n] = histo[n] + 1;
            }
            return histo;
        }
        if (this.dSeries != null) {
            for (int i = 0; i < this.dSeries.length; ++i) {
                int bin = (int)Math.floor((this.dSeries[i] - start) / width);
                if (bin < 0 || bin >= number) continue;
                int n = bin;
                histo[n] = histo[n] + 1;
            }
            return histo;
        }
        return new int[0];
    }

    public String toString() {
        Object out = this.nv("Length", this.getLength());
        out = (String)out + this.nv("Min", this.min());
        out = (String)out + this.nv("Max", this.max());
        out = (String)out + this.nv("Mean", this.mean());
        out = (String)out + this.nv("Var", this.var());
        out = (String)out + this.nv("StdDev", this.stddev());
        return out;
    }

    private String nv(String name, double val) {
        return name + ": " + val + "\n";
    }

    public double binarySum(int start, int finish) {
        if (this.iSeries != null) {
            return this.iBinarySum(start, finish);
        }
        if (this.sSeries != null) {
            return this.sBinarySum(start, finish);
        }
        if (this.fSeries != null) {
            return this.fBinarySum(start, finish);
        }
        if (this.dSeries != null) {
            return this.dBinarySum(start, finish);
        }
        return 0.0;
    }

    private double iBinarySum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)this.iSeries[i];
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.iBinarySum(start, middle) + this.iBinarySum(middle, finish);
    }

    private double sBinarySum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)this.sSeries[i];
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.sBinarySum(start, middle) + this.sBinarySum(middle, finish);
    }

    private double fBinarySum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)this.fSeries[i];
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.fBinarySum(start, middle) + this.fBinarySum(middle, finish);
    }

    private double dBinarySum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += this.dSeries[i];
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.dBinarySum(start, middle) + this.dBinarySum(middle, finish);
    }

    public double binarySumDevSqr(int start, int finish, double mean) {
        if (this.iSeries != null) {
            return this.iBinarySumDevSqr(start, finish, mean);
        }
        if (this.sSeries != null) {
            return this.sBinarySumDevSqr(start, finish, mean);
        }
        if (this.fSeries != null) {
            return this.fBinarySumDevSqr(start, finish, mean);
        }
        if (this.dSeries != null) {
            return this.dBinarySumDevSqr(start, finish, mean);
        }
        return 0.0;
    }

    private double iBinarySumDevSqr(int start, int finish, double mean) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += ((double)this.iSeries[i] - mean) * ((double)this.iSeries[i] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.iBinarySumDevSqr(start, middle, mean) + this.iBinarySumDevSqr(middle, finish, mean);
    }

    private double sBinarySumDevSqr(int start, int finish, double mean) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += ((double)this.sSeries[i] - mean) * ((double)this.sSeries[i] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.sBinarySumDevSqr(start, middle, mean) + this.sBinarySumDevSqr(middle, finish, mean);
    }

    private double fBinarySumDevSqr(int start, int finish, double mean) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += ((double)this.fSeries[i] - mean) * ((double)this.fSeries[i] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.fBinarySumDevSqr(start, middle, mean) + this.fBinarySumDevSqr(middle, finish, mean);
    }

    private double dBinarySumDevSqr(int start, int finish, double mean) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (this.dSeries[i] - mean) * (this.dSeries[i] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.dBinarySumDevSqr(start, middle, mean) + this.dBinarySumDevSqr(middle, finish, mean);
    }

    public double binarySumDevLag(int start, int finish, double mean, int lag) {
        if (this.iSeries != null) {
            return this.iBinarySumDevLag(start, finish, mean, lag);
        }
        if (this.sSeries != null) {
            return this.sBinarySumDevLag(start, finish, mean, lag);
        }
        if (this.fSeries != null) {
            return this.fBinarySumDevLag(start, finish, mean, lag);
        }
        if (this.dSeries != null) {
            return this.dBinarySumDevLag(start, finish, mean, lag);
        }
        return 0.0;
    }

    private double iBinarySumDevLag(int start, int finish, double mean, int lag) {
        if (finish - start < lag + SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish && i < this.getLength() - lag; ++i) {
                val += ((double)this.iSeries[i] - mean) * ((double)this.iSeries[i + lag] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.iBinarySumDevLag(start, middle, mean, lag) + this.iBinarySumDevLag(middle, finish, mean, lag);
    }

    private double sBinarySumDevLag(int start, int finish, double mean, int lag) {
        if (finish - start < lag + SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish && i < this.getLength() - lag; ++i) {
                val += ((double)this.sSeries[i] - mean) * ((double)this.sSeries[i + lag] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.sBinarySumDevLag(start, middle, mean, lag) + this.sBinarySumDevLag(middle, finish, mean, lag);
    }

    private double fBinarySumDevLag(int start, int finish, double mean, int lag) {
        if (finish - start < lag + SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish && i < this.getLength() - lag; ++i) {
                val += ((double)this.fSeries[i] - mean) * ((double)this.fSeries[i + lag] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.fBinarySumDevLag(start, middle, mean, lag) + this.fBinarySumDevLag(middle, finish, mean, lag);
    }

    private double dBinarySumDevLag(int start, int finish, double mean, int lag) {
        if (finish - start < lag + SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish && i < this.getLength() - lag; ++i) {
                val += (this.dSeries[i] - mean) * (this.dSeries[i + lag] - mean);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.dBinarySumDevLag(start, middle, mean, lag) + this.dBinarySumDevLag(middle, finish, mean, lag);
    }

    public double binaryIndexSum(int start, int finish) {
        if (this.iSeries != null) {
            return this.iBinaryIndexSum(start, finish);
        }
        if (this.sSeries != null) {
            return this.sBinaryIndexSum(start, finish);
        }
        if (this.fSeries != null) {
            return this.fBinaryIndexSum(start, finish);
        }
        if (this.dSeries != null) {
            return this.dBinaryIndexSum(start, finish);
        }
        throw new RuntimeException("All data arrays are null (int, short, float and double), This should never happen");
    }

    private double iBinaryIndexSum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)(i * this.iSeries[i]);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.iBinaryIndexSum(start, middle) + this.iBinaryIndexSum(middle, finish);
    }

    private double sBinaryIndexSum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)(i * this.sSeries[i]);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.sBinaryIndexSum(start, middle) + this.sBinaryIndexSum(middle, finish);
    }

    private double fBinaryIndexSum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)((float)i * this.fSeries[i]);
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.fBinaryIndexSum(start, middle) + this.fBinaryIndexSum(middle, finish);
    }

    private double dBinaryIndexSum(int start, int finish) {
        if (finish - start < SPLIT_SUMMING_LIMIT) {
            double val = 0.0;
            for (int i = start; i < finish; ++i) {
                val += (double)i * this.dSeries[i];
            }
            return val;
        }
        int middle = (start + finish) / 2;
        return this.dBinaryIndexSum(start, middle) + this.dBinaryIndexSum(middle, finish);
    }

    private void flushCache() {
        this.minMaxMeanCalculated = false;
        this.varianceCalculated = false;
    }
}

