/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.TauP.Arrival;
import edu.sc.seis.TauP.TauModelException;
import edu.sc.seis.TauP.TauPException;
import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.sod.bag.LongShortTrigger;
import edu.sc.seis.sod.bag.PhaseCut;
import edu.sc.seis.sod.bag.PhaseNonExistent;
import edu.sc.seis.sod.bag.Statistics;
import edu.sc.seis.sod.bag.TauPUtil;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.Location;
import edu.sc.seis.sod.model.event.OriginImpl;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

public class SimplePhaseStoN {
    protected String phase;
    protected String longPhase;
    protected Duration shortOffsetBegin;
    protected Duration shortOffsetEnd;
    protected Duration longOffsetBegin;
    protected Duration longOffsetEnd;
    protected PhaseCut shortCut;
    protected PhaseCut longCut;
    protected TauPUtil taup;

    public SimplePhaseStoN(String phase, Duration shortOffsetBegin, Duration shortOffsetEnd, String longPhase, Duration longOffsetBegin, Duration longOffsetEnd, TauPUtil taup) throws TauModelException {
        this.phase = phase;
        this.longPhase = longPhase;
        this.shortOffsetBegin = shortOffsetBegin;
        this.shortOffsetEnd = shortOffsetEnd;
        this.longOffsetBegin = longOffsetBegin;
        this.longOffsetEnd = longOffsetEnd;
        if (shortOffsetBegin == null) {
            throw new NullPointerException("shortOffsetBegin cannot be null");
        }
        if (shortOffsetEnd == null) {
            throw new NullPointerException("shortOffsetEnd cannot be null");
        }
        if (longOffsetBegin == null) {
            throw new NullPointerException("longOffsetBegin cannot be null");
        }
        if (longOffsetEnd == null) {
            throw new NullPointerException("longOffsetEnd cannot be null");
        }
        this.taup = taup;
        this.shortCut = new PhaseCut(taup, phase, shortOffsetBegin, phase, shortOffsetEnd);
        this.longCut = new PhaseCut(taup, longPhase, longOffsetBegin, longPhase, longOffsetEnd);
    }

    public SimplePhaseStoN(String phase, Duration shortOffsetBegin, Duration shortOffsetEnd, Duration longOffsetBegin, Duration longOffsetEnd, TauPUtil taup) throws TauModelException {
        this(phase, shortOffsetBegin, shortOffsetEnd, phase, longOffsetBegin, longOffsetEnd, taup);
    }

    public SimplePhaseStoN(String phase, Duration shortOffsetBegin, Duration shortOffsetEnd, Duration longOffsetBegin, Duration longOffsetEnd) throws TauModelException {
        this(phase, shortOffsetBegin, shortOffsetEnd, phase, longOffsetBegin, longOffsetEnd);
    }

    public SimplePhaseStoN(String phase, Duration shortOffsetBegin, Duration shortOffsetEnd, String longPhase, Duration longOffsetBegin, Duration longOffsetEnd) throws TauModelException {
        this(phase, shortOffsetBegin, shortOffsetEnd, longPhase, longOffsetBegin, longOffsetEnd, TauPUtil.getTauPUtil("prem"));
    }

    public SimplePhaseStoN(String phase) throws TauModelException {
        this(phase, Duration.ofSeconds(-1L), Duration.ofSeconds(5L), Duration.ofSeconds(-100L), Duration.ofSeconds(-5L));
    }

    public LongShortTrigger process(Location stationLoc, OriginImpl origin, LocalSeismogramImpl seis) throws FissuresException, TauPException, PhaseNonExistent {
        LocalSeismogramImpl shortSeis = this.shortCut.cut(stationLoc, origin, seis);
        LocalSeismogramImpl longSeis = this.longCut.cut(stationLoc, origin, seis);
        if (shortSeis == null || longSeis == null || shortSeis.getNumPoints() <= 1 || longSeis.getNumPoints() <= 1) {
            return null;
        }
        Statistics longStat = new Statistics(longSeis);
        double denominator = longStat.stddev();
        if (denominator == 0.0) {
            return null;
        }
        Statistics shortStat = new Statistics(shortSeis);
        double numerator = Math.sqrt(shortStat.var(longStat.mean()));
        List<Arrival> arrivals = this.taup.calcTravelTimes(stationLoc, origin, new String[]{this.phase});
        Instant phaseTime = null;
        Instant originTime = origin.getOriginTime();
        if (arrivals.size() != 0) {
            phaseTime = originTime.plus(TimeUtils.durationFromSeconds((double)arrivals.get(0).getTime()));
        }
        Duration sampPeriod = seis.getSampling().getPeriod();
        int phaseIndex = (int)(TimeUtils.durationToDoubleSeconds((Duration)Duration.between(seis.getBeginTime(), phaseTime)) / TimeUtils.durationToDoubleSeconds((Duration)sampPeriod));
        float ratio = (float)(numerator / denominator);
        return new LongShortTrigger(seis, phaseIndex, ratio, (float)numerator, (float)denominator);
    }
}

