/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.fdsnws.stationxml.Channel;
import edu.sc.seis.sod.model.common.SamplingImpl;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.station.SamplingRangeImpl;
import java.util.ArrayList;
import java.util.List;

public class SamplingUtil {
    public static List<Channel> inSampling(SamplingRangeImpl sampling, List<Channel> chans) {
        double minSPS = SamplingUtil.getSamplesPerSecond(sampling.min);
        double maxSPS = SamplingUtil.getSamplesPerSecond(sampling.max);
        ArrayList<Channel> results = new ArrayList<Channel>();
        for (Channel chan : chans) {
            double chanSPS = chan.getSampleRate().getValue();
            if (!(minSPS <= chanSPS) || !(chanSPS <= maxSPS)) continue;
            results.add(chan);
        }
        return results;
    }

    private static double getSamplesPerSecond(SamplingImpl sampling) {
        return sampling.getFrequency().getValue(UnitImpl.HERTZ);
    }
}

