/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import java.time.Duration;

public class SampleSynchronize {
    public static LocalSeismogramImpl alignTimes(LocalSeismogramImpl main, LocalSeismogramImpl shifty, double maxSamplingDiffRatio) throws FissuresException {
        Duration shiftyPeriod;
        Duration mainPeriod = main.getSampling().getPeriod();
        if ((double)mainPeriod.minus(shiftyPeriod = shifty.getSampling().getPeriod()).abs().toNanos() / (double)shiftyPeriod.toNanos() > maxSamplingDiffRatio) {
            throw new FissuresException("sample periods are not compatible: main=" + String.valueOf(mainPeriod) + "  shifty=" + String.valueOf(shiftyPeriod));
        }
        Duration misalign = Duration.between(main.getBeginTime(), shifty.getBeginTime());
        Duration moduleSamplePeriod = Duration.ofNanos(misalign.toNanos() % mainPeriod.toNanos());
        LocalSeismogramImpl out = new LocalSeismogramImpl((SeismogramAttrImpl)shifty, shifty.getData());
        out.begin_time = shifty.getBeginTime().minus(moduleSamplePeriod);
        out.sampling_info = main.getSampling();
        return out;
    }
}

