/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.TimeUtils;
import edu.sc.seis.seisFile.fdsnws.stationxml.BaseFilterType;
import edu.sc.seis.seisFile.fdsnws.stationxml.Coefficients;
import edu.sc.seis.seisFile.fdsnws.stationxml.FloatType;
import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.seisFile.fdsnws.stationxml.Pole;
import edu.sc.seis.seisFile.fdsnws.stationxml.PolesZeros;
import edu.sc.seis.seisFile.fdsnws.stationxml.Response;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseList;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseListElement;
import edu.sc.seis.seisFile.fdsnws.stationxml.ResponseStage;
import edu.sc.seis.seisFile.fdsnws.stationxml.Unit;
import edu.sc.seis.seisFile.fdsnws.stationxml.Zero;
import edu.sc.seis.sod.model.common.TimeRange;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.model.station.ChannelId;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Locale;

public class ResponsePrint {
    private static HashMap unitNames = new HashMap();
    static DateTimeFormatter mdyFormat;
    static DateTimeFormatter sdf;

    public static String printResponse(ChannelId chanId, Response response, TimeRange effective_time) {
        Instant stime = effective_time.getBeginTime();
        Instant etime = effective_time.getEndTime();
        InstrumentSensitivity sensitivity = response.getInstrumentSensitivity();
        StringBuffer r = new StringBuffer();
        r.append("\n#");
        r.append("\n###################################################################################");
        r.append("\n#");
        r.append("\nB050F03     Station:       " + chanId.getStationCode());
        r.append("\nB050F16     Network:       " + chanId.getNetworkId());
        r.append("\nB052F03     Location:      " + chanId.getLocCode());
        r.append("\nB052F04     Channel:       " + chanId.getChannelCode());
        r.append("\nB052F22     Start date:    " + sdf.format(stime));
        r.append("\nB052F23     End date:      " + sdf.format(etime));
        for (int i = 0; i < response.getResponseStageList().size(); ++i) {
            int stageNum = i + 1;
            ResponseStage stage = (ResponseStage)response.getResponseStageList().get(i);
            r.append(ResponsePrint.printB53(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB54(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB55(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB57(chanId, effective_time, stageNum, stage));
            r.append(ResponsePrint.printB58(chanId, effective_time, stageNum, stage));
        }
        r.append(ResponsePrint.printSensitivity(chanId, sensitivity, effective_time));
        return r.toString();
    }

    public static String printHeader(ChannelId id, TimeRange effective_time) {
        StringBuffer s = new StringBuffer("");
        s.append("#                   |        " + id.getNetworkId() + "  ");
        if (id.getStationCode().length() == 5) {
            s.append(id.getStationCode() + " ");
        }
        if (id.getStationCode().length() == 4) {
            s.append(id.getStationCode() + "  ");
        }
        if (id.getStationCode().length() == 3) {
            s.append(id.getStationCode() + "   ");
        }
        if (id.getStationCode().length() == 2) {
            s.append(id.getStationCode() + "    ");
        }
        if (id.getLocCode().length() == 1) {
            s.append(id.getLocCode() + "  ");
        }
        if (id.getLocCode().length() == 2) {
            s.append(id.getLocCode() + " ");
        }
        s.append(id.getChannelCode() + "           |\n");
        Instant stime = effective_time.getBeginTime();
        Instant etime = effective_time.getEndTime();
        s.append("#                   |     " + mdyFormat.format(stime));
        s.append(" to " + mdyFormat.format(etime) + "      |\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#\n");
        return s.toString();
    }

    public static String printB53(ChannelId id, TimeRange effective_time, int stageNum, ResponseStage stage) {
        int k;
        BaseFilterType filter = stage.getResponseItem();
        if (!(filter instanceof PolesZeros)) {
            return "";
        }
        PolesZeros pz = (PolesZeros)filter;
        String transferType = "";
        if (pz.getPzTransferType().equals("LAPLACE (RADIANS/SECOND)")) {
            transferType = "A";
        } else if (pz.getPzTransferType().equals("LAPLACE (HERTZ)")) {
            transferType = "B";
        } else if (pz.getPzTransferType().equals("DIGITAL (Z-TRANSFORM)")) {
            transferType = "D";
        }
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.US));
        DecimalFormat ind = new DecimalFormat(" 0", new DecimalFormatSymbols(Locale.US));
        StringBuffer s = new StringBuffer("\n#");
        s.append("\n#                   +-----------------------------------+");
        s.append("\n#                   |     Response (Poles and Zeros)    |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B053F03     Transfer function type:            " + transferType);
        s.append("\nB053F04     Stage sequence number:             " + stageNum);
        s.append("\nB053F05     Response in units lookup:          " + ResponsePrint.formatUnit(pz.getInputUnits()));
        s.append("\nB053F06     Response out units lookup:         " + ResponsePrint.formatUnit(pz.getOutputUnits()));
        s.append("\nB053F07     AO normalization factor:           ");
        s.append(f.format(pz.getNormalizationFactor()));
        s.append("\nB053F08     Normalization frequency:           ");
        s.append(f.format(pz.getNormalizationFreq()));
        s.append("\nB053F09     Number of zeroes:                  " + pz.getZeroList().size());
        s.append("\nB053F14     Number of poles:                   " + pz.getPoleList().size());
        if (pz.getZeroList().size() > 0) {
            s.append("\n#              Complex zeroes:");
            s.append("\n#               i  real          imag          real_error    imag_error");
            for (k = 0; k < pz.getZeroList().size(); ++k) {
                if (k < 10) {
                    s.append("\nB053F10-13      " + k + "  " + f.format(((Zero)pz.getZeroList().get(k)).getReal()) + "  " + f.format(((Zero)pz.getZeroList().get(k)).getImaginary()) + "  " + f.format(((Zero)pz.getZeroList().get(k)).getRealWithError().getPlusError()) + "  " + f.format(((Zero)pz.getZeroList().get(k)).getImaginaryWithError().getPlusError()));
                    continue;
                }
                s.append("\nB053F10-13     " + k + "  " + f.format(((Zero)pz.getZeroList().get(k)).getReal()) + "  " + f.format(((Zero)pz.getZeroList().get(k)).getImaginary()) + "  " + f.format(((Zero)pz.getZeroList().get(k)).getRealWithError().getPlusError()) + "  " + f.format(((Zero)pz.getZeroList().get(k)).getImaginaryWithError().getPlusError()));
            }
        }
        if (pz.getPoleList().size() > 0) {
            s.append("\n#              Complex poles:");
            s.append("\n#               i  real          imag          real_error    imag_error");
            for (k = 0; k < pz.getPoleList().size(); ++k) {
                if (k < 10) {
                    s.append("\nB053F15-18      " + k + "  " + f.format(((Pole)pz.getPoleList().get(k)).getReal()) + "  " + f.format(((Pole)pz.getPoleList().get(k)).getImaginary()) + "  " + f.format(((Pole)pz.getPoleList().get(k)).getRealWithError().getPlusError()) + "  " + f.format(((Pole)pz.getPoleList().get(k)).getImaginaryWithError().getPlusError()));
                    continue;
                }
                s.append("\nB053F15-18     " + k + "  " + f.format(((Pole)pz.getPoleList().get(k)).getReal()) + "  " + f.format(((Pole)pz.getPoleList().get(k)).getImaginary()) + "  " + f.format(((Pole)pz.getPoleList().get(k)).getRealWithError().getPlusError()) + "  " + f.format(((Pole)pz.getPoleList().get(k)).getImaginaryWithError().getPlusError()));
            }
        }
        s.append("\n#");
        return s.toString();
    }

    public static String printB54(ChannelId id, TimeRange effective_time, int stageNum, ResponseStage stage) {
        int k;
        BaseFilterType filter = stage.getResponseItem();
        if (!(filter instanceof Coefficients)) {
            return "";
        }
        Coefficients c = (Coefficients)filter;
        StringBuffer s = new StringBuffer("\n#");
        String transferType = "";
        if (c.getCfTransferType().equals("ANALOG (RADIANS/SECOND)")) {
            transferType = "A";
        } else if (c.getCfTransferType().equals("ANALOG (HERTZ)")) {
            transferType = "B";
        } else if (c.getCfTransferType().equals("DIGITAL")) {
            transferType = "D";
        }
        s.append("\n#                   +-----------------------------------+");
        s.append("\n#                   |       Response (Coefficients)     |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B054F03     Transfer function type:            " + transferType);
        s.append("\nB054F04     Stage sequence number:             " + stageNum);
        s.append("\nB054F05     Response in units lookup:          " + ResponsePrint.formatUnit(c.getInputUnits()));
        s.append("\nB054F06     Response out units lookup:         " + ResponsePrint.formatUnit(c.getOutputUnits()));
        s.append("\nB054F07     Number of numerators:              " + c.getNumeratorList().size());
        s.append("\nB054F10     Number of denominators:            " + c.getDenominatorList().size());
        s.append("\n#");
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.US));
        if (c.getNumeratorList().size() > 0) {
            s.append("\n#              Numerator coefficients:");
            s.append("\n#               i  coefficient   error");
            for (k = 0; k < c.getNumeratorList().size(); ++k) {
                if (k < 10) {
                    s.append("\nB054F08-09      " + k + "  " + f.format(((FloatType)c.getNumeratorList().get(k)).getValue()) + "  " + f.format(((FloatType)c.getNumeratorList().get(k)).getPlusError()));
                    continue;
                }
                s.append("\nB054F08-09     " + k + "  " + f.format(((FloatType)c.getNumeratorList().get(k)).getValue()) + "  " + f.format(((FloatType)c.getNumeratorList().get(k)).getPlusError()));
            }
        }
        if (c.getDenominatorList().size() > 0) {
            s.append("\n#              Denominator coefficients:");
            s.append("\n#               i  coefficient   error");
            for (k = 0; k < c.getDenominatorList().size(); ++k) {
                if (k < 10) {
                    s.append("\nB054F11-12      " + k + "  " + f.format(((FloatType)c.getDenominatorList().get(k)).getValue()) + "  " + f.format(((FloatType)c.getDenominatorList().get(k)).getPlusError()));
                    continue;
                }
                s.append("\nB054F11-12     " + k + "  " + f.format(((FloatType)c.getDenominatorList().get(k)).getValue()) + "  " + f.format(((FloatType)c.getDenominatorList().get(k)).getPlusError()));
            }
        }
        s.append("\n#");
        return s.toString();
    }

    public static String printB55(ChannelId id, TimeRange effective_time, int stageNum, ResponseStage stage) {
        BaseFilterType filter = stage.getResponseItem();
        if (!(filter instanceof ResponseList)) {
            return "";
        }
        ResponseList c = (ResponseList)filter;
        StringBuffer s = new StringBuffer("\n#");
        s.append("\n#                   +-----------------------------------+");
        s.append("\n#                   |       Response List               |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("\nB055F03     Stage sequence number:             " + stageNum);
        s.append("\nB055F04     Response in units lookup:          " + ResponsePrint.formatUnit(c.getInputUnits()));
        s.append("\nB055F05     Response out units lookup:         " + ResponsePrint.formatUnit(c.getOutputUnits()));
        s.append("\nB055F06     Number of responses listed:        " + c.getResponseElements().size());
        s.append("\n#");
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.US));
        DecimalFormat ind = new DecimalFormat(" 0", new DecimalFormatSymbols(Locale.US));
        if (c.getResponseElements().size() > 0) {
            s.append("\n#              i  frequency     amplitude     amplitude err phase angle   phase err");
            for (int k = 0; k < c.getResponseElements().size(); ++k) {
                ResponseListElement rle = (ResponseListElement)c.getResponseElements().get(k);
                if (k < 10) {
                    s.append("\nB055F07-11      " + k);
                } else {
                    s.append("\nB055F07-11     " + k);
                }
                s.append("  " + f.format(rle.getFrequency().getValue()));
                s.append("  " + f.format(rle.getAmplitude().getValue()));
                s.append("  " + f.format(rle.getAmplitude().getPlusError()));
                s.append("  " + f.format(rle.getPhase().getValue()));
                s.append("  " + f.format(rle.getPhase().getPlusError()));
            }
        }
        s.append("\n#");
        return s.toString();
    }

    public static String printB57(ChannelId id, TimeRange effective_time, int stageNum, ResponseStage stage) {
        if (stage.getDecimation() == null) {
            return "";
        }
        DecimalFormat f = new DecimalFormat("+0.0000E00;-0.0000E00", new DecimalFormatSymbols(Locale.US));
        StringBuffer s = new StringBuffer("#\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#                   |             Decimation            |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B057F03     Stage sequence number:             " + stageNum);
        s.append("\nB057F04     Input sample rate (HZ):            " + f.format(stage.getDecimation().getInputSampleRate()));
        s.append("\nB057F05     Decimation factor:                 " + stage.getDecimation().getFactor());
        s.append("\nB057F06     Decimation offset:                 " + stage.getDecimation().getOffset());
        s.append("\nB057F07     Estimated delay (seconds):         " + f.format(stage.getDecimation().getDelay().getValue()));
        s.append("\nB057F08     Correction applied (seconds):      " + f.format(stage.getDecimation().getCorrection().getValue()));
        s.append("\n#");
        return s.toString();
    }

    public static String printB58(ChannelId id, TimeRange effective_time, int stageNum, ResponseStage stage) {
        DecimalFormat f = new DecimalFormat("+0.00000E00;-0.00000E00", new DecimalFormatSymbols(Locale.US));
        StringBuffer s = new StringBuffer("#\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#                   |      Channel Sensitivity/Gain     |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("B058F03     Stage sequence number:             " + stageNum);
        s.append("\nB058F04     Sensitivity:                       " + f.format(stage.getStageSensitivity().getSensitivityValue()));
        s.append("\nB058F05     Frequency of sensitivity:          " + f.format(stage.getStageSensitivity().getFrequency()));
        s.append("\nB058F06     Number of calibrations:            0\n");
        return s.toString();
    }

    public static String printSensitivity(ChannelId id, Response response, TimeRange effectiveTime) {
        return ResponsePrint.printSensitivity(id, response.getInstrumentSensitivity(), effectiveTime);
    }

    public static String printSensitivity(ChannelId id, InstrumentSensitivity sensitivity, TimeRange effective_time) {
        StringBuffer s = new StringBuffer("#\n");
        s.append("#                   +-----------------------------------+\n");
        s.append("#                   |      Channel Sensitivity/Gain     |\n");
        s.append(ResponsePrint.printHeader(id, effective_time));
        s.append("#\n");
        s.append("B058F03     Stage sequence number:             0");
        s.append("\nB058F04     Sensitivity:                       " + sensitivity.getSensitivityValue());
        s.append("\nB058F05     Frequency of sensitivity:          " + sensitivity.getFrequency());
        s.append("\nB058F06     Number of calibrations:            0\n");
        return s.toString();
    }

    public static String formatUnit(Unit unit) {
        if (unit == null) {
            return "null";
        }
        try {
            UnitImpl impl = StationXMLToFissures.convertUnit(unit);
            for (UnitImpl key : unitNames.keySet()) {
                if (!impl.equals(key)) continue;
                return (String)unitNames.get(key);
            }
            return unit.toString();
        }
        catch (UnknownUnit e) {
            return unit.getName();
        }
    }

    public static void addToNameMap(UnitImpl unit, String name) {
        unitNames.put(unit, name);
    }

    static {
        ResponsePrint.addToNameMap(UnitImpl.VOLT, "V - Volts");
        ResponsePrint.addToNameMap(UnitImpl.COUNT, "COUNTS");
        ResponsePrint.addToNameMap(UnitImpl.METER_PER_SECOND, "M/S - Velocity in Meters/Second");
        ResponsePrint.addToNameMap(UnitImpl.NANOMETER, "NM");
        ResponsePrint.addToNameMap(UnitImpl.MILLIMETER, "MM");
        ResponsePrint.addToNameMap(UnitImpl.CENTIMETER, "CM");
        ResponsePrint.addToNameMap(UnitImpl.METER, "M");
        ResponsePrint.addToNameMap(UnitImpl.NANOMETER_PER_SECOND, "NM/S");
        ResponsePrint.addToNameMap(UnitImpl.MILLIMETER_PER_SECOND, "MM/S");
        ResponsePrint.addToNameMap(UnitImpl.CENTIMETER_PER_SECOND, "CM/S");
        ResponsePrint.addToNameMap(UnitImpl.NANOMETER_PER_SECOND_PER_SECOND, "NM/S**2");
        ResponsePrint.addToNameMap(UnitImpl.MILLIMETER_PER_SECOND_PER_SECOND, "MM/S**2");
        ResponsePrint.addToNameMap(UnitImpl.CENTIMETER_PER_SECOND_PER_SECOND, "CM/S**2");
        ResponsePrint.addToNameMap(UnitImpl.METER_PER_SECOND_PER_SECOND, "M/S**2");
        ResponsePrint.addToNameMap(UnitImpl.PASCAL, "P");
        ResponsePrint.addToNameMap(UnitImpl.TESLA, "T");
        mdyFormat = TimeUtils.createFormatter((String)"MM/dd/yyyy");
        sdf = TimeUtils.createFormatter((String)"yyyy,DDD,HH:mm:ss");
    }
}

