/*
 * Decompiled with CFR 0.152.
 */
package edu.sc.seis.sod.bag;

import edu.sc.seis.seisFile.fdsnws.stationxml.InstrumentSensitivity;
import edu.sc.seis.sod.model.common.FissuresException;
import edu.sc.seis.sod.model.common.UnitImpl;
import edu.sc.seis.sod.model.common.UnknownUnit;
import edu.sc.seis.sod.model.seismogram.LocalSeismogramImpl;
import edu.sc.seis.sod.model.seismogram.SeismogramAttrImpl;
import edu.sc.seis.sod.model.station.ChannelIdUtil;
import edu.sc.seis.sod.util.convert.stationxml.StationXMLToFissures;

public class ResponseGain {
    public static LocalSeismogramImpl apply(LocalSeismogramImpl seis, InstrumentSensitivity inst) throws FissuresException, UnknownUnit {
        if (!InstrumentSensitivity.isValid((InstrumentSensitivity)inst)) {
            throw new IllegalArgumentException("Invalid instrumentation for " + ChannelIdUtil.toString(seis.channel_id));
        }
        return ResponseGain.apply(seis, inst.getSensitivityValue(), StationXMLToFissures.convertUnit(inst.getInputUnits()));
    }

    public static LocalSeismogramImpl apply(LocalSeismogramImpl seis, float sensitivity_factor, UnitImpl initialUnits) throws FissuresException {
        LocalSeismogramImpl outSeis;
        if (seis.can_convert_to_float()) {
            float[] fSeries = seis.get_as_floats();
            float[] out = new float[fSeries.length];
            for (int i = 0; i < fSeries.length; ++i) {
                out[i] = fSeries[i] / sensitivity_factor;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
        } else {
            double[] dSeries = seis.get_as_doubles();
            double[] out = new double[dSeries.length];
            for (int i = 0; i < dSeries.length; ++i) {
                out[i] = dSeries[i] / (double)sensitivity_factor;
            }
            outSeis = new LocalSeismogramImpl((SeismogramAttrImpl)seis, out);
        }
        outSeis.y_unit = initialUnits;
        return outSeis;
    }
}

